/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.Ser;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset$1;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;
import oz.threeten.bp.zone.ZoneRules;

public final class ZoneOffset
extends ZoneId
implements Serializable,
Comparable,
TemporalAccessor,
TemporalAdjuster {
    public static final TemporalQuery FROM = new ZoneOffset$1();
    private static final ConcurrentMap SECONDS_CACHE = new ConcurrentHashMap(16, 0.75f, 4);
    private static final ConcurrentMap ID_CACHE = new ConcurrentHashMap(16, 0.75f, 4);
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int MAX_SECONDS = 64800;
    private static final long serialVersionUID = 2357656521762053153L;
    public static final ZoneOffset UTC = ZoneOffset.ofTotalSeconds(0);
    public static final ZoneOffset MIN = ZoneOffset.ofTotalSeconds(-64800);
    public static final ZoneOffset MAX = ZoneOffset.ofTotalSeconds(64800);
    private final int totalSeconds;
    private final transient String id;

    public static ZoneOffset of(String string) {
        int n;
        int n2;
        int n3;
        Jdk8Methods.requireNonNull(string, "offsetId");
        ZoneOffset zoneOffset = (ZoneOffset)ID_CACHE.get(string);
        if (zoneOffset != null) {
            return zoneOffset;
        }
        switch (string.length()) {
            case 2: {
                string = string.charAt(0) + "0" + string.charAt(1);
            }
            case 3: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = 0;
                n = 0;
                break;
            }
            case 5: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = ZoneOffset.parseNumber(string, 3, false);
                n = 0;
                break;
            }
            case 6: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = ZoneOffset.parseNumber(string, 4, true);
                n = 0;
                break;
            }
            case 7: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = ZoneOffset.parseNumber(string, 3, false);
                n = ZoneOffset.parseNumber(string, 5, false);
                break;
            }
            case 9: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = ZoneOffset.parseNumber(string, 4, true);
                n = ZoneOffset.parseNumber(string, 7, true);
                break;
            }
            default: {
                throw new DateTimeException("Invalid ID for ZoneOffset, invalid format: " + string);
            }
        }
        char c2 = string.charAt(0);
        if (c2 != '+' && c2 != '-') {
            throw new DateTimeException("Invalid ID for ZoneOffset, plus/minus not found when expected: " + string);
        }
        if (c2 == '-') {
            return ZoneOffset.ofHoursMinutesSeconds(-n3, -n2, -n);
        }
        return ZoneOffset.ofHoursMinutesSeconds(n3, n2, n);
    }

    private static int parseNumber(CharSequence charSequence, int n, boolean bl) {
        if (bl && charSequence.charAt(n - 1) != ':') {
            throw new DateTimeException("Invalid ID for ZoneOffset, colon not found when expected: " + charSequence);
        }
        char c2 = charSequence.charAt(n);
        char c3 = charSequence.charAt(n + 1);
        if (c2 < '0' || c2 > '9' || c3 < '0' || c3 > '9') {
            throw new DateTimeException("Invalid ID for ZoneOffset, non numeric characters found: " + charSequence);
        }
        return (c2 - 48) * 10 + (c3 - 48);
    }

    public static ZoneOffset ofHours(int n) {
        return ZoneOffset.ofHoursMinutesSeconds(n, 0, 0);
    }

    public static ZoneOffset ofHoursMinutes(int n, int n2) {
        return ZoneOffset.ofHoursMinutesSeconds(n, n2, 0);
    }

    public static ZoneOffset ofHoursMinutesSeconds(int n, int n2, int n3) {
        ZoneOffset.validate(n, n2, n3);
        int n4 = ZoneOffset.totalSeconds(n, n2, n3);
        return ZoneOffset.ofTotalSeconds(n4);
    }

    public static ZoneOffset from(TemporalAccessor temporalAccessor) {
        ZoneOffset zoneOffset = (ZoneOffset)temporalAccessor.query(TemporalQueries.offset());
        if (zoneOffset == null) {
            throw new DateTimeException("Unable to obtain ZoneOffset from TemporalAccessor: " + temporalAccessor + ", type " + temporalAccessor.getClass().getName());
        }
        return zoneOffset;
    }

    private static void validate(int n, int n2, int n3) {
        if (n < -18 || n > 18) {
            throw new DateTimeException("Zone offset hours not in valid range: value " + n + " is not in the range -18 to 18");
        }
        if (n > 0) {
            if (n2 < 0 || n3 < 0) {
                throw new DateTimeException("Zone offset minutes and seconds must be positive because hours is positive");
            }
        } else if (n < 0) {
            if (n2 > 0 || n3 > 0) {
                throw new DateTimeException("Zone offset minutes and seconds must be negative because hours is negative");
            }
        } else if (n2 > 0 && n3 < 0 || n2 < 0 && n3 > 0) {
            throw new DateTimeException("Zone offset minutes and seconds must have the same sign");
        }
        if (Math.abs(n2) > 59) {
            throw new DateTimeException("Zone offset minutes not in valid range: abs(value) " + Math.abs(n2) + " is not in the range 0 to 59");
        }
        if (Math.abs(n3) > 59) {
            throw new DateTimeException("Zone offset seconds not in valid range: abs(value) " + Math.abs(n3) + " is not in the range 0 to 59");
        }
        if (Math.abs(n) == 18 && (Math.abs(n2) > 0 || Math.abs(n3) > 0)) {
            throw new DateTimeException("Zone offset not in valid range: -18:00 to +18:00");
        }
    }

    private static int totalSeconds(int n, int n2, int n3) {
        return n * 3600 + n2 * 60 + n3;
    }

    public static ZoneOffset ofTotalSeconds(int n) {
        if (Math.abs(n) > 64800) {
            throw new DateTimeException("Zone offset not in valid range: -18:00 to +18:00");
        }
        if (n % 900 == 0) {
            Integer n2 = n;
            ZoneOffset zoneOffset = (ZoneOffset)SECONDS_CACHE.get(n2);
            if (zoneOffset == null) {
                zoneOffset = new ZoneOffset(n);
                SECONDS_CACHE.putIfAbsent(n2, zoneOffset);
                zoneOffset = (ZoneOffset)SECONDS_CACHE.get(n2);
                ID_CACHE.putIfAbsent(zoneOffset.getId(), zoneOffset);
            }
            return zoneOffset;
        }
        return new ZoneOffset(n);
    }

    private ZoneOffset(int n) {
        this.totalSeconds = n;
        this.id = ZoneOffset.buildId(n);
    }

    private static String buildId(int n) {
        if (n == 0) {
            return "Z";
        }
        int n2 = Math.abs(n);
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n2 / 3600;
        int n4 = n2 / 60 % 60;
        stringBuilder.append(n < 0 ? "-" : "+").append(n3 < 10 ? "0" : "").append(n3).append(n4 < 10 ? ":0" : ":").append(n4);
        int n5 = n2 % 60;
        if (n5 != 0) {
            stringBuilder.append(n5 < 10 ? ":0" : ":").append(n5);
        }
        return stringBuilder.toString();
    }

    public int getTotalSeconds() {
        return this.totalSeconds;
    }

    public String getId() {
        return this.id;
    }

    public ZoneRules getRules() {
        return ZoneRules.of(this);
    }

    public boolean isSupported(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField == ChronoField.OFFSET_SECONDS;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField == ChronoField.OFFSET_SECONDS) {
            return temporalField.range();
        }
        if (temporalField instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    public int get(TemporalField temporalField) {
        if (temporalField == ChronoField.OFFSET_SECONDS) {
            return this.totalSeconds;
        }
        if (temporalField instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return this.range(temporalField).checkValidIntValue(this.getLong(temporalField), temporalField);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField == ChronoField.OFFSET_SECONDS) {
            return this.totalSeconds;
        }
        if (temporalField instanceof ChronoField) {
            throw new DateTimeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.zone()) {
            return this;
        }
        if (temporalQuery == TemporalQueries.localDate() || temporalQuery == TemporalQueries.localTime() || temporalQuery == TemporalQueries.precision() || temporalQuery == TemporalQueries.chronology() || temporalQuery == TemporalQueries.zoneId()) {
            return null;
        }
        return temporalQuery.queryFrom(this);
    }

    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.OFFSET_SECONDS, this.totalSeconds);
    }

    public int compareTo(ZoneOffset zoneOffset) {
        return zoneOffset.totalSeconds - this.totalSeconds;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZoneOffset) {
            return this.totalSeconds == ((ZoneOffset)object).totalSeconds;
        }
        return false;
    }

    public int hashCode() {
        return this.totalSeconds;
    }

    public String toString() {
        return this.id;
    }

    private Object writeReplace() {
        return new Ser(8, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void write(DataOutput dataOutput) {
        dataOutput.writeByte(8);
        this.writeExternal(dataOutput);
    }

    void writeExternal(DataOutput dataOutput) {
        int n = this.totalSeconds;
        int n2 = n % 900 == 0 ? n / 900 : 127;
        dataOutput.writeByte(n2);
        if (n2 == 127) {
            dataOutput.writeInt(n);
        }
    }

    static ZoneOffset readExternal(DataInput dataInput) {
        byte by = dataInput.readByte();
        return by == 127 ? ZoneOffset.ofTotalSeconds(dataInput.readInt()) : ZoneOffset.ofTotalSeconds(by * 900);
    }
}

