/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.List;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Month;
import oz.threeten.bp.OffsetDateTime;
import oz.threeten.bp.Ser;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.ZonedDateTime$1;
import oz.threeten.bp.chrono.ChronoZonedDateTime;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.ValueRange;
import oz.threeten.bp.zone.ZoneOffsetTransition;
import oz.threeten.bp.zone.ZoneRules;

public final class ZonedDateTime
extends ChronoZonedDateTime
implements Serializable,
Temporal {
    public static final TemporalQuery FROM = new ZonedDateTime$1();
    private static final long serialVersionUID = -6260982410461394882L;
    private final LocalDateTime dateTime;
    private final ZoneOffset offset;
    private final ZoneId zone;

    public static ZonedDateTime now() {
        return ZonedDateTime.now(Clock.systemDefaultZone());
    }

    public static ZonedDateTime now(ZoneId zoneId) {
        return ZonedDateTime.now(Clock.system(zoneId));
    }

    public static ZonedDateTime now(Clock clock) {
        Jdk8Methods.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        return ZonedDateTime.ofInstant(instant, clock.getZone());
    }

    public static ZonedDateTime of(LocalDate localDate, LocalTime localTime, ZoneId zoneId) {
        return ZonedDateTime.of(LocalDateTime.of(localDate, localTime), zoneId);
    }

    public static ZonedDateTime of(LocalDateTime localDateTime, ZoneId zoneId) {
        return ZonedDateTime.ofLocal(localDateTime, zoneId, null);
    }

    public static ZonedDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7, ZoneId zoneId) {
        LocalDateTime localDateTime = LocalDateTime.of(n, n2, n3, n4, n5, n6, n7);
        return ZonedDateTime.ofLocal(localDateTime, zoneId, null);
    }

    public static ZonedDateTime ofLocal(LocalDateTime localDateTime, ZoneId zoneId, ZoneOffset zoneOffset) {
        ZoneOffset zoneOffset2;
        Jdk8Methods.requireNonNull(localDateTime, "localDateTime");
        Jdk8Methods.requireNonNull(zoneId, "zone");
        if (zoneId instanceof ZoneOffset) {
            return new ZonedDateTime(localDateTime, (ZoneOffset)zoneId, zoneId);
        }
        ZoneRules zoneRules = zoneId.getRules();
        List list = zoneRules.getValidOffsets(localDateTime);
        if (list.size() == 1) {
            zoneOffset2 = (ZoneOffset)list.get(0);
        } else if (list.size() == 0) {
            ZoneOffsetTransition zoneOffsetTransition = zoneRules.getTransition(localDateTime);
            localDateTime = localDateTime.plusSeconds(zoneOffsetTransition.getDuration().getSeconds());
            zoneOffset2 = zoneOffsetTransition.getOffsetAfter();
        } else {
            zoneOffset2 = zoneOffset != null && list.contains(zoneOffset) ? zoneOffset : (ZoneOffset)Jdk8Methods.requireNonNull(list.get(0), "offset");
        }
        return new ZonedDateTime(localDateTime, zoneOffset2, zoneId);
    }

    public static ZonedDateTime ofInstant(Instant instant, ZoneId zoneId) {
        Jdk8Methods.requireNonNull(instant, "instant");
        Jdk8Methods.requireNonNull(zoneId, "zone");
        return ZonedDateTime.create(instant.getEpochSecond(), instant.getNano(), zoneId);
    }

    public static ZonedDateTime ofInstant(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        Jdk8Methods.requireNonNull(localDateTime, "localDateTime");
        Jdk8Methods.requireNonNull(zoneOffset, "offset");
        Jdk8Methods.requireNonNull(zoneId, "zone");
        return ZonedDateTime.create(localDateTime.toEpochSecond(zoneOffset), localDateTime.getNano(), zoneId);
    }

    private static ZonedDateTime create(long l, int n, ZoneId zoneId) {
        ZoneRules zoneRules = zoneId.getRules();
        Instant instant = Instant.ofEpochSecond(l, n);
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(l, n, zoneOffset);
        return new ZonedDateTime(localDateTime, zoneOffset, zoneId);
    }

    public static ZonedDateTime ofStrict(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        Jdk8Methods.requireNonNull(localDateTime, "localDateTime");
        Jdk8Methods.requireNonNull(zoneOffset, "offset");
        Jdk8Methods.requireNonNull(zoneId, "zone");
        ZoneRules zoneRules = zoneId.getRules();
        if (!zoneRules.isValidOffset(localDateTime, zoneOffset)) {
            ZoneOffsetTransition zoneOffsetTransition = zoneRules.getTransition(localDateTime);
            if (zoneOffsetTransition != null && zoneOffsetTransition.isGap()) {
                throw new DateTimeException("LocalDateTime '" + localDateTime + "' does not exist in zone '" + zoneId + "' due to a gap in the local time-line, typically caused by daylight savings");
            }
            throw new DateTimeException("ZoneOffset '" + zoneOffset + "' is not valid for LocalDateTime '" + localDateTime + "' in zone '" + zoneId + "'");
        }
        return new ZonedDateTime(localDateTime, zoneOffset, zoneId);
    }

    private static ZonedDateTime ofLenient(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        Jdk8Methods.requireNonNull(localDateTime, "localDateTime");
        Jdk8Methods.requireNonNull(zoneOffset, "offset");
        Jdk8Methods.requireNonNull(zoneId, "zone");
        if (zoneId instanceof ZoneOffset && !zoneOffset.equals(zoneId)) {
            throw new IllegalArgumentException("ZoneId must match ZoneOffset");
        }
        return new ZonedDateTime(localDateTime, zoneOffset, zoneId);
    }

    public static ZonedDateTime from(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof ZonedDateTime) {
            return (ZonedDateTime)temporalAccessor;
        }
        try {
            ZoneId zoneId = ZoneId.from(temporalAccessor);
            if (temporalAccessor.isSupported(ChronoField.INSTANT_SECONDS)) {
                try {
                    long l = temporalAccessor.getLong(ChronoField.INSTANT_SECONDS);
                    int n = temporalAccessor.get(ChronoField.NANO_OF_SECOND);
                    return ZonedDateTime.create(l, n, zoneId);
                }
                catch (DateTimeException dateTimeException) {
                    // empty catch block
                }
            }
            LocalDateTime localDateTime = LocalDateTime.from(temporalAccessor);
            return ZonedDateTime.of(localDateTime, zoneId);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain ZonedDateTime from TemporalAccessor: " + temporalAccessor + ", type " + temporalAccessor.getClass().getName());
        }
    }

    public static ZonedDateTime parse(CharSequence charSequence) {
        return ZonedDateTime.parse(charSequence, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static ZonedDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        return (ZonedDateTime)dateTimeFormatter.parse(charSequence, FROM);
    }

    private ZonedDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        this.dateTime = localDateTime;
        this.offset = zoneOffset;
        this.zone = zoneId;
    }

    private ZonedDateTime resolveLocal(LocalDateTime localDateTime) {
        return ZonedDateTime.ofLocal(localDateTime, this.zone, this.offset);
    }

    private ZonedDateTime resolveInstant(LocalDateTime localDateTime) {
        return ZonedDateTime.ofInstant(localDateTime, this.offset, this.zone);
    }

    private ZonedDateTime resolveOffset(ZoneOffset zoneOffset) {
        if (!zoneOffset.equals(this.offset) && this.zone.getRules().isValidOffset(this.dateTime, zoneOffset)) {
            return new ZonedDateTime(this.dateTime, zoneOffset, this.zone);
        }
        return this;
    }

    public boolean isSupported(TemporalField temporalField) {
        return temporalField instanceof ChronoField || temporalField != null && temporalField.isSupportedBy(this);
    }

    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isDateBased() || temporalUnit.isTimeBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.INSTANT_SECONDS || temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.dateTime.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    public int get(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    throw new DateTimeException("Field too large for an int: " + temporalField);
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.dateTime.get(temporalField);
        }
        return super.get(temporalField);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case INSTANT_SECONDS: {
                    return this.toEpochSecond();
                }
                case OFFSET_SECONDS: {
                    return this.getOffset().getTotalSeconds();
                }
            }
            return this.dateTime.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public ZonedDateTime withEarlierOffsetAtOverlap() {
        ZoneOffset zoneOffset;
        ZoneOffsetTransition zoneOffsetTransition = this.getZone().getRules().getTransition(this.dateTime);
        if (zoneOffsetTransition != null && zoneOffsetTransition.isOverlap() && !(zoneOffset = zoneOffsetTransition.getOffsetBefore()).equals(this.offset)) {
            return new ZonedDateTime(this.dateTime, zoneOffset, this.zone);
        }
        return this;
    }

    public ZonedDateTime withLaterOffsetAtOverlap() {
        ZoneOffset zoneOffset;
        ZoneOffsetTransition zoneOffsetTransition = this.getZone().getRules().getTransition(this.toLocalDateTime());
        if (zoneOffsetTransition != null && !(zoneOffset = zoneOffsetTransition.getOffsetAfter()).equals(this.offset)) {
            return new ZonedDateTime(this.dateTime, zoneOffset, this.zone);
        }
        return this;
    }

    public ZoneId getZone() {
        return this.zone;
    }

    public ZonedDateTime withZoneSameLocal(ZoneId zoneId) {
        Jdk8Methods.requireNonNull(zoneId, "zone");
        return this.zone.equals(zoneId) ? this : ZonedDateTime.ofLocal(this.dateTime, zoneId, this.offset);
    }

    public ZonedDateTime withZoneSameInstant(ZoneId zoneId) {
        Jdk8Methods.requireNonNull(zoneId, "zone");
        return this.zone.equals(zoneId) ? this : ZonedDateTime.create(this.dateTime.toEpochSecond(this.offset), this.dateTime.getNano(), zoneId);
    }

    public ZonedDateTime withFixedOffsetZone() {
        return this.zone.equals(this.offset) ? this : new ZonedDateTime(this.dateTime, this.offset, this.offset);
    }

    public int getYear() {
        return this.dateTime.getYear();
    }

    public int getMonthValue() {
        return this.dateTime.getMonthValue();
    }

    public Month getMonth() {
        return this.dateTime.getMonth();
    }

    public int getDayOfMonth() {
        return this.dateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.dateTime.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.dateTime.getDayOfWeek();
    }

    public int getHour() {
        return this.dateTime.getHour();
    }

    public int getMinute() {
        return this.dateTime.getMinute();
    }

    public int getSecond() {
        return this.dateTime.getSecond();
    }

    public int getNano() {
        return this.dateTime.getNano();
    }

    public ZonedDateTime with(TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalDate) {
            return this.resolveLocal(LocalDateTime.of((LocalDate)temporalAdjuster, this.dateTime.toLocalTime()));
        }
        if (temporalAdjuster instanceof LocalTime) {
            return this.resolveLocal(LocalDateTime.of(this.dateTime.toLocalDate(), (LocalTime)temporalAdjuster));
        }
        if (temporalAdjuster instanceof LocalDateTime) {
            return this.resolveLocal((LocalDateTime)temporalAdjuster);
        }
        if (temporalAdjuster instanceof Instant) {
            Instant instant = (Instant)temporalAdjuster;
            return ZonedDateTime.create(instant.getEpochSecond(), instant.getNano(), this.zone);
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            return this.resolveOffset((ZoneOffset)temporalAdjuster);
        }
        return (ZonedDateTime)temporalAdjuster.adjustInto(this);
    }

    public ZonedDateTime with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            switch (chronoField) {
                case INSTANT_SECONDS: {
                    return ZonedDateTime.create(l, this.getNano(), this.zone);
                }
                case OFFSET_SECONDS: {
                    ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l));
                    return this.resolveOffset(zoneOffset);
                }
            }
            return this.resolveLocal(this.dateTime.with(temporalField, l));
        }
        return (ZonedDateTime)temporalField.adjustInto(this, l);
    }

    public ZonedDateTime withYear(int n) {
        return this.resolveLocal(this.dateTime.withYear(n));
    }

    public ZonedDateTime withMonth(int n) {
        return this.resolveLocal(this.dateTime.withMonth(n));
    }

    public ZonedDateTime withDayOfMonth(int n) {
        return this.resolveLocal(this.dateTime.withDayOfMonth(n));
    }

    public ZonedDateTime withDayOfYear(int n) {
        return this.resolveLocal(this.dateTime.withDayOfYear(n));
    }

    public ZonedDateTime withHour(int n) {
        return this.resolveLocal(this.dateTime.withHour(n));
    }

    public ZonedDateTime withMinute(int n) {
        return this.resolveLocal(this.dateTime.withMinute(n));
    }

    public ZonedDateTime withSecond(int n) {
        return this.resolveLocal(this.dateTime.withSecond(n));
    }

    public ZonedDateTime withNano(int n) {
        return this.resolveLocal(this.dateTime.withNano(n));
    }

    public ZonedDateTime truncatedTo(TemporalUnit temporalUnit) {
        return this.resolveLocal(this.dateTime.truncatedTo(temporalUnit));
    }

    public ZonedDateTime plus(TemporalAmount temporalAmount) {
        return (ZonedDateTime)temporalAmount.addTo(this);
    }

    public ZonedDateTime plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            if (temporalUnit.isDateBased()) {
                return this.resolveLocal(this.dateTime.plus(l, temporalUnit));
            }
            return this.resolveInstant(this.dateTime.plus(l, temporalUnit));
        }
        return (ZonedDateTime)temporalUnit.addTo(this, l);
    }

    public ZonedDateTime plusYears(long l) {
        return this.resolveLocal(this.dateTime.plusYears(l));
    }

    public ZonedDateTime plusMonths(long l) {
        return this.resolveLocal(this.dateTime.plusMonths(l));
    }

    public ZonedDateTime plusWeeks(long l) {
        return this.resolveLocal(this.dateTime.plusWeeks(l));
    }

    public ZonedDateTime plusDays(long l) {
        return this.resolveLocal(this.dateTime.plusDays(l));
    }

    public ZonedDateTime plusHours(long l) {
        return this.resolveInstant(this.dateTime.plusHours(l));
    }

    public ZonedDateTime plusMinutes(long l) {
        return this.resolveInstant(this.dateTime.plusMinutes(l));
    }

    public ZonedDateTime plusSeconds(long l) {
        return this.resolveInstant(this.dateTime.plusSeconds(l));
    }

    public ZonedDateTime plusNanos(long l) {
        return this.resolveInstant(this.dateTime.plusNanos(l));
    }

    public ZonedDateTime minus(TemporalAmount temporalAmount) {
        return (ZonedDateTime)temporalAmount.subtractFrom(this);
    }

    public ZonedDateTime minus(long l, TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public ZonedDateTime minusYears(long l) {
        return l == Long.MIN_VALUE ? this.plusYears(Long.MAX_VALUE).plusYears(1L) : this.plusYears(-l);
    }

    public ZonedDateTime minusMonths(long l) {
        return l == Long.MIN_VALUE ? this.plusMonths(Long.MAX_VALUE).plusMonths(1L) : this.plusMonths(-l);
    }

    public ZonedDateTime minusWeeks(long l) {
        return l == Long.MIN_VALUE ? this.plusWeeks(Long.MAX_VALUE).plusWeeks(1L) : this.plusWeeks(-l);
    }

    public ZonedDateTime minusDays(long l) {
        return l == Long.MIN_VALUE ? this.plusDays(Long.MAX_VALUE).plusDays(1L) : this.plusDays(-l);
    }

    public ZonedDateTime minusHours(long l) {
        return l == Long.MIN_VALUE ? this.plusHours(Long.MAX_VALUE).plusHours(1L) : this.plusHours(-l);
    }

    public ZonedDateTime minusMinutes(long l) {
        return l == Long.MIN_VALUE ? this.plusMinutes(Long.MAX_VALUE).plusMinutes(1L) : this.plusMinutes(-l);
    }

    public ZonedDateTime minusSeconds(long l) {
        return l == Long.MIN_VALUE ? this.plusSeconds(Long.MAX_VALUE).plusSeconds(1L) : this.plusSeconds(-l);
    }

    public ZonedDateTime minusNanos(long l) {
        return l == Long.MIN_VALUE ? this.plusNanos(Long.MAX_VALUE).plusNanos(1L) : this.plusNanos(-l);
    }

    public Object query(TemporalQuery temporalQuery) {
        if (temporalQuery == TemporalQueries.localDate()) {
            return this.toLocalDate();
        }
        return super.query(temporalQuery);
    }

    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        ZonedDateTime zonedDateTime = ZonedDateTime.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            zonedDateTime = zonedDateTime.withZoneSameInstant(this.zone);
            if (temporalUnit.isDateBased()) {
                return this.dateTime.until(zonedDateTime.dateTime, temporalUnit);
            }
            return this.toOffsetDateTime().until(zonedDateTime.toOffsetDateTime(), temporalUnit);
        }
        return temporalUnit.between(this, zonedDateTime);
    }

    public LocalDateTime toLocalDateTime() {
        return this.dateTime;
    }

    public LocalDate toLocalDate() {
        return this.dateTime.toLocalDate();
    }

    public LocalTime toLocalTime() {
        return this.dateTime.toLocalTime();
    }

    public OffsetDateTime toOffsetDateTime() {
        return OffsetDateTime.of(this.dateTime, this.offset);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return this.dateTime.equals(zonedDateTime.dateTime) && this.offset.equals(zonedDateTime.offset) && this.zone.equals(zonedDateTime.zone);
        }
        return false;
    }

    public int hashCode() {
        return this.dateTime.hashCode() ^ this.offset.hashCode() ^ Integer.rotateLeft(this.zone.hashCode(), 3);
    }

    public String toString() {
        String string = this.dateTime.toString() + this.offset.toString();
        if (this.offset != this.zone) {
            string = string + '[' + this.zone.toString() + ']';
        }
        return string;
    }

    public String format(DateTimeFormatter dateTimeFormatter) {
        return super.format(dateTimeFormatter);
    }

    private Object writeReplace() {
        return new Ser(6, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) {
        this.dateTime.writeExternal(dataOutput);
        this.offset.writeExternal(dataOutput);
        this.zone.write(dataOutput);
    }

    static ZonedDateTime readExternal(DataInput dataInput) {
        LocalDateTime localDateTime = LocalDateTime.readExternal(dataInput);
        ZoneOffset zoneOffset = ZoneOffset.readExternal(dataInput);
        ZoneId zoneId = (ZoneId)Ser.read(dataInput);
        return ZonedDateTime.ofLenient(localDateTime, zoneOffset, zoneId);
    }
}

