/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.chrono.ChronoPeriod;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;

final class ChronoPeriodImpl
extends ChronoPeriod
implements Serializable {
    private static final long serialVersionUID = 275618735781L;
    private final Chronology chronology;
    private final int years;
    private final int months;
    private final int days;

    public ChronoPeriodImpl(Chronology chronology, int n, int n2, int n3) {
        this.chronology = chronology;
        this.years = n;
        this.months = n2;
        this.days = n3;
    }

    public long get(TemporalUnit temporalUnit) {
        if (temporalUnit == ChronoUnit.YEARS) {
            return this.years;
        }
        if (temporalUnit == ChronoUnit.MONTHS) {
            return this.months;
        }
        if (temporalUnit == ChronoUnit.DAYS) {
            return this.days;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
    }

    public List getUnits() {
        return Collections.unmodifiableList(Arrays.asList(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS));
    }

    public Chronology getChronology() {
        return this.chronology;
    }

    public ChronoPeriod plus(TemporalAmount temporalAmount) {
        ChronoPeriodImpl chronoPeriodImpl;
        if (temporalAmount instanceof ChronoPeriodImpl && (chronoPeriodImpl = (ChronoPeriodImpl)temporalAmount).getChronology().equals(this.getChronology())) {
            return new ChronoPeriodImpl(this.chronology, Jdk8Methods.safeAdd(this.years, chronoPeriodImpl.years), Jdk8Methods.safeAdd(this.months, chronoPeriodImpl.months), Jdk8Methods.safeAdd(this.days, chronoPeriodImpl.days));
        }
        throw new DateTimeException("Unable to add amount: " + temporalAmount);
    }

    public ChronoPeriod minus(TemporalAmount temporalAmount) {
        ChronoPeriodImpl chronoPeriodImpl;
        if (temporalAmount instanceof ChronoPeriodImpl && (chronoPeriodImpl = (ChronoPeriodImpl)temporalAmount).getChronology().equals(this.getChronology())) {
            return new ChronoPeriodImpl(this.chronology, Jdk8Methods.safeSubtract(this.years, chronoPeriodImpl.years), Jdk8Methods.safeSubtract(this.months, chronoPeriodImpl.months), Jdk8Methods.safeSubtract(this.days, chronoPeriodImpl.days));
        }
        throw new DateTimeException("Unable to subtract amount: " + temporalAmount);
    }

    public ChronoPeriod multipliedBy(int n) {
        return new ChronoPeriodImpl(this.chronology, Jdk8Methods.safeMultiply(this.years, n), Jdk8Methods.safeMultiply(this.months, n), Jdk8Methods.safeMultiply(this.days, n));
    }

    public ChronoPeriod normalized() {
        if (this.chronology.range(ChronoField.MONTH_OF_YEAR).isFixed()) {
            long l = this.chronology.range(ChronoField.MONTH_OF_YEAR).getMaximum() - this.chronology.range(ChronoField.MONTH_OF_YEAR).getMinimum() + 1L;
            long l2 = (long)this.years * l + (long)this.months;
            int n = Jdk8Methods.safeToInt(l2 / l);
            int n2 = Jdk8Methods.safeToInt(l2 % l);
            return new ChronoPeriodImpl(this.chronology, n, n2, this.days);
        }
        return this;
    }

    public Temporal addTo(Temporal temporal) {
        Jdk8Methods.requireNonNull(temporal, "temporal");
        Chronology chronology = (Chronology)temporal.query(TemporalQueries.chronology());
        if (chronology != null && !this.chronology.equals(chronology)) {
            throw new DateTimeException("Invalid chronology, required: " + this.chronology.getId() + ", but was: " + chronology.getId());
        }
        if (this.years != 0) {
            temporal = temporal.plus(this.years, ChronoUnit.YEARS);
        }
        if (this.months != 0) {
            temporal = temporal.plus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0) {
            temporal = temporal.plus(this.days, ChronoUnit.DAYS);
        }
        return temporal;
    }

    public Temporal subtractFrom(Temporal temporal) {
        Jdk8Methods.requireNonNull(temporal, "temporal");
        Chronology chronology = (Chronology)temporal.query(TemporalQueries.chronology());
        if (chronology != null && !this.chronology.equals(chronology)) {
            throw new DateTimeException("Invalid chronology, required: " + this.chronology.getId() + ", but was: " + chronology.getId());
        }
        if (this.years != 0) {
            temporal = temporal.minus(this.years, ChronoUnit.YEARS);
        }
        if (this.months != 0) {
            temporal = temporal.minus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0) {
            temporal = temporal.minus(this.days, ChronoUnit.DAYS);
        }
        return temporal;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoPeriodImpl) {
            ChronoPeriodImpl chronoPeriodImpl = (ChronoPeriodImpl)object;
            return this.years == chronoPeriodImpl.years && this.months == chronoPeriodImpl.months && this.days == chronoPeriodImpl.days && this.chronology.equals(chronoPeriodImpl.chronology);
        }
        return false;
    }

    public int hashCode() {
        return this.chronology.hashCode() + Integer.rotateLeft(this.years, 16) + Integer.rotateLeft(this.months, 8) + this.days;
    }

    public String toString() {
        if (this.isZero()) {
            return this.chronology + " P0D";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.chronology).append(' ').append('P');
        if (this.years != 0) {
            stringBuilder.append(this.years).append('Y');
        }
        if (this.months != 0) {
            stringBuilder.append(this.months).append('M');
        }
        if (this.days != 0) {
            stringBuilder.append(this.days).append('D');
        }
        return stringBuilder.toString();
    }
}

