/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.List;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoLocalDateTimeImpl;
import oz.threeten.bp.chrono.ChronoZonedDateTime;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.Ser;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.zone.ZoneOffsetTransition;
import oz.threeten.bp.zone.ZoneRules;

final class ChronoZonedDateTimeImpl
extends ChronoZonedDateTime
implements Serializable {
    private static final long serialVersionUID = -5261813987200935591L;
    private final ChronoLocalDateTimeImpl dateTime;
    private final ZoneOffset offset;
    private final ZoneId zone;

    static ChronoZonedDateTime ofBest(ChronoLocalDateTimeImpl chronoLocalDateTimeImpl, ZoneId zoneId, ZoneOffset zoneOffset) {
        ZoneOffset zoneOffset2;
        LocalDateTime localDateTime;
        Jdk8Methods.requireNonNull(chronoLocalDateTimeImpl, "localDateTime");
        Jdk8Methods.requireNonNull(zoneId, "zone");
        if (zoneId instanceof ZoneOffset) {
            return new ChronoZonedDateTimeImpl(chronoLocalDateTimeImpl, (ZoneOffset)zoneId, zoneId);
        }
        ZoneRules zoneRules = zoneId.getRules();
        List list = zoneRules.getValidOffsets(localDateTime = LocalDateTime.from(chronoLocalDateTimeImpl));
        if (list.size() == 1) {
            zoneOffset2 = (ZoneOffset)list.get(0);
        } else if (list.size() == 0) {
            ZoneOffsetTransition zoneOffsetTransition = zoneRules.getTransition(localDateTime);
            chronoLocalDateTimeImpl = chronoLocalDateTimeImpl.plusSeconds(zoneOffsetTransition.getDuration().getSeconds());
            zoneOffset2 = zoneOffsetTransition.getOffsetAfter();
        } else {
            zoneOffset2 = zoneOffset != null && list.contains(zoneOffset) ? zoneOffset : (ZoneOffset)list.get(0);
        }
        Jdk8Methods.requireNonNull(zoneOffset2, "offset");
        return new ChronoZonedDateTimeImpl(chronoLocalDateTimeImpl, zoneOffset2, zoneId);
    }

    static ChronoZonedDateTimeImpl ofInstant(Chronology chronology, Instant instant, ZoneId zoneId) {
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        Jdk8Methods.requireNonNull(zoneOffset, "offset");
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), zoneOffset);
        ChronoLocalDateTimeImpl chronoLocalDateTimeImpl = (ChronoLocalDateTimeImpl)chronology.localDateTime(localDateTime);
        return new ChronoZonedDateTimeImpl(chronoLocalDateTimeImpl, zoneOffset, zoneId);
    }

    private ChronoZonedDateTimeImpl create(Instant instant, ZoneId zoneId) {
        return ChronoZonedDateTimeImpl.ofInstant(this.toLocalDate().getChronology(), instant, zoneId);
    }

    private ChronoZonedDateTimeImpl(ChronoLocalDateTimeImpl chronoLocalDateTimeImpl, ZoneOffset zoneOffset, ZoneId zoneId) {
        this.dateTime = (ChronoLocalDateTimeImpl)Jdk8Methods.requireNonNull(chronoLocalDateTimeImpl, "dateTime");
        this.offset = (ZoneOffset)Jdk8Methods.requireNonNull(zoneOffset, "offset");
        this.zone = (ZoneId)Jdk8Methods.requireNonNull(zoneId, "zone");
    }

    public boolean isSupported(TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isDateBased() || temporalUnit.isTimeBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public ChronoZonedDateTime withEarlierOffsetAtOverlap() {
        ZoneOffset zoneOffset;
        ZoneOffsetTransition zoneOffsetTransition = this.getZone().getRules().getTransition(LocalDateTime.from(this));
        if (zoneOffsetTransition != null && zoneOffsetTransition.isOverlap() && !(zoneOffset = zoneOffsetTransition.getOffsetBefore()).equals(this.offset)) {
            return new ChronoZonedDateTimeImpl(this.dateTime, zoneOffset, this.zone);
        }
        return this;
    }

    public ChronoZonedDateTime withLaterOffsetAtOverlap() {
        ZoneOffset zoneOffset;
        ZoneOffsetTransition zoneOffsetTransition = this.getZone().getRules().getTransition(LocalDateTime.from(this));
        if (zoneOffsetTransition != null && !(zoneOffset = zoneOffsetTransition.getOffsetAfter()).equals(this.getOffset())) {
            return new ChronoZonedDateTimeImpl(this.dateTime, zoneOffset, this.zone);
        }
        return this;
    }

    public ChronoLocalDateTime toLocalDateTime() {
        return this.dateTime;
    }

    public ZoneId getZone() {
        return this.zone;
    }

    public ChronoZonedDateTime withZoneSameLocal(ZoneId zoneId) {
        return ChronoZonedDateTimeImpl.ofBest(this.dateTime, zoneId, this.offset);
    }

    public ChronoZonedDateTime withZoneSameInstant(ZoneId zoneId) {
        Jdk8Methods.requireNonNull(zoneId, "zone");
        return this.zone.equals(zoneId) ? this : this.create(this.dateTime.toInstant(this.offset), zoneId);
    }

    public boolean isSupported(TemporalField temporalField) {
        return temporalField instanceof ChronoField || temporalField != null && temporalField.isSupportedBy(this);
    }

    public ChronoZonedDateTime with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            switch (chronoField) {
                case INSTANT_SECONDS: {
                    return this.plus(l - this.toEpochSecond(), ChronoUnit.SECONDS);
                }
                case OFFSET_SECONDS: {
                    ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l));
                    return this.create(this.dateTime.toInstant(zoneOffset), this.zone);
                }
            }
            return ChronoZonedDateTimeImpl.ofBest(this.dateTime.with(temporalField, l), this.zone, this.offset);
        }
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(temporalField.adjustInto(this, l));
    }

    public ChronoZonedDateTime plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return this.with(this.dateTime.plus(l, temporalUnit));
        }
        return this.toLocalDate().getChronology().ensureChronoZonedDateTime(temporalUnit.addTo(this, l));
    }

    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        ChronoZonedDateTime chronoZonedDateTime = this.toLocalDate().getChronology().zonedDateTime(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            chronoZonedDateTime = chronoZonedDateTime.withZoneSameInstant(this.offset);
            return this.dateTime.until(chronoZonedDateTime.toLocalDateTime(), temporalUnit);
        }
        return temporalUnit.between(this, chronoZonedDateTime);
    }

    private Object writeReplace() {
        return new Ser(13, this);
    }

    private Object readResolve() {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeObject(this.dateTime);
        objectOutput.writeObject(this.offset);
        objectOutput.writeObject(this.zone);
    }

    static ChronoZonedDateTime readExternal(ObjectInput objectInput) {
        ChronoLocalDateTime chronoLocalDateTime = (ChronoLocalDateTime)objectInput.readObject();
        ZoneOffset zoneOffset = (ZoneOffset)objectInput.readObject();
        ZoneId zoneId = (ZoneId)objectInput.readObject();
        return chronoLocalDateTime.atZone(zoneOffset).withZoneSameLocal(zoneId);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoZonedDateTime) {
            return this.compareTo((ChronoZonedDateTime)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toLocalDateTime().hashCode() ^ this.getOffset().hashCode() ^ Integer.rotateLeft(this.getZone().hashCode(), 3);
    }

    public String toString() {
        String string = this.toLocalDateTime().toString() + this.getOffset().toString();
        if (this.getOffset() != this.getZone()) {
            string = string + '[' + this.getZone().toString() + ']';
        }
        return string;
    }
}

