/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.ParseException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.ChronoDateImpl;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.HijrahChronology;
import oz.threeten.bp.chrono.HijrahEra;
import oz.threeten.bp.chrono.Ser;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;

public final class HijrahDate
extends ChronoDateImpl
implements Serializable {
    private static final long serialVersionUID = -5207853542612002020L;
    public static final int MIN_VALUE_OF_ERA = 1;
    public static final int MAX_VALUE_OF_ERA = 9999;
    private static final int[] NUM_DAYS;
    private static final int[] LEAP_NUM_DAYS;
    private static final int[] MONTH_LENGTH;
    private static final int[] LEAP_MONTH_LENGTH;
    private static final int[] MIN_VALUES;
    private static final int[] LEAST_MAX_VALUES;
    private static final int[] MAX_VALUES;
    private static final int POSITION_DAY_OF_MONTH = 5;
    private static final int POSITION_DAY_OF_YEAR = 6;
    private static final int[] CYCLEYEAR_START_DATE;
    private static final char FILE_SEP;
    private static final String PATH_SEP;
    private static final String DEFAULT_CONFIG_FILENAME = "hijrah_deviation.cfg";
    private static final String DEFAULT_CONFIG_PATH;
    private static final HashMap ADJUSTED_MONTH_DAYS;
    private static final HashMap ADJUSTED_MONTH_LENGTHS;
    private static final HashMap ADJUSTED_CYCLE_YEARS;
    private static final Long[] ADJUSTED_CYCLES;
    private static final Integer[] ADJUSTED_MIN_VALUES;
    private static final Integer[] ADJUSTED_LEAST_MAX_VALUES;
    private static final Integer[] ADJUSTED_MAX_VALUES;
    private static final Integer[] DEFAULT_MONTH_DAYS;
    private static final Integer[] DEFAULT_LEAP_MONTH_DAYS;
    private static final Integer[] DEFAULT_MONTH_LENGTHS;
    private static final Integer[] DEFAULT_LEAP_MONTH_LENGTHS;
    private static final Integer[] DEFAULT_CYCLE_YEARS;
    private static final int MAX_ADJUSTED_CYCLE = 334;
    private static final int HIJRAH_JAN_1_1_GREGORIAN_DAY = -492148;
    private final transient HijrahEra era;
    private final transient int yearOfEra;
    private final transient int monthOfYear;
    private final transient int dayOfMonth;
    private final transient int dayOfYear;
    private final transient DayOfWeek dayOfWeek;
    private final long gregorianEpochDay;
    private final transient boolean isLeapYear;

    public static HijrahDate now() {
        return HijrahDate.now(Clock.systemDefaultZone());
    }

    public static HijrahDate now(ZoneId zoneId) {
        return HijrahDate.now(Clock.system(zoneId));
    }

    public static HijrahDate now(Clock clock) {
        return HijrahChronology.INSTANCE.dateNow(clock);
    }

    public static HijrahDate of(int n, int n2, int n3) {
        return n >= 1 ? HijrahDate.of(HijrahEra.AH, n, n2, n3) : HijrahDate.of(HijrahEra.BEFORE_AH, 1 - n, n2, n3);
    }

    static HijrahDate of(HijrahEra hijrahEra, int n, int n2, int n3) {
        Jdk8Methods.requireNonNull(hijrahEra, "era");
        HijrahDate.checkValidYearOfEra(n);
        HijrahDate.checkValidMonth(n2);
        HijrahDate.checkValidDayOfMonth(n3);
        long l = HijrahDate.getGregorianEpochDay(hijrahEra.prolepticYear(n), n2, n3);
        return new HijrahDate(l);
    }

    private static void checkValidYearOfEra(int n) {
        if (n < 1 || n > 9999) {
            throw new DateTimeException("Invalid year of Hijrah Era");
        }
    }

    private static void checkValidDayOfYear(int n) {
        if (n < 1 || n > HijrahDate.getMaximumDayOfYear()) {
            throw new DateTimeException("Invalid day of year of Hijrah date");
        }
    }

    private static void checkValidMonth(int n) {
        if (n < 1 || n > 12) {
            throw new DateTimeException("Invalid month of Hijrah date");
        }
    }

    private static void checkValidDayOfMonth(int n) {
        if (n < 1 || n > HijrahDate.getMaximumDayOfMonth()) {
            throw new DateTimeException("Invalid day of month of Hijrah date, day " + n + " greater than " + HijrahDate.getMaximumDayOfMonth() + " or less than 1");
        }
    }

    static HijrahDate of(LocalDate localDate) {
        long l = localDate.toEpochDay();
        return new HijrahDate(l);
    }

    static HijrahDate ofEpochDay(long l) {
        return new HijrahDate(l);
    }

    public static HijrahDate from(TemporalAccessor temporalAccessor) {
        return HijrahChronology.INSTANCE.date(temporalAccessor);
    }

    private HijrahDate(long l) {
        int[] nArray = HijrahDate.getHijrahDateInfo(l);
        HijrahDate.checkValidYearOfEra(nArray[1]);
        HijrahDate.checkValidMonth(nArray[2]);
        HijrahDate.checkValidDayOfMonth(nArray[3]);
        HijrahDate.checkValidDayOfYear(nArray[4]);
        this.era = HijrahEra.of(nArray[0]);
        this.yearOfEra = nArray[1];
        this.monthOfYear = nArray[2];
        this.dayOfMonth = nArray[3];
        this.dayOfYear = nArray[4];
        this.dayOfWeek = DayOfWeek.of(nArray[5]);
        this.gregorianEpochDay = l;
        this.isLeapYear = HijrahDate.isLeapYear(this.yearOfEra);
    }

    private Object readResolve() {
        return new HijrahDate(this.gregorianEpochDay);
    }

    public HijrahChronology getChronology() {
        return HijrahChronology.INSTANCE;
    }

    public HijrahEra getEra() {
        return this.era;
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (this.isSupported(temporalField)) {
                ChronoField chronoField = (ChronoField)temporalField;
                switch (chronoField) {
                    case DAY_OF_MONTH: {
                        return ValueRange.of(1L, this.lengthOfMonth());
                    }
                    case DAY_OF_YEAR: {
                        return ValueRange.of(1L, this.lengthOfYear());
                    }
                    case ALIGNED_WEEK_OF_MONTH: {
                        return ValueRange.of(1L, 5L);
                    }
                    case YEAR_OF_ERA: {
                        return ValueRange.of(1L, 1000L);
                    }
                }
                return this.getChronology().range(chronoField);
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case DAY_OF_WEEK: {
                    return this.dayOfWeek.getValue();
                }
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                    return (this.dayOfMonth - 1) % 7 + 1;
                }
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                    return (this.dayOfYear - 1) % 7 + 1;
                }
                case DAY_OF_MONTH: {
                    return this.dayOfMonth;
                }
                case DAY_OF_YEAR: {
                    return this.dayOfYear;
                }
                case EPOCH_DAY: {
                    return this.toEpochDay();
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return (this.dayOfMonth - 1) / 7 + 1;
                }
                case ALIGNED_WEEK_OF_YEAR: {
                    return (this.dayOfYear - 1) / 7 + 1;
                }
                case MONTH_OF_YEAR: {
                    return this.monthOfYear;
                }
                case YEAR_OF_ERA: {
                    return this.yearOfEra;
                }
                case YEAR: {
                    return this.yearOfEra;
                }
                case ERA: {
                    return this.era.getValue();
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.getFrom(this);
    }

    public HijrahDate with(TemporalAdjuster temporalAdjuster) {
        return (HijrahDate)super.with(temporalAdjuster);
    }

    public HijrahDate with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            chronoField.checkValidValue(l);
            int n = (int)l;
            switch (chronoField) {
                case DAY_OF_WEEK: {
                    return this.plusDays(l - (long)this.dayOfWeek.getValue());
                }
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: {
                    return this.plusDays(l - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH));
                }
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: {
                    return this.plusDays(l - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR));
                }
                case DAY_OF_MONTH: {
                    return HijrahDate.resolvePreviousValid(this.yearOfEra, this.monthOfYear, n);
                }
                case DAY_OF_YEAR: {
                    return HijrahDate.resolvePreviousValid(this.yearOfEra, (n - 1) / 30 + 1, (n - 1) % 30 + 1);
                }
                case EPOCH_DAY: {
                    return new HijrahDate(n);
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return this.plusDays((l - this.getLong(ChronoField.ALIGNED_WEEK_OF_MONTH)) * 7L);
                }
                case ALIGNED_WEEK_OF_YEAR: {
                    return this.plusDays((l - this.getLong(ChronoField.ALIGNED_WEEK_OF_YEAR)) * 7L);
                }
                case MONTH_OF_YEAR: {
                    return HijrahDate.resolvePreviousValid(this.yearOfEra, n, this.dayOfMonth);
                }
                case YEAR_OF_ERA: {
                    return HijrahDate.resolvePreviousValid(this.yearOfEra >= 1 ? n : 1 - n, this.monthOfYear, this.dayOfMonth);
                }
                case YEAR: {
                    return HijrahDate.resolvePreviousValid(n, this.monthOfYear, this.dayOfMonth);
                }
                case ERA: {
                    return HijrahDate.resolvePreviousValid(1 - this.yearOfEra, this.monthOfYear, this.dayOfMonth);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return (HijrahDate)temporalField.adjustInto(this, l);
    }

    private static HijrahDate resolvePreviousValid(int n, int n2, int n3) {
        int n4 = HijrahDate.getMonthDays(n2 - 1, n);
        if (n3 > n4) {
            n3 = n4;
        }
        return HijrahDate.of(n, n2, n3);
    }

    public HijrahDate plus(TemporalAmount temporalAmount) {
        return (HijrahDate)super.plus(temporalAmount);
    }

    public HijrahDate plus(long l, TemporalUnit temporalUnit) {
        return (HijrahDate)super.plus(l, temporalUnit);
    }

    public HijrahDate minus(TemporalAmount temporalAmount) {
        return (HijrahDate)super.minus(temporalAmount);
    }

    public HijrahDate minus(long l, TemporalUnit temporalUnit) {
        return (HijrahDate)super.minus(l, temporalUnit);
    }

    public final ChronoLocalDateTime atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    public long toEpochDay() {
        return HijrahDate.getGregorianEpochDay(this.yearOfEra, this.monthOfYear, this.dayOfMonth);
    }

    public boolean isLeapYear() {
        return this.isLeapYear;
    }

    HijrahDate plusYears(long l) {
        if (l == 0L) {
            return this;
        }
        int n = Jdk8Methods.safeAdd(this.yearOfEra, (int)l);
        return HijrahDate.of(this.era, n, this.monthOfYear, this.dayOfMonth);
    }

    HijrahDate plusMonths(long l) {
        if (l == 0L) {
            return this;
        }
        int n = this.monthOfYear - 1;
        int n2 = (n += (int)l) / 12;
        n %= 12;
        while (n < 0) {
            n += 12;
            n2 = Jdk8Methods.safeSubtract(n2, 1);
        }
        int n3 = Jdk8Methods.safeAdd(this.yearOfEra, n2);
        return HijrahDate.of(this.era, n3, n + 1, this.dayOfMonth);
    }

    HijrahDate plusDays(long l) {
        return new HijrahDate(this.gregorianEpochDay + l);
    }

    private static int[] getHijrahDateInfo(long l) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        long l2 = l - -492148L;
        if (l2 >= 0L) {
            int n6 = HijrahDate.getCycleNumber(l2);
            int n7 = HijrahDate.getDayOfCycle(l2, n6);
            int n8 = HijrahDate.getYearInCycle(n6, n7);
            n5 = HijrahDate.getDayOfYear(n6, n7, n8);
            n4 = n6 * 30 + n8 + 1;
            n3 = HijrahDate.getMonthOfYear(n5, n4);
            n2 = HijrahDate.getDayOfMonth(n5, n3, n4);
            ++n2;
            n = HijrahEra.AH.getValue();
        } else {
            int n9 = (int)l2 / 10631;
            int n10 = (int)l2 % 10631;
            if (n10 == 0) {
                n10 = -10631;
                ++n9;
            }
            int n11 = HijrahDate.getYearInCycle(n9, n10);
            n5 = HijrahDate.getDayOfYear(n9, n10, n11);
            n4 = n9 * 30 - n11;
            n5 = HijrahDate.isLeapYear(n4 = 1 - n4) ? n5 + 355 : n5 + 354;
            n3 = HijrahDate.getMonthOfYear(n5, n4);
            n2 = HijrahDate.getDayOfMonth(n5, n3, n4);
            ++n2;
            n = HijrahEra.BEFORE_AH.getValue();
        }
        int n12 = (int)((l2 + 5L) % 7L);
        int[] nArray = new int[]{n, n4, n3 + 1, n2, n5 + 1, n12 += n12 <= 0 ? 7 : 0};
        return nArray;
    }

    private static long getGregorianEpochDay(int n, int n2, int n3) {
        long l = HijrahDate.yearToGregorianEpochDay(n);
        l += (long)HijrahDate.getMonthDays(n2 - 1, n);
        return l += (long)n3;
    }

    private static long yearToGregorianEpochDay(int n) {
        Long l;
        int n2 = (n - 1) / 30;
        int n3 = (n - 1) % 30;
        int n4 = HijrahDate.getAdjustedCycle(n2)[Math.abs(n3)];
        if (n3 < 0) {
            n4 = -n4;
        }
        try {
            l = ADJUSTED_CYCLES[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            l = null;
        }
        if (l == null) {
            l = n2 * 10631;
        }
        return l + (long)n4 + -492148L - 1L;
    }

    private static int getCycleNumber(long l) {
        int n;
        Long[] longArray = ADJUSTED_CYCLES;
        try {
            for (int j = 0; j < longArray.length; ++j) {
                if (l >= longArray[j]) continue;
                return j - 1;
            }
            n = (int)l / 10631;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = (int)l / 10631;
        }
        return n;
    }

    private static int getDayOfCycle(long l, int n) {
        Long l2;
        try {
            l2 = ADJUSTED_CYCLES[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            l2 = null;
        }
        if (l2 == null) {
            l2 = n * 10631;
        }
        return (int)(l - l2);
    }

    private static int getYearInCycle(int n, long l) {
        Integer[] integerArray = HijrahDate.getAdjustedCycle(n);
        if (l == 0L) {
            return 0;
        }
        if (l > 0L) {
            for (int j = 0; j < integerArray.length; ++j) {
                if (l >= (long)integerArray[j].intValue()) continue;
                return j - 1;
            }
            return 29;
        }
        l = -l;
        for (int j = 0; j < integerArray.length; ++j) {
            if (l > (long)integerArray[j].intValue()) continue;
            return j - 1;
        }
        return 29;
    }

    private static Integer[] getAdjustedCycle(int n) {
        Integer[] integerArray;
        try {
            integerArray = (Integer[])ADJUSTED_CYCLE_YEARS.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            integerArray = null;
        }
        if (integerArray == null) {
            integerArray = DEFAULT_CYCLE_YEARS;
        }
        return integerArray;
    }

    private static Integer[] getAdjustedMonthDays(int n) {
        Integer[] integerArray;
        try {
            integerArray = (Integer[])ADJUSTED_MONTH_DAYS.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            integerArray = null;
        }
        if (integerArray == null) {
            integerArray = HijrahDate.isLeapYear(n) ? DEFAULT_LEAP_MONTH_DAYS : DEFAULT_MONTH_DAYS;
        }
        return integerArray;
    }

    private static Integer[] getAdjustedMonthLength(int n) {
        Integer[] integerArray;
        try {
            integerArray = (Integer[])ADJUSTED_MONTH_LENGTHS.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            integerArray = null;
        }
        if (integerArray == null) {
            integerArray = HijrahDate.isLeapYear(n) ? DEFAULT_LEAP_MONTH_LENGTHS : DEFAULT_MONTH_LENGTHS;
        }
        return integerArray;
    }

    private static int getDayOfYear(int n, int n2, int n3) {
        Integer[] integerArray = HijrahDate.getAdjustedCycle(n);
        if (n2 > 0) {
            return n2 - integerArray[n3];
        }
        return integerArray[n3] + n2;
    }

    private static int getMonthOfYear(int n, int n2) {
        Integer[] integerArray = HijrahDate.getAdjustedMonthDays(n2);
        if (n >= 0) {
            for (int j = 0; j < integerArray.length; ++j) {
                if (n >= integerArray[j]) continue;
                return j - 1;
            }
            return 11;
        }
        n = HijrahDate.isLeapYear(n2) ? n + 355 : n + 354;
        for (int j = 0; j < integerArray.length; ++j) {
            if (n >= integerArray[j]) continue;
            return j - 1;
        }
        return 11;
    }

    private static int getDayOfMonth(int n, int n2, int n3) {
        Integer[] integerArray = HijrahDate.getAdjustedMonthDays(n3);
        if (n >= 0) {
            if (n2 > 0) {
                return n - integerArray[n2];
            }
            return n;
        }
        int n4 = n = HijrahDate.isLeapYear(n3) ? n + 355 : n + 354;
        if (n2 > 0) {
            return n - integerArray[n2];
        }
        return n;
    }

    static boolean isLeapYear(long l) {
        return (14L + 11L * (l > 0L ? l : -l)) % 30L < 11L;
    }

    private static int getMonthDays(int n, int n2) {
        Integer[] integerArray = HijrahDate.getAdjustedMonthDays(n2);
        return integerArray[n];
    }

    static int getMonthLength(int n, int n2) {
        Integer[] integerArray = HijrahDate.getAdjustedMonthLength(n2);
        return integerArray[n];
    }

    public int lengthOfMonth() {
        return HijrahDate.getMonthLength(this.monthOfYear - 1, this.yearOfEra);
    }

    static int getYearLength(int n) {
        Integer[] integerArray;
        int n2 = (n - 1) / 30;
        try {
            integerArray = (Integer[])ADJUSTED_CYCLE_YEARS.get(n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            integerArray = null;
        }
        if (integerArray != null) {
            int n3 = (n - 1) % 30;
            if (n3 == 29) {
                return ADJUSTED_CYCLES[n2 + 1].intValue() - ADJUSTED_CYCLES[n2].intValue() - integerArray[n3];
            }
            return integerArray[n3 + 1] - integerArray[n3];
        }
        return HijrahDate.isLeapYear(n) ? 355 : 354;
    }

    public int lengthOfYear() {
        return HijrahDate.getYearLength(this.yearOfEra);
    }

    static int getMaximumDayOfMonth() {
        return ADJUSTED_MAX_VALUES[5];
    }

    static int getSmallestMaximumDayOfMonth() {
        return ADJUSTED_LEAST_MAX_VALUES[5];
    }

    static int getMaximumDayOfYear() {
        return ADJUSTED_MAX_VALUES[6];
    }

    static int getSmallestMaximumDayOfYear() {
        return ADJUSTED_LEAST_MAX_VALUES[6];
    }

    private static void addDeviationAsHijrah(int n, int n2, int n3, int n4, int n5) {
        Integer[] integerArray;
        int n6;
        int n7;
        int n8;
        int n9;
        if (n < 1) {
            throw new IllegalArgumentException("startYear < 1");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("endYear < 1");
        }
        if (n2 < 0 || n2 > 11) {
            throw new IllegalArgumentException("startMonth < 0 || startMonth > 11");
        }
        if (n4 < 0 || n4 > 11) {
            throw new IllegalArgumentException("endMonth < 0 || endMonth > 11");
        }
        if (n3 > 9999) {
            throw new IllegalArgumentException("endYear > 9999");
        }
        if (n3 < n) {
            throw new IllegalArgumentException("startYear > endYear");
        }
        if (n3 == n && n4 < n2) {
            throw new IllegalArgumentException("startYear == endYear && endMonth < startMonth");
        }
        boolean bl = HijrahDate.isLeapYear(n);
        Integer[] integerArray2 = (Integer[])ADJUSTED_MONTH_DAYS.get(n);
        if (integerArray2 == null) {
            int n10;
            if (bl) {
                integerArray2 = new Integer[LEAP_NUM_DAYS.length];
                for (n10 = 0; n10 < LEAP_NUM_DAYS.length; ++n10) {
                    integerArray2[n10] = LEAP_NUM_DAYS[n10];
                }
            } else {
                integerArray2 = new Integer[NUM_DAYS.length];
                for (n10 = 0; n10 < NUM_DAYS.length; ++n10) {
                    integerArray2[n10] = NUM_DAYS[n10];
                }
            }
        }
        Integer[] integerArray3 = new Integer[integerArray2.length];
        for (int j = 0; j < 12; ++j) {
            integerArray3[j] = j > n2 ? Integer.valueOf(integerArray2[j] - n5) : Integer.valueOf(integerArray2[j]);
        }
        ADJUSTED_MONTH_DAYS.put(n, integerArray3);
        Integer[] integerArray4 = (Integer[])ADJUSTED_MONTH_LENGTHS.get(n);
        if (integerArray4 == null) {
            int n11;
            if (bl) {
                integerArray4 = new Integer[LEAP_MONTH_LENGTH.length];
                for (n11 = 0; n11 < LEAP_MONTH_LENGTH.length; ++n11) {
                    integerArray4[n11] = LEAP_MONTH_LENGTH[n11];
                }
            } else {
                integerArray4 = new Integer[MONTH_LENGTH.length];
                for (n11 = 0; n11 < MONTH_LENGTH.length; ++n11) {
                    integerArray4[n11] = MONTH_LENGTH[n11];
                }
            }
        }
        Integer[] integerArray5 = new Integer[integerArray4.length];
        for (n9 = 0; n9 < 12; ++n9) {
            integerArray5[n9] = n9 == n2 ? Integer.valueOf(integerArray4[n9] - n5) : Integer.valueOf(integerArray4[n9]);
        }
        ADJUSTED_MONTH_LENGTHS.put(n, integerArray5);
        if (n != n3) {
            int n12;
            n9 = (n - 1) / 30;
            int n13 = (n - 1) % 30;
            Integer[] integerArray6 = (Integer[])ADJUSTED_CYCLE_YEARS.get(n9);
            if (integerArray6 == null) {
                integerArray6 = new Integer[CYCLEYEAR_START_DATE.length];
                for (n8 = 0; n8 < integerArray6.length; ++n8) {
                    integerArray6[n8] = CYCLEYEAR_START_DATE[n8];
                }
            }
            for (n8 = n13 + 1; n8 < CYCLEYEAR_START_DATE.length; ++n8) {
                integerArray6[n8] = integerArray6[n8] - n5;
            }
            ADJUSTED_CYCLE_YEARS.put(n9, integerArray6);
            n8 = (n - 1) / 30;
            n7 = (n3 - 1) / 30;
            if (n8 != n7) {
                for (n6 = n8 + 1; n6 < ADJUSTED_CYCLES.length; ++n6) {
                    HijrahDate.ADJUSTED_CYCLES[n6] = ADJUSTED_CYCLES[n6] - (long)n5;
                }
                for (n6 = n7 + 1; n6 < ADJUSTED_CYCLES.length; ++n6) {
                    HijrahDate.ADJUSTED_CYCLES[n6] = ADJUSTED_CYCLES[n6] + (long)n5;
                }
            }
            n6 = (n3 - 1) / 30;
            int n14 = (n3 - 1) % 30;
            integerArray = (Integer[])ADJUSTED_CYCLE_YEARS.get(n6);
            if (integerArray == null) {
                integerArray = new Integer[CYCLEYEAR_START_DATE.length];
                for (n12 = 0; n12 < integerArray.length; ++n12) {
                    integerArray[n12] = CYCLEYEAR_START_DATE[n12];
                }
            }
            for (n12 = n14 + 1; n12 < CYCLEYEAR_START_DATE.length; ++n12) {
                integerArray[n12] = integerArray[n12] + n5;
            }
            ADJUSTED_CYCLE_YEARS.put(n6, integerArray);
        }
        n9 = HijrahDate.isLeapYear(n3) ? 1 : 0;
        Integer[] integerArray7 = (Integer[])ADJUSTED_MONTH_DAYS.get(n3);
        if (integerArray7 == null) {
            if (n9 != 0) {
                integerArray7 = new Integer[LEAP_NUM_DAYS.length];
                for (int j = 0; j < LEAP_NUM_DAYS.length; ++j) {
                    integerArray7[j] = LEAP_NUM_DAYS[j];
                }
            } else {
                integerArray7 = new Integer[NUM_DAYS.length];
                for (int j = 0; j < NUM_DAYS.length; ++j) {
                    integerArray7[j] = NUM_DAYS[j];
                }
            }
        }
        Integer[] integerArray8 = new Integer[integerArray7.length];
        for (n8 = 0; n8 < 12; ++n8) {
            integerArray8[n8] = n8 > n4 ? Integer.valueOf(integerArray7[n8] + n5) : Integer.valueOf(integerArray7[n8]);
        }
        ADJUSTED_MONTH_DAYS.put(n3, integerArray8);
        Integer[] integerArray9 = (Integer[])ADJUSTED_MONTH_LENGTHS.get(n3);
        if (integerArray9 == null) {
            if (n9 != 0) {
                integerArray9 = new Integer[LEAP_MONTH_LENGTH.length];
                for (n7 = 0; n7 < LEAP_MONTH_LENGTH.length; ++n7) {
                    integerArray9[n7] = LEAP_MONTH_LENGTH[n7];
                }
            } else {
                integerArray9 = new Integer[MONTH_LENGTH.length];
                for (n7 = 0; n7 < MONTH_LENGTH.length; ++n7) {
                    integerArray9[n7] = MONTH_LENGTH[n7];
                }
            }
        }
        Integer[] integerArray10 = new Integer[integerArray9.length];
        for (n6 = 0; n6 < 12; ++n6) {
            integerArray10[n6] = n6 == n4 ? Integer.valueOf(integerArray9[n6] + n5) : Integer.valueOf(integerArray9[n6]);
        }
        ADJUSTED_MONTH_LENGTHS.put(n3, integerArray10);
        Integer[] integerArray11 = (Integer[])ADJUSTED_MONTH_LENGTHS.get(n);
        Integer[] integerArray12 = (Integer[])ADJUSTED_MONTH_LENGTHS.get(n3);
        integerArray = (Integer[])ADJUSTED_MONTH_DAYS.get(n);
        Integer[] integerArray13 = (Integer[])ADJUSTED_MONTH_DAYS.get(n3);
        int n15 = integerArray11[n2];
        int n16 = integerArray12[n4];
        int n17 = integerArray[11] + integerArray11[11];
        int n18 = integerArray13[11] + integerArray12[11];
        int n19 = ADJUSTED_MAX_VALUES[5];
        int n20 = ADJUSTED_LEAST_MAX_VALUES[5];
        if (n19 < n15) {
            n19 = n15;
        }
        if (n19 < n16) {
            n19 = n16;
        }
        HijrahDate.ADJUSTED_MAX_VALUES[5] = n19;
        if (n20 > n15) {
            n20 = n15;
        }
        if (n20 > n16) {
            n20 = n16;
        }
        HijrahDate.ADJUSTED_LEAST_MAX_VALUES[5] = n20;
        int n21 = ADJUSTED_MAX_VALUES[6];
        int n22 = ADJUSTED_LEAST_MAX_VALUES[6];
        if (n21 < n17) {
            n21 = n17;
        }
        if (n21 < n18) {
            n21 = n18;
        }
        HijrahDate.ADJUSTED_MAX_VALUES[6] = n21;
        if (n22 > n17) {
            n22 = n17;
        }
        if (n22 > n18) {
            n22 = n18;
        }
        HijrahDate.ADJUSTED_LEAST_MAX_VALUES[6] = n22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readDeviationConfig() {
        InputStream inputStream = HijrahDate.getConfigFileInputStream();
        if (inputStream != null) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = "";
                int n = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    string = string.trim();
                    HijrahDate.parseLine(string, ++n);
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
    }

    private static void parseLine(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf(58);
            if (n2 != -1) {
                int n3;
                String string3 = string2.substring(n2 + 1, string2.length());
                try {
                    n3 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Offset is not properly set at line " + n + ".", n);
                }
                int n4 = string2.indexOf(45);
                if (n4 != -1) {
                    String string4;
                    String string5;
                    String string6 = string2.substring(0, n4);
                    String string7 = string2.substring(n4 + 1, n2);
                    int n5 = string6.indexOf(47);
                    int n6 = string7.indexOf(47);
                    int n7 = -1;
                    int n8 = -1;
                    int n9 = -1;
                    int n10 = -1;
                    if (n5 != -1) {
                        string5 = string6.substring(0, n5);
                        string4 = string6.substring(n5 + 1, string6.length());
                        try {
                            n7 = Integer.parseInt(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException("Start year is not properly set at line " + n + ".", n);
                        }
                        try {
                            n9 = Integer.parseInt(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException("Start month is not properly set at line " + n + ".", n);
                        }
                    }
                    throw new ParseException("Start year/month has incorrect format at line " + n + ".", n);
                    if (n6 != -1) {
                        string5 = string7.substring(0, n6);
                        string4 = string7.substring(n6 + 1, string7.length());
                        try {
                            n8 = Integer.parseInt(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException("End year is not properly set at line " + n + ".", n);
                        }
                        try {
                            n10 = Integer.parseInt(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException("End month is not properly set at line " + n + ".", n);
                        }
                    }
                    throw new ParseException("End year/month has incorrect format at line " + n + ".", n);
                    if (n7 != -1 && n9 != -1 && n8 != -1 && n10 != -1) {
                        HijrahDate.addDeviationAsHijrah(n7, n9, n8, n10, n3);
                        continue;
                    }
                    throw new ParseException("Unknown error at line " + n + ".", n);
                }
                throw new ParseException("Start and end year/month has incorrect format at line " + n + ".", n);
            }
            throw new ParseException("Offset has incorrect format at line " + n + ".", n);
        }
    }

    private static InputStream getConfigFileInputStream() {
        String string;
        String string2 = System.getProperty("oz.threeten.bp.i18n.HijrahDate.deviationConfigFile");
        if (string2 == null) {
            string2 = DEFAULT_CONFIG_FILENAME;
        }
        if ((string = System.getProperty("oz.threeten.bp.i18n.HijrahDate.deviationConfigDir")) != null) {
            File file;
            if (string.length() != 0 || !string.endsWith(System.getProperty("file.separator"))) {
                string = string + System.getProperty("file.separator");
            }
            if ((file = new File(string + FILE_SEP + string2)).exists()) {
                return new FileInputStream(file);
            }
            return null;
        }
        String string3 = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string3, PATH_SEP);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string4 = stringTokenizer.nextToken();
            File file = new File(string4);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                object = new File(string4 + FILE_SEP + DEFAULT_CONFIG_PATH, string2);
                if (!((File)object).exists()) continue;
                return new FileInputStream(string4 + FILE_SEP + DEFAULT_CONFIG_PATH + FILE_SEP + string2);
            }
            try {
                object = new ZipFile(file);
            }
            catch (IOException iOException) {
                object = null;
            }
            if (object == null) continue;
            String string5 = DEFAULT_CONFIG_PATH + FILE_SEP + string2;
            ZipEntry zipEntry = ((ZipFile)object).getEntry(string5);
            if (zipEntry == null) {
                if (FILE_SEP == '/') {
                    string5 = string5.replace('/', '\\');
                } else if (FILE_SEP == '\\') {
                    string5 = string5.replace('\\', '/');
                }
                zipEntry = ((ZipFile)object).getEntry(string5);
            }
            if (zipEntry == null) continue;
            return ((ZipFile)object).getInputStream(zipEntry);
        }
        return null;
    }

    private Object writeReplace() {
        return new Ser(3, this);
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeInt(this.get(ChronoField.YEAR));
        dataOutput.writeByte(this.get(ChronoField.MONTH_OF_YEAR));
        dataOutput.writeByte(this.get(ChronoField.DAY_OF_MONTH));
    }

    static ChronoLocalDate readExternal(DataInput dataInput) {
        int n = dataInput.readInt();
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        return HijrahChronology.INSTANCE.date(n, by, by2);
    }

    static {
        int n;
        NUM_DAYS = new int[]{0, 30, 59, 89, 118, 148, 177, 207, 236, 266, 295, 325};
        LEAP_NUM_DAYS = new int[]{0, 30, 59, 89, 118, 148, 177, 207, 236, 266, 295, 325};
        MONTH_LENGTH = new int[]{30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29};
        LEAP_MONTH_LENGTH = new int[]{30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 30};
        MIN_VALUES = new int[]{0, 1, 0, 1, 0, 1, 1};
        LEAST_MAX_VALUES = new int[]{1, 9999, 11, 51, 5, 29, 354};
        MAX_VALUES = new int[]{1, 9999, 11, 52, 6, 30, 355};
        CYCLEYEAR_START_DATE = new int[]{0, 354, 709, 1063, 1417, 1772, 2126, 2481, 2835, 3189, 3544, 3898, 4252, 4607, 4961, 5315, 5670, 6024, 6379, 6733, 7087, 7442, 7796, 8150, 8505, 8859, 9214, 9568, 9922, 10277};
        FILE_SEP = File.separatorChar;
        PATH_SEP = File.pathSeparator;
        DEFAULT_CONFIG_PATH = "org" + FILE_SEP + "threeten" + FILE_SEP + "bp" + FILE_SEP + "chrono";
        ADJUSTED_MONTH_DAYS = new HashMap();
        ADJUSTED_MONTH_LENGTHS = new HashMap();
        ADJUSTED_CYCLE_YEARS = new HashMap();
        DEFAULT_MONTH_DAYS = new Integer[NUM_DAYS.length];
        for (n = 0; n < NUM_DAYS.length; ++n) {
            HijrahDate.DEFAULT_MONTH_DAYS[n] = NUM_DAYS[n];
        }
        DEFAULT_LEAP_MONTH_DAYS = new Integer[LEAP_NUM_DAYS.length];
        for (n = 0; n < LEAP_NUM_DAYS.length; ++n) {
            HijrahDate.DEFAULT_LEAP_MONTH_DAYS[n] = LEAP_NUM_DAYS[n];
        }
        DEFAULT_MONTH_LENGTHS = new Integer[MONTH_LENGTH.length];
        for (n = 0; n < MONTH_LENGTH.length; ++n) {
            HijrahDate.DEFAULT_MONTH_LENGTHS[n] = MONTH_LENGTH[n];
        }
        DEFAULT_LEAP_MONTH_LENGTHS = new Integer[LEAP_MONTH_LENGTH.length];
        for (n = 0; n < LEAP_MONTH_LENGTH.length; ++n) {
            HijrahDate.DEFAULT_LEAP_MONTH_LENGTHS[n] = LEAP_MONTH_LENGTH[n];
        }
        DEFAULT_CYCLE_YEARS = new Integer[CYCLEYEAR_START_DATE.length];
        for (n = 0; n < CYCLEYEAR_START_DATE.length; ++n) {
            HijrahDate.DEFAULT_CYCLE_YEARS[n] = CYCLEYEAR_START_DATE[n];
        }
        ADJUSTED_CYCLES = new Long[334];
        for (n = 0; n < ADJUSTED_CYCLES.length; ++n) {
            HijrahDate.ADJUSTED_CYCLES[n] = 10631 * n;
        }
        ADJUSTED_MIN_VALUES = new Integer[MIN_VALUES.length];
        for (n = 0; n < MIN_VALUES.length; ++n) {
            HijrahDate.ADJUSTED_MIN_VALUES[n] = MIN_VALUES[n];
        }
        ADJUSTED_LEAST_MAX_VALUES = new Integer[LEAST_MAX_VALUES.length];
        for (n = 0; n < LEAST_MAX_VALUES.length; ++n) {
            HijrahDate.ADJUSTED_LEAST_MAX_VALUES[n] = LEAST_MAX_VALUES[n];
        }
        ADJUSTED_MAX_VALUES = new Integer[MAX_VALUES.length];
        for (n = 0; n < MAX_VALUES.length; ++n) {
            HijrahDate.ADJUSTED_MAX_VALUES[n] = MAX_VALUES[n];
        }
        try {
            HijrahDate.readDeviationConfig();
        }
        catch (IOException iOException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

