/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.Month;
import oz.threeten.bp.Year;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZonedDateTime;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.Era;
import oz.threeten.bp.chrono.IsoEra;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjusters;
import oz.threeten.bp.temporal.ValueRange;

public final class IsoChronology
extends Chronology
implements Serializable {
    public static final IsoChronology INSTANCE = new IsoChronology();
    private static final long serialVersionUID = -1440403870442975015L;

    private IsoChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public String getId() {
        return "ISO";
    }

    public String getCalendarType() {
        return "iso8601";
    }

    public LocalDate date(Era era, int n, int n2, int n3) {
        return this.date(this.prolepticYear(era, n), n2, n3);
    }

    public LocalDate date(int n, int n2, int n3) {
        return LocalDate.of(n, n2, n3);
    }

    public LocalDate dateYearDay(Era era, int n, int n2) {
        return this.dateYearDay(this.prolepticYear(era, n), n2);
    }

    public LocalDate dateYearDay(int n, int n2) {
        return LocalDate.ofYearDay(n, n2);
    }

    public LocalDate dateEpochDay(long l) {
        return LocalDate.ofEpochDay(l);
    }

    public LocalDate date(TemporalAccessor temporalAccessor) {
        return LocalDate.from(temporalAccessor);
    }

    public LocalDateTime localDateTime(TemporalAccessor temporalAccessor) {
        return LocalDateTime.from(temporalAccessor);
    }

    public ZonedDateTime zonedDateTime(TemporalAccessor temporalAccessor) {
        return ZonedDateTime.from(temporalAccessor);
    }

    public ZonedDateTime zonedDateTime(Instant instant, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    public LocalDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    public LocalDate dateNow(ZoneId zoneId) {
        return this.dateNow(Clock.system(zoneId));
    }

    public LocalDate dateNow(Clock clock) {
        Jdk8Methods.requireNonNull(clock, "clock");
        return this.date(LocalDate.now(clock));
    }

    public boolean isLeapYear(long l) {
        return (l & 3L) == 0L && (l % 100L != 0L || l % 400L == 0L);
    }

    public int prolepticYear(Era era, int n) {
        if (!(era instanceof IsoEra)) {
            throw new ClassCastException("Era must be IsoEra");
        }
        return era == IsoEra.CE ? n : 1 - n;
    }

    public IsoEra eraOf(int n) {
        return IsoEra.of(n);
    }

    public List eras() {
        return Arrays.asList(IsoEra.values());
    }

    public ValueRange range(ChronoField chronoField) {
        return chronoField.range();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LocalDate resolveDate(Map map, ResolverStyle resolverStyle) {
        Long l;
        if (map.containsKey(ChronoField.EPOCH_DAY)) {
            return LocalDate.ofEpochDay((Long)map.remove(ChronoField.EPOCH_DAY));
        }
        Long l2 = (Long)map.remove(ChronoField.PROLEPTIC_MONTH);
        if (l2 != null) {
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.PROLEPTIC_MONTH.checkValidValue(l2);
            }
            this.updateResolveMap(map, ChronoField.MONTH_OF_YEAR, Jdk8Methods.floorMod((long)l2, 12) + 1);
            this.updateResolveMap(map, ChronoField.YEAR, Jdk8Methods.floorDiv(l2, 12L));
        }
        if ((l = (Long)map.remove(ChronoField.YEAR_OF_ERA)) != null) {
            Long l3;
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.YEAR_OF_ERA.checkValidValue(l);
            }
            if ((l3 = (Long)map.remove(ChronoField.ERA)) == null) {
                Long l4 = (Long)map.get(ChronoField.YEAR);
                if (resolverStyle == ResolverStyle.STRICT) {
                    if (l4 != null) {
                        this.updateResolveMap(map, ChronoField.YEAR, l4 > 0L ? l : Jdk8Methods.safeSubtract(1L, l));
                    } else {
                        map.put(ChronoField.YEAR_OF_ERA, l);
                    }
                } else {
                    this.updateResolveMap(map, ChronoField.YEAR, l4 == null || l4 > 0L ? l : Jdk8Methods.safeSubtract(1L, l));
                }
            } else if (l3 == 1L) {
                this.updateResolveMap(map, ChronoField.YEAR, l);
            } else {
                if (l3 != 0L) throw new DateTimeException("Invalid value for era: " + l3);
                this.updateResolveMap(map, ChronoField.YEAR, Jdk8Methods.safeSubtract(1L, l));
            }
        } else if (map.containsKey(ChronoField.ERA)) {
            ChronoField.ERA.checkValidValue((Long)map.get(ChronoField.ERA));
        }
        if (!map.containsKey(ChronoField.YEAR)) return null;
        if (map.containsKey(ChronoField.MONTH_OF_YEAR)) {
            if (map.containsKey(ChronoField.DAY_OF_MONTH)) {
                int n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
                int n2 = Jdk8Methods.safeToInt((Long)map.remove(ChronoField.MONTH_OF_YEAR));
                int n3 = Jdk8Methods.safeToInt((Long)map.remove(ChronoField.DAY_OF_MONTH));
                if (resolverStyle == ResolverStyle.LENIENT) {
                    long l5 = Jdk8Methods.safeSubtract(n2, 1);
                    long l6 = Jdk8Methods.safeSubtract(n3, 1);
                    return LocalDate.of(n, 1, 1).plusMonths(l5).plusDays(l6);
                }
                if (resolverStyle != ResolverStyle.SMART) return LocalDate.of(n, n2, n3);
                ChronoField.DAY_OF_MONTH.checkValidValue(n3);
                if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
                    n3 = Math.min(n3, 30);
                    return LocalDate.of(n, n2, n3);
                } else {
                    if (n2 != 2) return LocalDate.of(n, n2, n3);
                    n3 = Math.min(n3, Month.FEBRUARY.length(Year.isLeap(n)));
                }
                return LocalDate.of(n, n2, n3);
            }
            if (map.containsKey(ChronoField.ALIGNED_WEEK_OF_MONTH)) {
                if (map.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH)) {
                    int n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
                    if (resolverStyle == ResolverStyle.LENIENT) {
                        long l7 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.MONTH_OF_YEAR), 1L);
                        long l8 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH), 1L);
                        long l9 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH), 1L);
                        return LocalDate.of(n, 1, 1).plusMonths(l7).plusWeeks(l8).plusDays(l9);
                    }
                    int n4 = ChronoField.MONTH_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.MONTH_OF_YEAR));
                    int n5 = ChronoField.ALIGNED_WEEK_OF_MONTH.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH));
                    int n6 = ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH));
                    LocalDate localDate = LocalDate.of(n, n4, 1).plusDays((n5 - 1) * 7 + (n6 - 1));
                    if (resolverStyle != ResolverStyle.STRICT || localDate.get(ChronoField.MONTH_OF_YEAR) == n4) return localDate;
                    throw new DateTimeException("Strict mode rejected date parsed to a different month");
                }
                if (map.containsKey(ChronoField.DAY_OF_WEEK)) {
                    int n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
                    if (resolverStyle == ResolverStyle.LENIENT) {
                        long l10 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.MONTH_OF_YEAR), 1L);
                        long l11 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH), 1L);
                        long l12 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_WEEK), 1L);
                        return LocalDate.of(n, 1, 1).plusMonths(l10).plusWeeks(l11).plusDays(l12);
                    }
                    int n7 = ChronoField.MONTH_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.MONTH_OF_YEAR));
                    int n8 = ChronoField.ALIGNED_WEEK_OF_MONTH.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH));
                    int n9 = ChronoField.DAY_OF_WEEK.checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_WEEK));
                    LocalDate localDate = LocalDate.of(n, n7, 1).plusWeeks(n8 - 1).with(TemporalAdjusters.nextOrSame(DayOfWeek.of(n9)));
                    if (resolverStyle != ResolverStyle.STRICT || localDate.get(ChronoField.MONTH_OF_YEAR) == n7) return localDate;
                    throw new DateTimeException("Strict mode rejected date parsed to a different month");
                }
            }
        }
        if (map.containsKey(ChronoField.DAY_OF_YEAR)) {
            int n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
            if (resolverStyle == ResolverStyle.LENIENT) {
                long l13 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_YEAR), 1L);
                return LocalDate.ofYearDay(n, 1).plusDays(l13);
            }
            int n10 = ChronoField.DAY_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_YEAR));
            return LocalDate.ofYearDay(n, n10);
        }
        if (!map.containsKey(ChronoField.ALIGNED_WEEK_OF_YEAR)) return null;
        if (map.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR)) {
            int n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
            if (resolverStyle == ResolverStyle.LENIENT) {
                long l14 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR), 1L);
                long l15 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR), 1L);
                return LocalDate.of(n, 1, 1).plusWeeks(l14).plusDays(l15);
            }
            int n11 = ChronoField.ALIGNED_WEEK_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR));
            int n12 = ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR));
            LocalDate localDate = LocalDate.of(n, 1, 1).plusDays((n11 - 1) * 7 + (n12 - 1));
            if (resolverStyle != ResolverStyle.STRICT || localDate.get(ChronoField.YEAR) == n) return localDate;
            throw new DateTimeException("Strict mode rejected date parsed to a different year");
        }
        if (!map.containsKey(ChronoField.DAY_OF_WEEK)) return null;
        int n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
        if (resolverStyle == ResolverStyle.LENIENT) {
            long l16 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR), 1L);
            long l17 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_WEEK), 1L);
            return LocalDate.of(n, 1, 1).plusWeeks(l16).plusDays(l17);
        }
        int n13 = ChronoField.ALIGNED_WEEK_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR));
        int n14 = ChronoField.DAY_OF_WEEK.checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_WEEK));
        LocalDate localDate = LocalDate.of(n, 1, 1).plusWeeks(n13 - 1).with(TemporalAdjusters.nextOrSame(DayOfWeek.of(n14)));
        if (resolverStyle != ResolverStyle.STRICT || localDate.get(ChronoField.YEAR) == n) return localDate;
        throw new DateTimeException("Strict mode rejected date parsed to a different month");
    }
}

