/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Calendar;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Period;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.ChronoDateImpl;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoPeriod;
import oz.threeten.bp.chrono.JapaneseChronology;
import oz.threeten.bp.chrono.JapaneseEra;
import oz.threeten.bp.chrono.Ser;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjuster;
import oz.threeten.bp.temporal.TemporalAmount;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;

public final class JapaneseDate
extends ChronoDateImpl
implements Serializable {
    private static final long serialVersionUID = -305327627230580483L;
    static final LocalDate MIN_DATE = LocalDate.of(1873, 1, 1);
    private final LocalDate isoDate;
    private transient JapaneseEra era;
    private transient int yearOfEra;

    public static JapaneseDate now() {
        return JapaneseDate.now(Clock.systemDefaultZone());
    }

    public static JapaneseDate now(ZoneId zoneId) {
        return JapaneseDate.now(Clock.system(zoneId));
    }

    public static JapaneseDate now(Clock clock) {
        return new JapaneseDate(LocalDate.now(clock));
    }

    public static JapaneseDate of(JapaneseEra japaneseEra, int n, int n2, int n3) {
        Jdk8Methods.requireNonNull(japaneseEra, "era");
        if (n < 1) {
            throw new DateTimeException("Invalid YearOfEra: " + n);
        }
        LocalDate localDate = japaneseEra.startDate();
        LocalDate localDate2 = japaneseEra.endDate();
        int n4 = localDate.getYear() - 1;
        LocalDate localDate3 = LocalDate.of(n + n4, n2, n3);
        if (localDate3.isBefore(localDate) || localDate3.isAfter(localDate2)) {
            throw new DateTimeException("Requested date is outside bounds of era " + japaneseEra);
        }
        return new JapaneseDate(japaneseEra, n, localDate3);
    }

    static JapaneseDate ofYearDay(JapaneseEra japaneseEra, int n, int n2) {
        Jdk8Methods.requireNonNull(japaneseEra, "era");
        if (n < 1) {
            throw new DateTimeException("Invalid YearOfEra: " + n);
        }
        LocalDate localDate = japaneseEra.startDate();
        LocalDate localDate2 = japaneseEra.endDate();
        if (n == 1 && (n2 += localDate.getDayOfYear() - 1) > localDate.lengthOfYear()) {
            throw new DateTimeException("DayOfYear exceeds maximum allowed in the first year of era " + japaneseEra);
        }
        int n3 = localDate.getYear() - 1;
        LocalDate localDate3 = LocalDate.ofYearDay(n + n3, n2);
        if (localDate3.isBefore(localDate) || localDate3.isAfter(localDate2)) {
            throw new DateTimeException("Requested date is outside bounds of era " + japaneseEra);
        }
        return new JapaneseDate(japaneseEra, n, localDate3);
    }

    public static JapaneseDate of(int n, int n2, int n3) {
        return new JapaneseDate(LocalDate.of(n, n2, n3));
    }

    public static JapaneseDate from(TemporalAccessor temporalAccessor) {
        return JapaneseChronology.INSTANCE.date(temporalAccessor);
    }

    JapaneseDate(LocalDate localDate) {
        if (localDate.isBefore(MIN_DATE)) {
            throw new DateTimeException("Minimum supported date is January 1st Meiji 6");
        }
        this.era = JapaneseEra.from(localDate);
        int n = this.era.startDate().getYear() - 1;
        this.yearOfEra = localDate.getYear() - n;
        this.isoDate = localDate;
    }

    JapaneseDate(JapaneseEra japaneseEra, int n, LocalDate localDate) {
        if (localDate.isBefore(MIN_DATE)) {
            throw new DateTimeException("Minimum supported date is January 1st Meiji 6");
        }
        this.era = japaneseEra;
        this.yearOfEra = n;
        this.isoDate = localDate;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.era = JapaneseEra.from(this.isoDate);
        int n = this.era.startDate().getYear() - 1;
        this.yearOfEra = this.isoDate.getYear() - n;
    }

    public JapaneseChronology getChronology() {
        return JapaneseChronology.INSTANCE;
    }

    public JapaneseEra getEra() {
        return this.era;
    }

    public int lengthOfMonth() {
        return this.isoDate.lengthOfMonth();
    }

    public int lengthOfYear() {
        Calendar calendar = Calendar.getInstance(JapaneseChronology.LOCALE);
        calendar.set(0, this.era.getValue() + 2);
        calendar.set(this.yearOfEra, this.isoDate.getMonthValue() - 1, this.isoDate.getDayOfMonth());
        return calendar.getActualMaximum(6);
    }

    public boolean isSupported(TemporalField temporalField) {
        if (temporalField == ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH || temporalField == ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR || temporalField == ChronoField.ALIGNED_WEEK_OF_MONTH || temporalField == ChronoField.ALIGNED_WEEK_OF_YEAR) {
            return false;
        }
        return super.isSupported(temporalField);
    }

    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (this.isSupported(temporalField)) {
                ChronoField chronoField = (ChronoField)temporalField;
                switch (chronoField) {
                    case DAY_OF_YEAR: {
                        return this.actualRange(6);
                    }
                    case YEAR_OF_ERA: {
                        return this.actualRange(1);
                    }
                }
                return this.getChronology().range(chronoField);
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    private ValueRange actualRange(int n) {
        Calendar calendar = Calendar.getInstance(JapaneseChronology.LOCALE);
        calendar.set(0, this.era.getValue() + 2);
        calendar.set(this.yearOfEra, this.isoDate.getMonthValue() - 1, this.isoDate.getDayOfMonth());
        return ValueRange.of(calendar.getActualMinimum(n), calendar.getActualMaximum(n));
    }

    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case ALIGNED_DAY_OF_WEEK_IN_MONTH: 
                case ALIGNED_DAY_OF_WEEK_IN_YEAR: 
                case ALIGNED_WEEK_OF_MONTH: 
                case ALIGNED_WEEK_OF_YEAR: {
                    throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
                }
                case YEAR_OF_ERA: {
                    return this.yearOfEra;
                }
                case ERA: {
                    return this.era.getValue();
                }
                case DAY_OF_YEAR: {
                    return this.getDayOfYear();
                }
            }
            return this.isoDate.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    private long getDayOfYear() {
        if (this.yearOfEra == 1) {
            return this.isoDate.getDayOfYear() - this.era.startDate().getDayOfYear() + 1;
        }
        return this.isoDate.getDayOfYear();
    }

    public JapaneseDate with(TemporalAdjuster temporalAdjuster) {
        return (JapaneseDate)super.with(temporalAdjuster);
    }

    public JapaneseDate with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            if (this.getLong(chronoField) == l) {
                return this;
            }
            switch (chronoField) {
                case DAY_OF_YEAR: 
                case YEAR_OF_ERA: 
                case ERA: {
                    int n = this.getChronology().range(chronoField).checkValidIntValue(l, chronoField);
                    switch (chronoField) {
                        case DAY_OF_YEAR: {
                            return this.with(this.isoDate.plusDays((long)n - this.getDayOfYear()));
                        }
                        case YEAR_OF_ERA: {
                            return this.withYear(n);
                        }
                        case ERA: {
                            return this.withYear(JapaneseEra.of(n), this.yearOfEra);
                        }
                    }
                }
            }
            return this.with(this.isoDate.with(temporalField, l));
        }
        return (JapaneseDate)temporalField.adjustInto(this, l);
    }

    public JapaneseDate plus(TemporalAmount temporalAmount) {
        return (JapaneseDate)super.plus(temporalAmount);
    }

    public JapaneseDate plus(long l, TemporalUnit temporalUnit) {
        return (JapaneseDate)super.plus(l, temporalUnit);
    }

    public JapaneseDate minus(TemporalAmount temporalAmount) {
        return (JapaneseDate)super.minus(temporalAmount);
    }

    public JapaneseDate minus(long l, TemporalUnit temporalUnit) {
        return (JapaneseDate)super.minus(l, temporalUnit);
    }

    private JapaneseDate withYear(JapaneseEra japaneseEra, int n) {
        int n2 = JapaneseChronology.INSTANCE.prolepticYear(japaneseEra, n);
        return this.with(this.isoDate.withYear(n2));
    }

    private JapaneseDate withYear(int n) {
        return this.withYear(this.getEra(), n);
    }

    JapaneseDate plusYears(long l) {
        return this.with(this.isoDate.plusYears(l));
    }

    JapaneseDate plusMonths(long l) {
        return this.with(this.isoDate.plusMonths(l));
    }

    JapaneseDate plusDays(long l) {
        return this.with(this.isoDate.plusDays(l));
    }

    private JapaneseDate with(LocalDate localDate) {
        return localDate.equals(this.isoDate) ? this : new JapaneseDate(localDate);
    }

    public final ChronoLocalDateTime atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    public ChronoPeriod until(ChronoLocalDate chronoLocalDate) {
        Period period = this.isoDate.until(chronoLocalDate);
        return this.getChronology().period(period.getYears(), period.getMonths(), period.getDays());
    }

    public long toEpochDay() {
        return this.isoDate.toEpochDay();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JapaneseDate) {
            JapaneseDate japaneseDate = (JapaneseDate)object;
            return this.isoDate.equals(japaneseDate.isoDate);
        }
        return false;
    }

    public int hashCode() {
        return this.getChronology().getId().hashCode() ^ this.isoDate.hashCode();
    }

    private Object writeReplace() {
        return new Ser(1, this);
    }

    void writeExternal(DataOutput dataOutput) {
        dataOutput.writeInt(this.get(ChronoField.YEAR));
        dataOutput.writeByte(this.get(ChronoField.MONTH_OF_YEAR));
        dataOutput.writeByte(this.get(ChronoField.DAY_OF_MONTH));
    }

    static ChronoLocalDate readExternal(DataInput dataInput) {
        int n = dataInput.readInt();
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        return JapaneseChronology.INSTANCE.date(n, by, by2);
    }
}

