/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.chrono;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oz.threeten.bp.Clock;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.Instant;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoZonedDateTime;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.Era;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.chrono.MinguoDate;
import oz.threeten.bp.chrono.MinguoEra;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalAdjusters;
import oz.threeten.bp.temporal.ValueRange;

public final class MinguoChronology
extends Chronology
implements Serializable {
    public static final MinguoChronology INSTANCE = new MinguoChronology();
    private static final long serialVersionUID = 1039765215346859963L;
    static final int YEARS_DIFFERENCE = 1911;

    private MinguoChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public String getId() {
        return "Minguo";
    }

    public String getCalendarType() {
        return "roc";
    }

    public MinguoDate date(Era era, int n, int n2, int n3) {
        return (MinguoDate)super.date(era, n, n2, n3);
    }

    public MinguoDate date(int n, int n2, int n3) {
        return new MinguoDate(LocalDate.of(n + 1911, n2, n3));
    }

    public MinguoDate dateYearDay(Era era, int n, int n2) {
        return (MinguoDate)super.dateYearDay(era, n, n2);
    }

    public MinguoDate dateYearDay(int n, int n2) {
        return new MinguoDate(LocalDate.ofYearDay(n + 1911, n2));
    }

    public MinguoDate dateEpochDay(long l) {
        return new MinguoDate(LocalDate.ofEpochDay(l));
    }

    public MinguoDate date(TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof MinguoDate) {
            return (MinguoDate)temporalAccessor;
        }
        return new MinguoDate(LocalDate.from(temporalAccessor));
    }

    public ChronoLocalDateTime localDateTime(TemporalAccessor temporalAccessor) {
        return super.localDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime zonedDateTime(TemporalAccessor temporalAccessor) {
        return super.zonedDateTime(temporalAccessor);
    }

    public ChronoZonedDateTime zonedDateTime(Instant instant, ZoneId zoneId) {
        return super.zonedDateTime(instant, zoneId);
    }

    public MinguoDate dateNow() {
        return (MinguoDate)super.dateNow();
    }

    public MinguoDate dateNow(ZoneId zoneId) {
        return (MinguoDate)super.dateNow(zoneId);
    }

    public MinguoDate dateNow(Clock clock) {
        Jdk8Methods.requireNonNull(clock, "clock");
        return (MinguoDate)super.dateNow(clock);
    }

    public boolean isLeapYear(long l) {
        return IsoChronology.INSTANCE.isLeapYear(l + 1911L);
    }

    public int prolepticYear(Era era, int n) {
        if (!(era instanceof MinguoEra)) {
            throw new ClassCastException("Era must be MinguoEra");
        }
        return era == MinguoEra.ROC ? n : 1 - n;
    }

    public MinguoEra eraOf(int n) {
        return MinguoEra.of(n);
    }

    public List eras() {
        return Arrays.asList(MinguoEra.values());
    }

    public ValueRange range(ChronoField chronoField) {
        switch (chronoField) {
            case PROLEPTIC_MONTH: {
                ValueRange valueRange = ChronoField.PROLEPTIC_MONTH.range();
                return ValueRange.of(valueRange.getMinimum() - 22932L, valueRange.getMaximum() - 22932L);
            }
            case YEAR_OF_ERA: {
                ValueRange valueRange = ChronoField.YEAR.range();
                return ValueRange.of(1L, valueRange.getMaximum() - 1911L, -valueRange.getMinimum() + 1L + 1911L);
            }
            case YEAR: {
                ValueRange valueRange = ChronoField.YEAR.range();
                return ValueRange.of(valueRange.getMinimum() - 1911L, valueRange.getMaximum() - 1911L);
            }
        }
        return chronoField.range();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MinguoDate resolveDate(Map map, ResolverStyle resolverStyle) {
        Long l;
        if (map.containsKey(ChronoField.EPOCH_DAY)) {
            return this.dateEpochDay((Long)map.remove(ChronoField.EPOCH_DAY));
        }
        Long l2 = (Long)map.remove(ChronoField.PROLEPTIC_MONTH);
        if (l2 != null) {
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.PROLEPTIC_MONTH.checkValidValue(l2);
            }
            this.updateResolveMap(map, ChronoField.MONTH_OF_YEAR, Jdk8Methods.floorMod((long)l2, 12) + 1);
            this.updateResolveMap(map, ChronoField.YEAR, Jdk8Methods.floorDiv(l2, 12L));
        }
        if ((l = (Long)map.remove(ChronoField.YEAR_OF_ERA)) != null) {
            Long l3;
            if (resolverStyle != ResolverStyle.LENIENT) {
                ChronoField.YEAR_OF_ERA.checkValidValue(l);
            }
            if ((l3 = (Long)map.remove(ChronoField.ERA)) == null) {
                Long l4 = (Long)map.get(ChronoField.YEAR);
                if (resolverStyle == ResolverStyle.STRICT) {
                    if (l4 != null) {
                        this.updateResolveMap(map, ChronoField.YEAR, l4 > 0L ? l : Jdk8Methods.safeSubtract(1L, l));
                    } else {
                        map.put(ChronoField.YEAR_OF_ERA, l);
                    }
                } else {
                    this.updateResolveMap(map, ChronoField.YEAR, l4 == null || l4 > 0L ? l : Jdk8Methods.safeSubtract(1L, l));
                }
            } else if (l3 == 1L) {
                this.updateResolveMap(map, ChronoField.YEAR, l);
            } else {
                if (l3 != 0L) throw new DateTimeException("Invalid value for era: " + l3);
                this.updateResolveMap(map, ChronoField.YEAR, Jdk8Methods.safeSubtract(1L, l));
            }
        } else if (map.containsKey(ChronoField.ERA)) {
            ChronoField.ERA.checkValidValue((Long)map.get(ChronoField.ERA));
        }
        if (!map.containsKey(ChronoField.YEAR)) return null;
        if (map.containsKey(ChronoField.MONTH_OF_YEAR)) {
            if (map.containsKey(ChronoField.DAY_OF_MONTH)) {
                int n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
                if (resolverStyle == ResolverStyle.LENIENT) {
                    long l5 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.MONTH_OF_YEAR), 1L);
                    long l6 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_MONTH), 1L);
                    return this.date(n, 1, 1).plusMonths(l5).plusDays(l6);
                }
                int n2 = this.range(ChronoField.MONTH_OF_YEAR).checkValidIntValue((Long)map.remove(ChronoField.MONTH_OF_YEAR), ChronoField.MONTH_OF_YEAR);
                int n3 = this.range(ChronoField.DAY_OF_MONTH).checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_MONTH), ChronoField.DAY_OF_MONTH);
                if (resolverStyle != ResolverStyle.SMART || n3 <= 28) return this.date(n, n2, n3);
                n3 = Math.min(n3, this.date(n, n2, 1).lengthOfMonth());
                return this.date(n, n2, n3);
            }
            if (map.containsKey(ChronoField.ALIGNED_WEEK_OF_MONTH)) {
                if (map.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH)) {
                    int n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
                    if (resolverStyle == ResolverStyle.LENIENT) {
                        long l7 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.MONTH_OF_YEAR), 1L);
                        long l8 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH), 1L);
                        long l9 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH), 1L);
                        return this.date(n, 1, 1).plus(l7, ChronoUnit.MONTHS).plus(l8, ChronoUnit.WEEKS).plus(l9, ChronoUnit.DAYS);
                    }
                    int n4 = ChronoField.MONTH_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.MONTH_OF_YEAR));
                    int n5 = ChronoField.ALIGNED_WEEK_OF_MONTH.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH));
                    int n6 = ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH));
                    MinguoDate minguoDate = this.date(n, n4, 1).plus((n5 - 1) * 7 + (n6 - 1), ChronoUnit.DAYS);
                    if (resolverStyle != ResolverStyle.STRICT || minguoDate.get(ChronoField.MONTH_OF_YEAR) == n4) return minguoDate;
                    throw new DateTimeException("Strict mode rejected date parsed to a different month");
                }
                if (map.containsKey(ChronoField.DAY_OF_WEEK)) {
                    int n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
                    if (resolverStyle == ResolverStyle.LENIENT) {
                        long l10 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.MONTH_OF_YEAR), 1L);
                        long l11 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH), 1L);
                        long l12 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_WEEK), 1L);
                        return this.date(n, 1, 1).plus(l10, ChronoUnit.MONTHS).plus(l11, ChronoUnit.WEEKS).plus(l12, ChronoUnit.DAYS);
                    }
                    int n7 = ChronoField.MONTH_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.MONTH_OF_YEAR));
                    int n8 = ChronoField.ALIGNED_WEEK_OF_MONTH.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_MONTH));
                    int n9 = ChronoField.DAY_OF_WEEK.checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_WEEK));
                    MinguoDate minguoDate = this.date(n, n7, 1).plus(n8 - 1, ChronoUnit.WEEKS).with(TemporalAdjusters.nextOrSame(DayOfWeek.of(n9)));
                    if (resolverStyle != ResolverStyle.STRICT || minguoDate.get(ChronoField.MONTH_OF_YEAR) == n7) return minguoDate;
                    throw new DateTimeException("Strict mode rejected date parsed to a different month");
                }
            }
        }
        if (map.containsKey(ChronoField.DAY_OF_YEAR)) {
            int n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
            if (resolverStyle == ResolverStyle.LENIENT) {
                long l13 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_YEAR), 1L);
                return this.dateYearDay(n, 1).plusDays(l13);
            }
            int n10 = ChronoField.DAY_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_YEAR));
            return this.dateYearDay(n, n10);
        }
        if (!map.containsKey(ChronoField.ALIGNED_WEEK_OF_YEAR)) return null;
        if (map.containsKey(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR)) {
            int n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
            if (resolverStyle == ResolverStyle.LENIENT) {
                long l14 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR), 1L);
                long l15 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR), 1L);
                return this.date(n, 1, 1).plus(l14, ChronoUnit.WEEKS).plus(l15, ChronoUnit.DAYS);
            }
            int n11 = ChronoField.ALIGNED_WEEK_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR));
            int n12 = ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR));
            MinguoDate minguoDate = this.date(n, 1, 1).plusDays((n11 - 1) * 7 + (n12 - 1));
            if (resolverStyle != ResolverStyle.STRICT || minguoDate.get(ChronoField.YEAR) == n) return minguoDate;
            throw new DateTimeException("Strict mode rejected date parsed to a different year");
        }
        if (!map.containsKey(ChronoField.DAY_OF_WEEK)) return null;
        int n = ChronoField.YEAR.checkValidIntValue((Long)map.remove(ChronoField.YEAR));
        if (resolverStyle == ResolverStyle.LENIENT) {
            long l16 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR), 1L);
            long l17 = Jdk8Methods.safeSubtract((Long)map.remove(ChronoField.DAY_OF_WEEK), 1L);
            return this.date(n, 1, 1).plus(l16, ChronoUnit.WEEKS).plus(l17, ChronoUnit.DAYS);
        }
        int n13 = ChronoField.ALIGNED_WEEK_OF_YEAR.checkValidIntValue((Long)map.remove(ChronoField.ALIGNED_WEEK_OF_YEAR));
        int n14 = ChronoField.DAY_OF_WEEK.checkValidIntValue((Long)map.remove(ChronoField.DAY_OF_WEEK));
        MinguoDate minguoDate = this.date(n, 1, 1).plus(n13 - 1, ChronoUnit.WEEKS).with(TemporalAdjusters.nextOrSame(DayOfWeek.of(n14)));
        if (resolverStyle != ResolverStyle.STRICT || minguoDate.get(ChronoField.YEAR) == n) return minguoDate;
        throw new DateTimeException("Strict mode rejected date parsed to a different month");
    }
}

