/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.format.DateTimeFormatterBuilder;
import oz.threeten.bp.format.DateTimeFormatterBuilder$DateTimePrinterParser;
import oz.threeten.bp.format.DateTimeParseContext;
import oz.threeten.bp.format.DateTimePrintContext;
import oz.threeten.bp.format.TextStyle;
import oz.threeten.bp.temporal.TemporalQueries;

final class DateTimeFormatterBuilder$ChronoPrinterParser
implements DateTimeFormatterBuilder$DateTimePrinterParser {
    private final TextStyle textStyle;

    DateTimeFormatterBuilder$ChronoPrinterParser(TextStyle textStyle) {
        this.textStyle = textStyle;
    }

    public boolean print(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
        Chronology chronology = (Chronology)dateTimePrintContext.getValue(TemporalQueries.chronology());
        if (chronology == null) {
            return false;
        }
        if (this.textStyle == null) {
            stringBuilder.append(chronology.getId());
        } else {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oz.threeten.bp.format.ChronologyText", dateTimePrintContext.getLocale(), DateTimeFormatterBuilder.class.getClassLoader());
            try {
                String string = resourceBundle.getString(chronology.getId());
                stringBuilder.append(string);
            }
            catch (MissingResourceException missingResourceException) {
                stringBuilder.append(chronology.getId());
            }
        }
        return true;
    }

    public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
        if (n < 0 || n > charSequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        Set set = Chronology.getAvailableChronologies();
        Chronology chronology = null;
        int n2 = -1;
        for (Chronology chronology2 : set) {
            String string = chronology2.getId();
            int n3 = string.length();
            if (n3 <= n2 || !dateTimeParseContext.subSequenceEquals(charSequence, n, string, 0, n3)) continue;
            chronology = chronology2;
            n2 = n3;
        }
        if (chronology == null) {
            return ~n;
        }
        dateTimeParseContext.setParsed(chronology);
        return n + n2;
    }
}

