/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.format.DateTimeFormatterBuilder;
import oz.threeten.bp.format.DateTimeFormatterBuilder$CompositePrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$DateTimePrinterParser;
import oz.threeten.bp.format.DateTimeParseContext;
import oz.threeten.bp.format.DateTimePrintContext;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;

final class DateTimeFormatterBuilder$InstantPrinterParser
implements DateTimeFormatterBuilder$DateTimePrinterParser {
    private static final long SECONDS_PER_10000_YEARS = 315569520000L;
    private static final long SECONDS_0000_TO_1970 = 62167219200L;
    private final int fractionalDigits;

    DateTimeFormatterBuilder$InstantPrinterParser(int n) {
        this.fractionalDigits = n;
    }

    public boolean print(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
        LocalDateTime localDateTime;
        long l;
        long l2;
        long l3;
        Long l4 = dateTimePrintContext.getValue(ChronoField.INSTANT_SECONDS);
        Long l5 = 0L;
        if (dateTimePrintContext.getTemporal().isSupported(ChronoField.NANO_OF_SECOND)) {
            l5 = dateTimePrintContext.getTemporal().getLong(ChronoField.NANO_OF_SECOND);
        }
        if (l4 == null) {
            return false;
        }
        long l6 = l4;
        int n = ChronoField.NANO_OF_SECOND.checkValidIntValue(l5);
        if (l6 >= -62167219200L) {
            l3 = l6 - 315569520000L + 62167219200L;
            l2 = Jdk8Methods.floorDiv(l3, 315569520000L) + 1L;
            l = Jdk8Methods.floorMod(l3, 315569520000L);
            localDateTime = LocalDateTime.ofEpochSecond(l - 62167219200L, 0, ZoneOffset.UTC);
            if (l2 > 0L) {
                stringBuilder.append('+').append(l2);
            }
            stringBuilder.append(localDateTime);
            if (localDateTime.getSecond() == 0) {
                stringBuilder.append(":00");
            }
        } else {
            l3 = l6 + 62167219200L;
            l2 = l3 / 315569520000L;
            l = l3 % 315569520000L;
            localDateTime = LocalDateTime.ofEpochSecond(l - 62167219200L, 0, ZoneOffset.UTC);
            int n2 = stringBuilder.length();
            stringBuilder.append(localDateTime);
            if (localDateTime.getSecond() == 0) {
                stringBuilder.append(":00");
            }
            if (l2 < 0L) {
                if (localDateTime.getYear() == -10000) {
                    stringBuilder.replace(n2, n2 + 2, Long.toString(l2 - 1L));
                } else if (l == 0L) {
                    stringBuilder.insert(n2, l2);
                } else {
                    stringBuilder.insert(n2 + 1, Math.abs(l2));
                }
            }
        }
        if (this.fractionalDigits == -2) {
            if (n != 0) {
                stringBuilder.append('.');
                if (n % 1000000 == 0) {
                    stringBuilder.append(Integer.toString(n / 1000000 + 1000).substring(1));
                } else if (n % 1000 == 0) {
                    stringBuilder.append(Integer.toString(n / 1000 + 1000000).substring(1));
                } else {
                    stringBuilder.append(Integer.toString(n + 1000000000).substring(1));
                }
            }
        } else if (this.fractionalDigits > 0 || this.fractionalDigits == -1 && n > 0) {
            stringBuilder.append('.');
            int n3 = 100000000;
            for (int j = 0; this.fractionalDigits == -1 && n > 0 || j < this.fractionalDigits; ++j) {
                int n4 = n / n3;
                stringBuilder.append((char)(n4 + 48));
                n -= n4 * n3;
                n3 /= 10;
            }
        }
        stringBuilder.append('Z');
        return true;
    }

    public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
        DateTimeParseContext dateTimeParseContext2 = dateTimeParseContext.copy();
        int n2 = this.fractionalDigits < 0 ? 0 : this.fractionalDigits;
        int n3 = this.fractionalDigits < 0 ? 9 : this.fractionalDigits;
        DateTimeFormatterBuilder$CompositePrinterParser dateTimeFormatterBuilder$CompositePrinterParser = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, n2, n3, true).appendLiteral('Z').toFormatter().toPrinterParser(false);
        int n4 = dateTimeFormatterBuilder$CompositePrinterParser.parse(dateTimeParseContext2, charSequence, n);
        if (n4 < 0) {
            return n4;
        }
        long l = dateTimeParseContext2.getParsed(ChronoField.YEAR);
        int n5 = dateTimeParseContext2.getParsed(ChronoField.MONTH_OF_YEAR).intValue();
        int n6 = dateTimeParseContext2.getParsed(ChronoField.DAY_OF_MONTH).intValue();
        int n7 = dateTimeParseContext2.getParsed(ChronoField.HOUR_OF_DAY).intValue();
        int n8 = dateTimeParseContext2.getParsed(ChronoField.MINUTE_OF_HOUR).intValue();
        Long l2 = dateTimeParseContext2.getParsed(ChronoField.SECOND_OF_MINUTE);
        Long l3 = dateTimeParseContext2.getParsed(ChronoField.NANO_OF_SECOND);
        int n9 = l2 != null ? l2.intValue() : 0;
        int n10 = l3 != null ? l3.intValue() : 0;
        int n11 = (int)l % 10000;
        int n12 = 0;
        if (n7 == 24 && n8 == 0 && n9 == 0 && n10 == 0) {
            n7 = 0;
            n12 = 1;
        } else if (n7 == 23 && n8 == 59 && n9 == 60) {
            dateTimeParseContext.setParsedLeapSecond();
            n9 = 59;
        }
        try {
            LocalDateTime localDateTime = LocalDateTime.of(n11, n5, n6, n7, n8, n9, 0).plusDays(n12);
            long l4 = localDateTime.toEpochSecond(ZoneOffset.UTC);
        }
        catch (RuntimeException runtimeException) {
            return ~n;
        }
        int n13 = n4;
        n13 = dateTimeParseContext.setParsedField(ChronoField.INSTANT_SECONDS, l4 += Jdk8Methods.safeMultiply(l / 10000L, 315569520000L), n, n13);
        return dateTimeParseContext.setParsedField(ChronoField.NANO_OF_SECOND, n10, n, n13);
    }

    public String toString() {
        return "Instant()";
    }
}

