/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.math.BigInteger;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.format.DateTimeFormatterBuilder$1;
import oz.threeten.bp.format.DateTimeFormatterBuilder$DateTimePrinterParser;
import oz.threeten.bp.format.DateTimeParseContext;
import oz.threeten.bp.format.DateTimePrintContext;
import oz.threeten.bp.format.DecimalStyle;
import oz.threeten.bp.format.SignStyle;
import oz.threeten.bp.temporal.TemporalField;

class DateTimeFormatterBuilder$NumberPrinterParser
implements DateTimeFormatterBuilder$DateTimePrinterParser {
    static final int[] EXCEED_POINTS = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    final TemporalField field;
    final int minWidth;
    final int maxWidth;
    final SignStyle signStyle;
    final int subsequentWidth;

    DateTimeFormatterBuilder$NumberPrinterParser(TemporalField temporalField, int n, int n2, SignStyle signStyle) {
        this.field = temporalField;
        this.minWidth = n;
        this.maxWidth = n2;
        this.signStyle = signStyle;
        this.subsequentWidth = 0;
    }

    private DateTimeFormatterBuilder$NumberPrinterParser(TemporalField temporalField, int n, int n2, SignStyle signStyle, int n3) {
        this.field = temporalField;
        this.minWidth = n;
        this.maxWidth = n2;
        this.signStyle = signStyle;
        this.subsequentWidth = n3;
    }

    DateTimeFormatterBuilder$NumberPrinterParser withFixedWidth() {
        if (this.subsequentWidth == -1) {
            return this;
        }
        return new DateTimeFormatterBuilder$NumberPrinterParser(this.field, this.minWidth, this.maxWidth, this.signStyle, -1);
    }

    DateTimeFormatterBuilder$NumberPrinterParser withSubsequentWidth(int n) {
        return new DateTimeFormatterBuilder$NumberPrinterParser(this.field, this.minWidth, this.maxWidth, this.signStyle, this.subsequentWidth + n);
    }

    public boolean print(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
        String string;
        Long l = dateTimePrintContext.getValue(this.field);
        if (l == null) {
            return false;
        }
        long l2 = this.getValue(dateTimePrintContext, l);
        DecimalStyle decimalStyle = dateTimePrintContext.getSymbols();
        String string2 = string = l2 == Long.MIN_VALUE ? "9223372036854775808" : Long.toString(Math.abs(l2));
        if (string.length() > this.maxWidth) {
            throw new DateTimeException("Field " + this.field + " cannot be printed as the value " + l2 + " exceeds the maximum print width of " + this.maxWidth);
        }
        string = decimalStyle.convertNumberToI18N(string);
        if (l2 >= 0L) {
            switch (this.signStyle) {
                case EXCEEDS_PAD: {
                    if (this.minWidth >= 19 || l2 < (long)EXCEED_POINTS[this.minWidth]) break;
                    stringBuilder.append(decimalStyle.getPositiveSign());
                    break;
                }
                case ALWAYS: {
                    stringBuilder.append(decimalStyle.getPositiveSign());
                }
            }
        } else {
            switch (this.signStyle) {
                case EXCEEDS_PAD: 
                case ALWAYS: 
                case NORMAL: {
                    stringBuilder.append(decimalStyle.getNegativeSign());
                    break;
                }
                case NOT_NEGATIVE: {
                    throw new DateTimeException("Field " + this.field + " cannot be printed as the value " + l2 + " cannot be negative according to the SignStyle");
                }
            }
        }
        for (int j = 0; j < this.minWidth - string.length(); ++j) {
            stringBuilder.append(decimalStyle.getZeroDigit());
        }
        stringBuilder.append(string);
        return true;
    }

    long getValue(DateTimePrintContext dateTimePrintContext, long l) {
        return l;
    }

    boolean isFixedWidth(DateTimeParseContext dateTimeParseContext) {
        return this.subsequentWidth == -1 || this.subsequentWidth > 0 && this.minWidth == this.maxWidth && this.signStyle == SignStyle.NOT_NEGATIVE;
    }

    public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
        int n2;
        int n3 = charSequence.length();
        if (n == n3) {
            return ~n;
        }
        char c2 = charSequence.charAt(n);
        boolean bl = false;
        boolean bl2 = false;
        if (c2 == dateTimeParseContext.getSymbols().getPositiveSign()) {
            if (!this.signStyle.parse(true, dateTimeParseContext.isStrict(), this.minWidth == this.maxWidth)) {
                return ~n;
            }
            bl2 = true;
            ++n;
        } else if (c2 == dateTimeParseContext.getSymbols().getNegativeSign()) {
            if (!this.signStyle.parse(false, dateTimeParseContext.isStrict(), this.minWidth == this.maxWidth)) {
                return ~n;
            }
            bl = true;
            ++n;
        } else if (this.signStyle == SignStyle.ALWAYS && dateTimeParseContext.isStrict()) {
            return ~n;
        }
        int n4 = dateTimeParseContext.isStrict() || this.isFixedWidth(dateTimeParseContext) ? this.minWidth : 1;
        int n5 = n + n4;
        if (n5 > n3) {
            return ~n;
        }
        int n6 = (dateTimeParseContext.isStrict() || this.isFixedWidth(dateTimeParseContext) ? this.maxWidth : 9) + Math.max(this.subsequentWidth, 0);
        long l = 0L;
        BigInteger bigInteger = null;
        int n7 = n;
        for (n2 = 0; n2 < 2; ++n2) {
            int n8;
            int n9 = Math.min(n7 + n6, n3);
            while (n7 < n9) {
                n8 = charSequence.charAt(n7++);
                int n10 = dateTimeParseContext.getSymbols().convertToDigit((char)n8);
                if (n10 < 0) {
                    if (--n7 >= n5) break;
                    return ~n;
                }
                if (n7 - n > 18) {
                    if (bigInteger == null) {
                        bigInteger = BigInteger.valueOf(l);
                    }
                    bigInteger = bigInteger.multiply(BigInteger.TEN).add(BigInteger.valueOf(n10));
                    continue;
                }
                l = l * 10L + (long)n10;
            }
            if (this.subsequentWidth <= 0 || n2 != 0) break;
            n8 = n7 - n;
            n6 = Math.max(n4, n8 - this.subsequentWidth);
            n7 = n;
            l = 0L;
            bigInteger = null;
        }
        if (bl) {
            if (bigInteger != null) {
                if (bigInteger.equals(BigInteger.ZERO) && dateTimeParseContext.isStrict()) {
                    return ~(n - 1);
                }
                bigInteger = bigInteger.negate();
            } else {
                if (l == 0L && dateTimeParseContext.isStrict()) {
                    return ~(n - 1);
                }
                l = -l;
            }
        } else if (this.signStyle == SignStyle.EXCEEDS_PAD && dateTimeParseContext.isStrict()) {
            n2 = n7 - n;
            if (bl2) {
                if (n2 <= this.minWidth) {
                    return ~(n - 1);
                }
            } else if (n2 > this.minWidth) {
                return ~n;
            }
        }
        if (bigInteger != null) {
            if (bigInteger.bitLength() > 63) {
                bigInteger = bigInteger.divide(BigInteger.TEN);
                --n7;
            }
            return this.setValue(dateTimeParseContext, bigInteger.longValue(), n, n7);
        }
        return this.setValue(dateTimeParseContext, l, n, n7);
    }

    int setValue(DateTimeParseContext dateTimeParseContext, long l, int n, int n2) {
        return dateTimeParseContext.setParsedField(this.field, l, n, n2);
    }

    public String toString() {
        if (this.minWidth == 1 && this.maxWidth == 19 && this.signStyle == SignStyle.NORMAL) {
            return "Value(" + this.field + ")";
        }
        if (this.minWidth == this.maxWidth && this.signStyle == SignStyle.NOT_NEGATIVE) {
            return "Value(" + this.field + "," + this.minWidth + ")";
        }
        return "Value(" + this.field + "," + this.minWidth + "," + this.maxWidth + "," + (Object)((Object)this.signStyle) + ")";
    }

    /* synthetic */ DateTimeFormatterBuilder$NumberPrinterParser(TemporalField temporalField, int n, int n2, SignStyle signStyle, int n3, DateTimeFormatterBuilder$1 dateTimeFormatterBuilder$1) {
        this(temporalField, n, n2, signStyle, n3);
    }
}

