/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.format.DateTimeFormatterBuilder$DateTimePrinterParser;
import oz.threeten.bp.format.DateTimeParseContext;
import oz.threeten.bp.format.DateTimePrintContext;

final class DateTimeFormatterBuilder$PadPrinterParserDecorator
implements DateTimeFormatterBuilder$DateTimePrinterParser {
    private final DateTimeFormatterBuilder$DateTimePrinterParser printerParser;
    private final int padWidth;
    private final char padChar;

    DateTimeFormatterBuilder$PadPrinterParserDecorator(DateTimeFormatterBuilder$DateTimePrinterParser dateTimeFormatterBuilder$DateTimePrinterParser, int n, char c2) {
        this.printerParser = dateTimeFormatterBuilder$DateTimePrinterParser;
        this.padWidth = n;
        this.padChar = c2;
    }

    public boolean print(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (!this.printerParser.print(dateTimePrintContext, stringBuilder)) {
            return false;
        }
        int n2 = stringBuilder.length() - n;
        if (n2 > this.padWidth) {
            throw new DateTimeException("Cannot print as output of " + n2 + " characters exceeds pad width of " + this.padWidth);
        }
        for (int j = 0; j < this.padWidth - n2; ++j) {
            stringBuilder.insert(n, this.padChar);
        }
        return true;
    }

    public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
        int n2;
        boolean bl = dateTimeParseContext.isStrict();
        boolean bl2 = dateTimeParseContext.isCaseSensitive();
        if (n > charSequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (n == charSequence.length()) {
            return ~n;
        }
        int n3 = n + this.padWidth;
        if (n3 > charSequence.length()) {
            if (bl) {
                return ~n;
            }
            n3 = charSequence.length();
        }
        for (n2 = n; n2 < n3 && (bl2 ? charSequence.charAt(n2) == this.padChar : dateTimeParseContext.charEquals(charSequence.charAt(n2), this.padChar)); ++n2) {
        }
        int n4 = this.printerParser.parse(dateTimeParseContext, charSequence = charSequence.subSequence(0, n3), n2);
        if (n4 != n3 && bl) {
            return ~(n + n2);
        }
        return n4;
    }

    public String toString() {
        return "Pad(" + this.printerParser + "," + this.padWidth + (this.padChar == ' ' ? ")" : ",'" + this.padChar + "')");
    }
}

