/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.format.DateTimeFormatterBuilder$NumberPrinterParser;
import oz.threeten.bp.format.DateTimeParseContext;
import oz.threeten.bp.format.DateTimePrintContext;
import oz.threeten.bp.format.SignStyle;
import oz.threeten.bp.temporal.TemporalField;

final class DateTimeFormatterBuilder$ReducedPrinterParser
extends DateTimeFormatterBuilder$NumberPrinterParser {
    static final LocalDate BASE_DATE = LocalDate.of(2000, 1, 1);
    private final int baseValue;
    private final ChronoLocalDate baseDate;

    DateTimeFormatterBuilder$ReducedPrinterParser(TemporalField temporalField, int n, int n2, int n3, ChronoLocalDate chronoLocalDate) {
        super(temporalField, n, n2, SignStyle.NOT_NEGATIVE);
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException("The width must be from 1 to 10 inclusive but was " + n);
        }
        if (n2 < 1 || n2 > 10) {
            throw new IllegalArgumentException("The maxWidth must be from 1 to 10 inclusive but was " + n2);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("The maxWidth must be greater than the width");
        }
        if (chronoLocalDate == null) {
            if (!temporalField.range().isValidValue(n3)) {
                throw new IllegalArgumentException("The base value must be within the range of the field");
            }
            if ((long)n3 + (long)EXCEED_POINTS[n] > Integer.MAX_VALUE) {
                throw new DateTimeException("Unable to add printer-parser as the range exceeds the capacity of an int");
            }
        }
        this.baseValue = n3;
        this.baseDate = chronoLocalDate;
    }

    private DateTimeFormatterBuilder$ReducedPrinterParser(TemporalField temporalField, int n, int n2, int n3, ChronoLocalDate chronoLocalDate, int n4) {
        super(temporalField, n, n2, SignStyle.NOT_NEGATIVE, n4, null);
        this.baseValue = n3;
        this.baseDate = chronoLocalDate;
    }

    long getValue(DateTimePrintContext dateTimePrintContext, long l) {
        long l2 = Math.abs(l);
        int n = this.baseValue;
        if (this.baseDate != null) {
            Chronology chronology = Chronology.from(dateTimePrintContext.getTemporal());
            n = chronology.date(this.baseDate).get(this.field);
        }
        if (l >= (long)n && l < (long)(n + EXCEED_POINTS[this.minWidth])) {
            return l2 % (long)EXCEED_POINTS[this.minWidth];
        }
        return l2 % (long)EXCEED_POINTS[this.maxWidth];
    }

    int setValue(DateTimeParseContext dateTimeParseContext, long l, int n, int n2) {
        int n3;
        int n4 = this.baseValue;
        if (this.baseDate != null) {
            Chronology chronology = dateTimeParseContext.getEffectiveChronology();
            n4 = chronology.date(this.baseDate).get(this.field);
            dateTimeParseContext.addChronologyChangedParser(this, l, n, n2);
        }
        if ((n3 = n2 - n) == this.minWidth && l >= 0L) {
            long l2 = EXCEED_POINTS[this.minWidth];
            long l3 = (long)n4 % l2;
            long l4 = (long)n4 - l3;
            l = n4 > 0 ? l4 + l : l4 - l;
            if (l < (long)n4) {
                l += l2;
            }
        }
        return dateTimeParseContext.setParsedField(this.field, l, n, n2);
    }

    DateTimeFormatterBuilder$NumberPrinterParser withFixedWidth() {
        if (this.subsequentWidth == -1) {
            return this;
        }
        return new DateTimeFormatterBuilder$ReducedPrinterParser(this.field, this.minWidth, this.maxWidth, this.baseValue, this.baseDate, -1);
    }

    DateTimeFormatterBuilder$ReducedPrinterParser withSubsequentWidth(int n) {
        return new DateTimeFormatterBuilder$ReducedPrinterParser(this.field, this.minWidth, this.maxWidth, this.baseValue, this.baseDate, this.subsequentWidth + n);
    }

    boolean isFixedWidth(DateTimeParseContext dateTimeParseContext) {
        if (!dateTimeParseContext.isStrict()) {
            return false;
        }
        return super.isFixedWidth(dateTimeParseContext);
    }

    public String toString() {
        return "ReducedValue(" + this.field + "," + this.minWidth + "," + this.maxWidth + "," + (this.baseDate != null ? this.baseDate : Integer.valueOf(this.baseValue)) + ")";
    }
}

