/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.util.Iterator;
import java.util.Map;
import oz.threeten.bp.format.DateTimeFormatterBuilder$DateTimePrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$NumberPrinterParser;
import oz.threeten.bp.format.DateTimeParseContext;
import oz.threeten.bp.format.DateTimePrintContext;
import oz.threeten.bp.format.DateTimeTextProvider;
import oz.threeten.bp.format.SignStyle;
import oz.threeten.bp.format.TextStyle;
import oz.threeten.bp.temporal.TemporalField;

final class DateTimeFormatterBuilder$TextPrinterParser
implements DateTimeFormatterBuilder$DateTimePrinterParser {
    private final TemporalField field;
    private final TextStyle textStyle;
    private final DateTimeTextProvider provider;
    private volatile DateTimeFormatterBuilder$NumberPrinterParser numberPrinterParser;

    DateTimeFormatterBuilder$TextPrinterParser(TemporalField temporalField, TextStyle textStyle, DateTimeTextProvider dateTimeTextProvider) {
        this.field = temporalField;
        this.textStyle = textStyle;
        this.provider = dateTimeTextProvider;
    }

    public boolean print(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
        Long l = dateTimePrintContext.getValue(this.field);
        if (l == null) {
            return false;
        }
        String string = this.provider.getText(this.field, l, this.textStyle, dateTimePrintContext.getLocale());
        if (string == null) {
            return this.numberPrinterParser().print(dateTimePrintContext, stringBuilder);
        }
        stringBuilder.append(string);
        return true;
    }

    public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        TextStyle textStyle = dateTimeParseContext.isStrict() ? this.textStyle : null;
        Iterator iterator = this.provider.getTextIterator(this.field, textStyle, dateTimeParseContext.getLocale());
        if (iterator != null) {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string = (String)entry.getKey();
                if (!dateTimeParseContext.subSequenceEquals(string, 0, charSequence, n, string.length())) continue;
                return dateTimeParseContext.setParsedField(this.field, (Long)entry.getValue(), n, n + string.length());
            }
            if (dateTimeParseContext.isStrict()) {
                return ~n;
            }
        }
        return this.numberPrinterParser().parse(dateTimeParseContext, charSequence, n);
    }

    private DateTimeFormatterBuilder$NumberPrinterParser numberPrinterParser() {
        if (this.numberPrinterParser == null) {
            this.numberPrinterParser = new DateTimeFormatterBuilder$NumberPrinterParser(this.field, 1, 19, SignStyle.NORMAL);
        }
        return this.numberPrinterParser;
    }

    public String toString() {
        if (this.textStyle == TextStyle.FULL) {
            return "Text(" + this.field + ")";
        }
        return "Text(" + this.field + "," + (Object)((Object)this.textStyle) + ")";
    }
}

