/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.format.DateTimeFormatterBuilder$1;
import oz.threeten.bp.format.DateTimeFormatterBuilder$2;
import oz.threeten.bp.format.DateTimeFormatterBuilder$3;
import oz.threeten.bp.format.DateTimeFormatterBuilder$CharLiteralPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$ChronoPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$CompositePrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$DateTimePrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$DefaultingParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$FractionPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$InstantPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$LocalizedOffsetPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$LocalizedPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$NumberPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$OffsetIdPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$PadPrinterParserDecorator;
import oz.threeten.bp.format.DateTimeFormatterBuilder$ReducedPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$SettingsParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$StringLiteralPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$TextPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$WeekFieldsPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$ZoneIdPrinterParser;
import oz.threeten.bp.format.DateTimeFormatterBuilder$ZoneTextPrinterParser;
import oz.threeten.bp.format.DateTimeTextProvider;
import oz.threeten.bp.format.DecimalStyle;
import oz.threeten.bp.format.FormatStyle;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.format.SignStyle;
import oz.threeten.bp.format.SimpleDateTimeTextProvider$LocaleStore;
import oz.threeten.bp.format.TextStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.IsoFields;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;

public final class DateTimeFormatterBuilder {
    private static final TemporalQuery QUERY_REGION_ONLY = new DateTimeFormatterBuilder$1();
    private DateTimeFormatterBuilder active = this;
    private final DateTimeFormatterBuilder parent;
    private final List printerParsers = new ArrayList();
    private final boolean optional;
    private int padNextWidth;
    private char padNextChar;
    private int valueParserIndex = -1;
    private static final Map FIELD_MAP = new HashMap();
    static final Comparator LENGTH_SORT;

    public static String getLocalizedDateTimePattern(FormatStyle formatStyle, FormatStyle formatStyle2, Chronology chronology, Locale locale) {
        Jdk8Methods.requireNonNull(locale, "locale");
        Jdk8Methods.requireNonNull(chronology, "chrono");
        if (formatStyle == null && formatStyle2 == null) {
            throw new IllegalArgumentException("Either dateStyle or timeStyle must be non-null");
        }
        DateFormat dateFormat = formatStyle != null ? (formatStyle2 != null ? DateFormat.getDateTimeInstance(formatStyle.ordinal(), formatStyle2.ordinal(), locale) : DateFormat.getDateInstance(formatStyle.ordinal(), locale)) : DateFormat.getTimeInstance(formatStyle2.ordinal(), locale);
        if (dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)dateFormat).toPattern();
        }
        throw new IllegalArgumentException("Unable to determine pattern");
    }

    public DateTimeFormatterBuilder() {
        this.parent = null;
        this.optional = false;
    }

    private DateTimeFormatterBuilder(DateTimeFormatterBuilder dateTimeFormatterBuilder, boolean bl) {
        this.parent = dateTimeFormatterBuilder;
        this.optional = bl;
    }

    public DateTimeFormatterBuilder parseCaseSensitive() {
        this.appendInternal(DateTimeFormatterBuilder$SettingsParser.SENSITIVE);
        return this;
    }

    public DateTimeFormatterBuilder parseCaseInsensitive() {
        this.appendInternal(DateTimeFormatterBuilder$SettingsParser.INSENSITIVE);
        return this;
    }

    public DateTimeFormatterBuilder parseStrict() {
        this.appendInternal(DateTimeFormatterBuilder$SettingsParser.STRICT);
        return this;
    }

    public DateTimeFormatterBuilder parseLenient() {
        this.appendInternal(DateTimeFormatterBuilder$SettingsParser.LENIENT);
        return this;
    }

    public DateTimeFormatterBuilder parseDefaulting(TemporalField temporalField, long l) {
        Jdk8Methods.requireNonNull(temporalField, "field");
        this.appendInternal(new DateTimeFormatterBuilder$DefaultingParser(temporalField, l));
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField temporalField) {
        Jdk8Methods.requireNonNull(temporalField, "field");
        this.appendValue(new DateTimeFormatterBuilder$NumberPrinterParser(temporalField, 1, 19, SignStyle.NORMAL));
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField temporalField, int n) {
        Jdk8Methods.requireNonNull(temporalField, "field");
        if (n < 1 || n > 19) {
            throw new IllegalArgumentException("The width must be from 1 to 19 inclusive but was " + n);
        }
        DateTimeFormatterBuilder$NumberPrinterParser dateTimeFormatterBuilder$NumberPrinterParser = new DateTimeFormatterBuilder$NumberPrinterParser(temporalField, n, n, SignStyle.NOT_NEGATIVE);
        this.appendValue(dateTimeFormatterBuilder$NumberPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField temporalField, int n, int n2, SignStyle signStyle) {
        if (n == n2 && signStyle == SignStyle.NOT_NEGATIVE) {
            return this.appendValue(temporalField, n2);
        }
        Jdk8Methods.requireNonNull(temporalField, "field");
        Jdk8Methods.requireNonNull((Object)signStyle, "signStyle");
        if (n < 1 || n > 19) {
            throw new IllegalArgumentException("The minimum width must be from 1 to 19 inclusive but was " + n);
        }
        if (n2 < 1 || n2 > 19) {
            throw new IllegalArgumentException("The maximum width must be from 1 to 19 inclusive but was " + n2);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("The maximum width must exceed or equal the minimum width but " + n2 + " < " + n);
        }
        DateTimeFormatterBuilder$NumberPrinterParser dateTimeFormatterBuilder$NumberPrinterParser = new DateTimeFormatterBuilder$NumberPrinterParser(temporalField, n, n2, signStyle);
        this.appendValue(dateTimeFormatterBuilder$NumberPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendValueReduced(TemporalField temporalField, int n, int n2, int n3) {
        Jdk8Methods.requireNonNull(temporalField, "field");
        DateTimeFormatterBuilder$ReducedPrinterParser dateTimeFormatterBuilder$ReducedPrinterParser = new DateTimeFormatterBuilder$ReducedPrinterParser(temporalField, n, n2, n3, null);
        this.appendValue(dateTimeFormatterBuilder$ReducedPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendValueReduced(TemporalField temporalField, int n, int n2, ChronoLocalDate chronoLocalDate) {
        Jdk8Methods.requireNonNull(temporalField, "field");
        Jdk8Methods.requireNonNull(chronoLocalDate, "baseDate");
        DateTimeFormatterBuilder$ReducedPrinterParser dateTimeFormatterBuilder$ReducedPrinterParser = new DateTimeFormatterBuilder$ReducedPrinterParser(temporalField, n, n2, 0, chronoLocalDate);
        this.appendValue(dateTimeFormatterBuilder$ReducedPrinterParser);
        return this;
    }

    private DateTimeFormatterBuilder appendValue(DateTimeFormatterBuilder$NumberPrinterParser dateTimeFormatterBuilder$NumberPrinterParser) {
        if (this.active.valueParserIndex >= 0 && this.active.printerParsers.get(this.active.valueParserIndex) instanceof DateTimeFormatterBuilder$NumberPrinterParser) {
            int n = this.active.valueParserIndex;
            DateTimeFormatterBuilder$NumberPrinterParser dateTimeFormatterBuilder$NumberPrinterParser2 = (DateTimeFormatterBuilder$NumberPrinterParser)this.active.printerParsers.get(n);
            if (dateTimeFormatterBuilder$NumberPrinterParser.minWidth == dateTimeFormatterBuilder$NumberPrinterParser.maxWidth && dateTimeFormatterBuilder$NumberPrinterParser.signStyle == SignStyle.NOT_NEGATIVE) {
                dateTimeFormatterBuilder$NumberPrinterParser2 = dateTimeFormatterBuilder$NumberPrinterParser2.withSubsequentWidth(dateTimeFormatterBuilder$NumberPrinterParser.maxWidth);
                this.appendInternal(dateTimeFormatterBuilder$NumberPrinterParser.withFixedWidth());
                this.active.valueParserIndex = n;
            } else {
                dateTimeFormatterBuilder$NumberPrinterParser2 = dateTimeFormatterBuilder$NumberPrinterParser2.withFixedWidth();
                this.active.valueParserIndex = this.appendInternal(dateTimeFormatterBuilder$NumberPrinterParser);
            }
            this.active.printerParsers.set(n, dateTimeFormatterBuilder$NumberPrinterParser2);
        } else {
            this.active.valueParserIndex = this.appendInternal(dateTimeFormatterBuilder$NumberPrinterParser);
        }
        return this;
    }

    public DateTimeFormatterBuilder appendFraction(TemporalField temporalField, int n, int n2, boolean bl) {
        this.appendInternal(new DateTimeFormatterBuilder$FractionPrinterParser(temporalField, n, n2, bl));
        return this;
    }

    public DateTimeFormatterBuilder appendText(TemporalField temporalField) {
        return this.appendText(temporalField, TextStyle.FULL);
    }

    public DateTimeFormatterBuilder appendText(TemporalField temporalField, TextStyle textStyle) {
        Jdk8Methods.requireNonNull(temporalField, "field");
        Jdk8Methods.requireNonNull((Object)textStyle, "textStyle");
        this.appendInternal(new DateTimeFormatterBuilder$TextPrinterParser(temporalField, textStyle, DateTimeTextProvider.getInstance()));
        return this;
    }

    public DateTimeFormatterBuilder appendText(TemporalField temporalField, Map map) {
        Jdk8Methods.requireNonNull(temporalField, "field");
        Jdk8Methods.requireNonNull(map, "textLookup");
        LinkedHashMap linkedHashMap = new LinkedHashMap(map);
        Map map2 = Collections.singletonMap(TextStyle.FULL, linkedHashMap);
        SimpleDateTimeTextProvider$LocaleStore simpleDateTimeTextProvider$LocaleStore = new SimpleDateTimeTextProvider$LocaleStore(map2);
        DateTimeFormatterBuilder$2 dateTimeFormatterBuilder$2 = new DateTimeFormatterBuilder$2(this, simpleDateTimeTextProvider$LocaleStore);
        this.appendInternal(new DateTimeFormatterBuilder$TextPrinterParser(temporalField, TextStyle.FULL, dateTimeFormatterBuilder$2));
        return this;
    }

    public DateTimeFormatterBuilder appendInstant() {
        this.appendInternal(new DateTimeFormatterBuilder$InstantPrinterParser(-2));
        return this;
    }

    public DateTimeFormatterBuilder appendInstant(int n) {
        if (n < -1 || n > 9) {
            throw new IllegalArgumentException("Invalid fractional digits: " + n);
        }
        this.appendInternal(new DateTimeFormatterBuilder$InstantPrinterParser(n));
        return this;
    }

    public DateTimeFormatterBuilder appendOffsetId() {
        this.appendInternal(DateTimeFormatterBuilder$OffsetIdPrinterParser.INSTANCE_ID);
        return this;
    }

    public DateTimeFormatterBuilder appendOffset(String string, String string2) {
        this.appendInternal(new DateTimeFormatterBuilder$OffsetIdPrinterParser(string2, string));
        return this;
    }

    public DateTimeFormatterBuilder appendLocalizedOffset(TextStyle textStyle) {
        Jdk8Methods.requireNonNull((Object)textStyle, "style");
        if (textStyle != TextStyle.FULL && textStyle != TextStyle.SHORT) {
            throw new IllegalArgumentException("Style must be either full or short");
        }
        this.appendInternal(new DateTimeFormatterBuilder$LocalizedOffsetPrinterParser(textStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneId() {
        this.appendInternal(new DateTimeFormatterBuilder$ZoneIdPrinterParser(TemporalQueries.zoneId(), "ZoneId()"));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneRegionId() {
        this.appendInternal(new DateTimeFormatterBuilder$ZoneIdPrinterParser(QUERY_REGION_ONLY, "ZoneRegionId()"));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneOrOffsetId() {
        this.appendInternal(new DateTimeFormatterBuilder$ZoneIdPrinterParser(TemporalQueries.zone(), "ZoneOrOffsetId()"));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneText(TextStyle textStyle) {
        this.appendInternal(new DateTimeFormatterBuilder$ZoneTextPrinterParser(textStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendZoneText(TextStyle textStyle, Set set) {
        Jdk8Methods.requireNonNull(set, "preferredZones");
        this.appendInternal(new DateTimeFormatterBuilder$ZoneTextPrinterParser(textStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendChronologyId() {
        this.appendInternal(new DateTimeFormatterBuilder$ChronoPrinterParser(null));
        return this;
    }

    public DateTimeFormatterBuilder appendChronologyText(TextStyle textStyle) {
        Jdk8Methods.requireNonNull((Object)textStyle, "textStyle");
        this.appendInternal(new DateTimeFormatterBuilder$ChronoPrinterParser(textStyle));
        return this;
    }

    public DateTimeFormatterBuilder appendLocalized(FormatStyle formatStyle, FormatStyle formatStyle2) {
        if (formatStyle == null && formatStyle2 == null) {
            throw new IllegalArgumentException("Either the date or time style must be non-null");
        }
        this.appendInternal(new DateTimeFormatterBuilder$LocalizedPrinterParser(formatStyle, formatStyle2));
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(char c2) {
        this.appendInternal(new DateTimeFormatterBuilder$CharLiteralPrinterParser(c2));
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(String string) {
        Jdk8Methods.requireNonNull(string, "literal");
        if (string.length() > 0) {
            if (string.length() == 1) {
                this.appendInternal(new DateTimeFormatterBuilder$CharLiteralPrinterParser(string.charAt(0)));
            } else {
                this.appendInternal(new DateTimeFormatterBuilder$StringLiteralPrinterParser(string));
            }
        }
        return this;
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        this.appendInternal(dateTimeFormatter.toPrinterParser(false));
        return this;
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeFormatter dateTimeFormatter) {
        Jdk8Methods.requireNonNull(dateTimeFormatter, "formatter");
        this.appendInternal(dateTimeFormatter.toPrinterParser(true));
        return this;
    }

    public DateTimeFormatterBuilder appendPattern(String string) {
        Jdk8Methods.requireNonNull(string, "pattern");
        this.parsePattern(string);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePattern(String string) {
        for (int j = 0; j < string.length(); ++j) {
            int n;
            char c2 = string.charAt(j);
            if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
                TemporalField temporalField;
                n = j++;
                while (j < string.length() && string.charAt(j) == c2) {
                    ++j;
                }
                int n2 = j - n;
                if (c2 == 'p') {
                    int n3 = 0;
                    if (j < string.length() && ((c2 = string.charAt(j)) >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z')) {
                        n3 = n2;
                        n = j++;
                        while (j < string.length() && string.charAt(j) == c2) {
                            ++j;
                        }
                        n2 = j - n;
                    }
                    if (n3 == 0) {
                        throw new IllegalArgumentException("Pad letter 'p' must be followed by valid pad pattern: " + string);
                    }
                    this.padNext(n3);
                }
                if ((temporalField = (TemporalField)FIELD_MAP.get(Character.valueOf(c2))) != null) {
                    this.parseField(c2, n2, temporalField);
                } else if (c2 == 'z') {
                    if (n2 > 4) {
                        throw new IllegalArgumentException("Too many pattern letters: " + c2);
                    }
                    if (n2 == 4) {
                        this.appendZoneText(TextStyle.FULL);
                    } else {
                        this.appendZoneText(TextStyle.SHORT);
                    }
                } else if (c2 == 'V') {
                    if (n2 != 2) {
                        throw new IllegalArgumentException("Pattern letter count must be 2: " + c2);
                    }
                    this.appendZoneId();
                } else if (c2 == 'Z') {
                    if (n2 < 4) {
                        this.appendOffset("+HHMM", "+0000");
                    } else if (n2 == 4) {
                        this.appendLocalizedOffset(TextStyle.FULL);
                    } else {
                        if (n2 != 5) throw new IllegalArgumentException("Too many pattern letters: " + c2);
                        this.appendOffset("+HH:MM:ss", "Z");
                    }
                } else if (c2 == 'O') {
                    if (n2 == 1) {
                        this.appendLocalizedOffset(TextStyle.SHORT);
                    } else {
                        if (n2 != 4) throw new IllegalArgumentException("Pattern letter count must be 1 or 4: " + c2);
                        this.appendLocalizedOffset(TextStyle.FULL);
                    }
                } else if (c2 == 'X') {
                    if (n2 > 5) {
                        throw new IllegalArgumentException("Too many pattern letters: " + c2);
                    }
                    this.appendOffset(DateTimeFormatterBuilder$OffsetIdPrinterParser.PATTERNS[n2 + (n2 == 1 ? 0 : 1)], "Z");
                } else if (c2 == 'x') {
                    if (n2 > 5) {
                        throw new IllegalArgumentException("Too many pattern letters: " + c2);
                    }
                    String string2 = n2 == 1 ? "+00" : (n2 % 2 == 0 ? "+0000" : "+00:00");
                    this.appendOffset(DateTimeFormatterBuilder$OffsetIdPrinterParser.PATTERNS[n2 + (n2 == 1 ? 0 : 1)], string2);
                } else if (c2 == 'W') {
                    if (n2 > 1) {
                        throw new IllegalArgumentException("Too many pattern letters: " + c2);
                    }
                    this.appendInternal(new DateTimeFormatterBuilder$WeekFieldsPrinterParser('W', n2));
                } else if (c2 == 'w') {
                    if (n2 > 2) {
                        throw new IllegalArgumentException("Too many pattern letters: " + c2);
                    }
                    this.appendInternal(new DateTimeFormatterBuilder$WeekFieldsPrinterParser('w', n2));
                } else {
                    if (c2 != 'Y') throw new IllegalArgumentException("Unknown pattern letter: " + c2);
                    this.appendInternal(new DateTimeFormatterBuilder$WeekFieldsPrinterParser('Y', n2));
                }
                --j;
                continue;
            }
            if (c2 == '\'') {
                n = j++;
                while (j < string.length()) {
                    if (string.charAt(j) == '\'') {
                        if (j + 1 >= string.length() || string.charAt(j + 1) != '\'') break;
                        ++j;
                    }
                    ++j;
                }
                if (j >= string.length()) {
                    throw new IllegalArgumentException("Pattern ends with an incomplete string literal: " + string);
                }
                String string3 = string.substring(n + 1, j);
                if (string3.length() == 0) {
                    this.appendLiteral('\'');
                    continue;
                }
                this.appendLiteral(string3.replace("''", "'"));
                continue;
            }
            if (c2 == '[') {
                this.optionalStart();
                continue;
            }
            if (c2 == ']') {
                if (this.active.parent == null) {
                    throw new IllegalArgumentException("Pattern invalid as it contains ] without previous [");
                }
                this.optionalEnd();
                continue;
            }
            if (c2 == '{' || c2 == '}' || c2 == '#') {
                throw new IllegalArgumentException("Pattern includes reserved character: '" + c2 + "'");
            }
            this.appendLiteral(c2);
        }
    }

    private void parseField(char c2, int n, TemporalField temporalField) {
        block0 : switch (c2) {
            case 'u': 
            case 'y': {
                if (n == 2) {
                    this.appendValueReduced(temporalField, 2, 2, DateTimeFormatterBuilder$ReducedPrinterParser.BASE_DATE);
                    break;
                }
                if (n < 4) {
                    this.appendValue(temporalField, n, 19, SignStyle.NORMAL);
                    break;
                }
                this.appendValue(temporalField, n, 19, SignStyle.EXCEEDS_PAD);
                break;
            }
            case 'M': 
            case 'Q': {
                switch (n) {
                    case 1: {
                        this.appendValue(temporalField);
                        break block0;
                    }
                    case 2: {
                        this.appendValue(temporalField, 2);
                        break block0;
                    }
                    case 3: {
                        this.appendText(temporalField, TextStyle.SHORT);
                        break block0;
                    }
                    case 4: {
                        this.appendText(temporalField, TextStyle.FULL);
                        break block0;
                    }
                    case 5: {
                        this.appendText(temporalField, TextStyle.NARROW);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c2);
            }
            case 'L': 
            case 'q': {
                switch (n) {
                    case 1: {
                        this.appendValue(temporalField);
                        break block0;
                    }
                    case 2: {
                        this.appendValue(temporalField, 2);
                        break block0;
                    }
                    case 3: {
                        this.appendText(temporalField, TextStyle.SHORT_STANDALONE);
                        break block0;
                    }
                    case 4: {
                        this.appendText(temporalField, TextStyle.FULL_STANDALONE);
                        break block0;
                    }
                    case 5: {
                        this.appendText(temporalField, TextStyle.NARROW_STANDALONE);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c2);
            }
            case 'e': {
                switch (n) {
                    case 1: 
                    case 2: {
                        this.appendInternal(new DateTimeFormatterBuilder$WeekFieldsPrinterParser('e', n));
                        break block0;
                    }
                    case 3: {
                        this.appendText(temporalField, TextStyle.SHORT);
                        break block0;
                    }
                    case 4: {
                        this.appendText(temporalField, TextStyle.FULL);
                        break block0;
                    }
                    case 5: {
                        this.appendText(temporalField, TextStyle.NARROW);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c2);
            }
            case 'c': {
                switch (n) {
                    case 1: {
                        this.appendInternal(new DateTimeFormatterBuilder$WeekFieldsPrinterParser('c', n));
                        break block0;
                    }
                    case 2: {
                        throw new IllegalArgumentException("Invalid number of pattern letters: " + c2);
                    }
                    case 3: {
                        this.appendText(temporalField, TextStyle.SHORT_STANDALONE);
                        break block0;
                    }
                    case 4: {
                        this.appendText(temporalField, TextStyle.FULL_STANDALONE);
                        break block0;
                    }
                    case 5: {
                        this.appendText(temporalField, TextStyle.NARROW_STANDALONE);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c2);
            }
            case 'a': {
                if (n == 1) {
                    this.appendText(temporalField, TextStyle.SHORT);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c2);
            }
            case 'E': 
            case 'G': {
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.appendText(temporalField, TextStyle.SHORT);
                        break block0;
                    }
                    case 4: {
                        this.appendText(temporalField, TextStyle.FULL);
                        break block0;
                    }
                    case 5: {
                        this.appendText(temporalField, TextStyle.NARROW);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c2);
            }
            case 'S': {
                this.appendFraction(ChronoField.NANO_OF_SECOND, n, n, false);
                break;
            }
            case 'F': {
                if (n == 1) {
                    this.appendValue(temporalField);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c2);
            }
            case 'H': 
            case 'K': 
            case 'd': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': {
                if (n == 1) {
                    this.appendValue(temporalField);
                    break;
                }
                if (n == 2) {
                    this.appendValue(temporalField, n);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c2);
            }
            case 'D': {
                if (n == 1) {
                    this.appendValue(temporalField);
                    break;
                }
                if (n <= 3) {
                    this.appendValue(temporalField, n);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + c2);
            }
            default: {
                if (n == 1) {
                    this.appendValue(temporalField);
                    break;
                }
                this.appendValue(temporalField, n);
            }
        }
    }

    public DateTimeFormatterBuilder padNext(int n) {
        return this.padNext(n, ' ');
    }

    public DateTimeFormatterBuilder padNext(int n, char c2) {
        if (n < 1) {
            throw new IllegalArgumentException("The pad width must be at least one but was " + n);
        }
        this.active.padNextWidth = n;
        this.active.padNextChar = c2;
        this.active.valueParserIndex = -1;
        return this;
    }

    public DateTimeFormatterBuilder optionalStart() {
        this.active.valueParserIndex = -1;
        this.active = new DateTimeFormatterBuilder(this.active, true);
        return this;
    }

    public DateTimeFormatterBuilder optionalEnd() {
        if (this.active.parent == null) {
            throw new IllegalStateException("Cannot call optionalEnd() as there was no previous call to optionalStart()");
        }
        if (this.active.printerParsers.size() > 0) {
            DateTimeFormatterBuilder$CompositePrinterParser dateTimeFormatterBuilder$CompositePrinterParser = new DateTimeFormatterBuilder$CompositePrinterParser(this.active.printerParsers, this.active.optional);
            this.active = this.active.parent;
            this.appendInternal(dateTimeFormatterBuilder$CompositePrinterParser);
        } else {
            this.active = this.active.parent;
        }
        return this;
    }

    private int appendInternal(DateTimeFormatterBuilder$DateTimePrinterParser dateTimeFormatterBuilder$DateTimePrinterParser) {
        Jdk8Methods.requireNonNull(dateTimeFormatterBuilder$DateTimePrinterParser, "pp");
        if (this.active.padNextWidth > 0) {
            if (dateTimeFormatterBuilder$DateTimePrinterParser != null) {
                dateTimeFormatterBuilder$DateTimePrinterParser = new DateTimeFormatterBuilder$PadPrinterParserDecorator(dateTimeFormatterBuilder$DateTimePrinterParser, this.active.padNextWidth, this.active.padNextChar);
            }
            this.active.padNextWidth = 0;
            this.active.padNextChar = '\u0000';
        }
        this.active.printerParsers.add(dateTimeFormatterBuilder$DateTimePrinterParser);
        this.active.valueParserIndex = -1;
        return this.active.printerParsers.size() - 1;
    }

    public DateTimeFormatter toFormatter() {
        return this.toFormatter(Locale.getDefault());
    }

    public DateTimeFormatter toFormatter(Locale locale) {
        Jdk8Methods.requireNonNull(locale, "locale");
        while (this.active.parent != null) {
            this.optionalEnd();
        }
        DateTimeFormatterBuilder$CompositePrinterParser dateTimeFormatterBuilder$CompositePrinterParser = new DateTimeFormatterBuilder$CompositePrinterParser(this.printerParsers, false);
        return new DateTimeFormatter(dateTimeFormatterBuilder$CompositePrinterParser, locale, DecimalStyle.STANDARD, ResolverStyle.SMART, null, null, null);
    }

    DateTimeFormatter toFormatter(ResolverStyle resolverStyle) {
        return this.toFormatter().withResolverStyle(resolverStyle);
    }

    static {
        FIELD_MAP.put(Character.valueOf('G'), ChronoField.ERA);
        FIELD_MAP.put(Character.valueOf('y'), ChronoField.YEAR_OF_ERA);
        FIELD_MAP.put(Character.valueOf('u'), ChronoField.YEAR);
        FIELD_MAP.put(Character.valueOf('Q'), IsoFields.QUARTER_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('q'), IsoFields.QUARTER_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('M'), ChronoField.MONTH_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('L'), ChronoField.MONTH_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('D'), ChronoField.DAY_OF_YEAR);
        FIELD_MAP.put(Character.valueOf('d'), ChronoField.DAY_OF_MONTH);
        FIELD_MAP.put(Character.valueOf('F'), ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
        FIELD_MAP.put(Character.valueOf('E'), ChronoField.DAY_OF_WEEK);
        FIELD_MAP.put(Character.valueOf('c'), ChronoField.DAY_OF_WEEK);
        FIELD_MAP.put(Character.valueOf('e'), ChronoField.DAY_OF_WEEK);
        FIELD_MAP.put(Character.valueOf('a'), ChronoField.AMPM_OF_DAY);
        FIELD_MAP.put(Character.valueOf('H'), ChronoField.HOUR_OF_DAY);
        FIELD_MAP.put(Character.valueOf('k'), ChronoField.CLOCK_HOUR_OF_DAY);
        FIELD_MAP.put(Character.valueOf('K'), ChronoField.HOUR_OF_AMPM);
        FIELD_MAP.put(Character.valueOf('h'), ChronoField.CLOCK_HOUR_OF_AMPM);
        FIELD_MAP.put(Character.valueOf('m'), ChronoField.MINUTE_OF_HOUR);
        FIELD_MAP.put(Character.valueOf('s'), ChronoField.SECOND_OF_MINUTE);
        FIELD_MAP.put(Character.valueOf('S'), ChronoField.NANO_OF_SECOND);
        FIELD_MAP.put(Character.valueOf('A'), ChronoField.MILLI_OF_DAY);
        FIELD_MAP.put(Character.valueOf('n'), ChronoField.NANO_OF_SECOND);
        FIELD_MAP.put(Character.valueOf('N'), ChronoField.NANO_OF_DAY);
        LENGTH_SORT = new DateTimeFormatterBuilder$3();
    }
}

