/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.util.Locale;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.Instant;
import oz.threeten.bp.ZoneId;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.format.DateTimePrintContext$1;
import oz.threeten.bp.format.DecimalStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalQueries;
import oz.threeten.bp.temporal.TemporalQuery;

final class DateTimePrintContext {
    private TemporalAccessor temporal;
    private Locale locale;
    private DecimalStyle symbols;
    private int optional;

    DateTimePrintContext(TemporalAccessor temporalAccessor, DateTimeFormatter dateTimeFormatter) {
        this.temporal = DateTimePrintContext.adjust(temporalAccessor, dateTimeFormatter);
        this.locale = dateTimeFormatter.getLocale();
        this.symbols = dateTimeFormatter.getDecimalStyle();
    }

    DateTimePrintContext(TemporalAccessor temporalAccessor, Locale locale, DecimalStyle decimalStyle) {
        this.temporal = temporalAccessor;
        this.locale = locale;
        this.symbols = decimalStyle;
    }

    private static TemporalAccessor adjust(TemporalAccessor temporalAccessor, DateTimeFormatter dateTimeFormatter) {
        Object object;
        ZoneId zoneId;
        Chronology chronology = dateTimeFormatter.getChronology();
        ZoneId zoneId2 = dateTimeFormatter.getZone();
        if (chronology == null && zoneId2 == null) {
            return temporalAccessor;
        }
        Chronology chronology2 = (Chronology)temporalAccessor.query(TemporalQueries.chronology());
        ZoneId zoneId3 = (ZoneId)temporalAccessor.query(TemporalQueries.zoneId());
        if (Jdk8Methods.equals(chronology2, chronology)) {
            chronology = null;
        }
        if (Jdk8Methods.equals(zoneId3, zoneId2)) {
            zoneId2 = null;
        }
        if (chronology == null && zoneId2 == null) {
            return temporalAccessor;
        }
        Chronology chronology3 = chronology != null ? chronology : chronology2;
        ZoneId zoneId4 = zoneId = zoneId2 != null ? zoneId2 : zoneId3;
        if (zoneId2 != null) {
            if (temporalAccessor.isSupported(ChronoField.INSTANT_SECONDS)) {
                Chronology chronology4 = chronology3 != null ? chronology3 : IsoChronology.INSTANCE;
                return chronology4.zonedDateTime(Instant.from(temporalAccessor), zoneId2);
            }
            object = zoneId2.normalized();
            ZoneOffset object2 = (ZoneOffset)temporalAccessor.query(TemporalQueries.offset());
            if (object instanceof ZoneOffset && object2 != null && !((ZoneId)object).equals(object2)) {
                throw new DateTimeException("Invalid override zone for temporal: " + zoneId2 + " " + temporalAccessor);
            }
        }
        if (chronology != null) {
            if (temporalAccessor.isSupported(ChronoField.EPOCH_DAY)) {
                object = chronology3.date(temporalAccessor);
            } else {
                if (chronology != IsoChronology.INSTANCE || chronology2 != null) {
                    for (ChronoField chronoField : ChronoField.values()) {
                        if (!chronoField.isDateBased() || !temporalAccessor.isSupported(chronoField)) continue;
                        throw new DateTimeException("Invalid override chronology for temporal: " + chronology + " " + temporalAccessor);
                    }
                }
                object = null;
            }
        } else {
            object = null;
        }
        return new DateTimePrintContext$1((ChronoLocalDate)object, temporalAccessor, chronology3, zoneId);
    }

    TemporalAccessor getTemporal() {
        return this.temporal;
    }

    Locale getLocale() {
        return this.locale;
    }

    DecimalStyle getSymbols() {
        return this.symbols;
    }

    void startOptional() {
        ++this.optional;
    }

    void endOptional() {
        --this.optional;
    }

    Object getValue(TemporalQuery temporalQuery) {
        Object object = this.temporal.query(temporalQuery);
        if (object == null && this.optional == 0) {
            throw new DateTimeException("Unable to extract value: " + this.temporal.getClass());
        }
        return object;
    }

    Long getValue(TemporalField temporalField) {
        try {
            return this.temporal.getLong(temporalField);
        }
        catch (DateTimeException dateTimeException) {
            if (this.optional > 0) {
                return null;
            }
            throw dateTimeException;
        }
    }

    public String toString() {
        return this.temporal.toString();
    }

    void setDateTime(TemporalAccessor temporalAccessor) {
        Jdk8Methods.requireNonNull(temporalAccessor, "temporal");
        this.temporal = temporalAccessor;
    }

    void setLocale(Locale locale) {
        Jdk8Methods.requireNonNull(locale, "locale");
        this.locale = locale;
    }
}

