/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oz.threeten.bp.jdk8.Jdk8Methods;

public final class DecimalStyle {
    public static final DecimalStyle STANDARD = new DecimalStyle('0', '+', '-', '.');
    private static final ConcurrentMap CACHE = new ConcurrentHashMap(16, 0.75f, 2);
    private final char zeroDigit;
    private final char positiveSign;
    private final char negativeSign;
    private final char decimalSeparator;

    public static Set getAvailableLocales() {
        Locale[] localeArray = DecimalFormatSymbols.getAvailableLocales();
        return new HashSet<Locale>(Arrays.asList(localeArray));
    }

    public static DecimalStyle ofDefaultLocale() {
        return DecimalStyle.of(Locale.getDefault());
    }

    public static DecimalStyle of(Locale locale) {
        Jdk8Methods.requireNonNull(locale, "locale");
        DecimalStyle decimalStyle = (DecimalStyle)CACHE.get(locale);
        if (decimalStyle == null) {
            decimalStyle = DecimalStyle.create(locale);
            CACHE.putIfAbsent(locale, decimalStyle);
            decimalStyle = (DecimalStyle)CACHE.get(locale);
        }
        return decimalStyle;
    }

    private static DecimalStyle create(Locale locale) {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
        char c2 = decimalFormatSymbols.getZeroDigit();
        char c3 = '+';
        char c4 = decimalFormatSymbols.getMinusSign();
        char c5 = decimalFormatSymbols.getDecimalSeparator();
        if (c2 == '0' && c4 == '-' && c5 == '.') {
            return STANDARD;
        }
        return new DecimalStyle(c2, c3, c4, c5);
    }

    private DecimalStyle(char c2, char c3, char c4, char c5) {
        this.zeroDigit = c2;
        this.positiveSign = c3;
        this.negativeSign = c4;
        this.decimalSeparator = c5;
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public DecimalStyle withZeroDigit(char c2) {
        if (c2 == this.zeroDigit) {
            return this;
        }
        return new DecimalStyle(c2, this.positiveSign, this.negativeSign, this.decimalSeparator);
    }

    public char getPositiveSign() {
        return this.positiveSign;
    }

    public DecimalStyle withPositiveSign(char c2) {
        if (c2 == this.positiveSign) {
            return this;
        }
        return new DecimalStyle(this.zeroDigit, c2, this.negativeSign, this.decimalSeparator);
    }

    public char getNegativeSign() {
        return this.negativeSign;
    }

    public DecimalStyle withNegativeSign(char c2) {
        if (c2 == this.negativeSign) {
            return this;
        }
        return new DecimalStyle(this.zeroDigit, this.positiveSign, c2, this.decimalSeparator);
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public DecimalStyle withDecimalSeparator(char c2) {
        if (c2 == this.decimalSeparator) {
            return this;
        }
        return new DecimalStyle(this.zeroDigit, this.positiveSign, this.negativeSign, c2);
    }

    int convertToDigit(char c2) {
        int n = c2 - this.zeroDigit;
        return n >= 0 && n <= 9 ? n : -1;
    }

    String convertNumberToI18N(String string) {
        if (this.zeroDigit == '0') {
            return string;
        }
        int n = this.zeroDigit - 48;
        char[] cArray = string.toCharArray();
        for (int j = 0; j < cArray.length; ++j) {
            cArray[j] = (char)(cArray[j] + n);
        }
        return new String(cArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DecimalStyle) {
            DecimalStyle decimalStyle = (DecimalStyle)object;
            return this.zeroDigit == decimalStyle.zeroDigit && this.positiveSign == decimalStyle.positiveSign && this.negativeSign == decimalStyle.negativeSign && this.decimalSeparator == decimalStyle.decimalSeparator;
        }
        return false;
    }

    public int hashCode() {
        return this.zeroDigit + this.positiveSign + this.negativeSign + this.decimalSeparator;
    }

    public String toString() {
        return "DecimalStyle[" + this.zeroDigit + this.positiveSign + this.negativeSign + this.decimalSeparator + "]";
    }
}

