/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.format.DateTimeFormatStyleProvider;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.format.DateTimeFormatterBuilder;
import oz.threeten.bp.format.FormatStyle;

final class SimpleDateTimeFormatStyleProvider
extends DateTimeFormatStyleProvider {
    private static final ConcurrentMap FORMATTER_CACHE = new ConcurrentHashMap(16, 0.75f, 2);

    SimpleDateTimeFormatStyleProvider() {
    }

    public Locale[] getAvailableLocales() {
        return DateFormat.getAvailableLocales();
    }

    public DateTimeFormatter getFormatter(FormatStyle formatStyle, FormatStyle formatStyle2, Chronology chronology, Locale locale) {
        if (formatStyle == null && formatStyle2 == null) {
            throw new IllegalArgumentException("Date and Time style must not both be null");
        }
        String string = chronology.getId() + '|' + locale.toString() + '|' + (Object)((Object)formatStyle) + (Object)((Object)formatStyle2);
        Object v = FORMATTER_CACHE.get(string);
        if (v != null) {
            if (v.equals("")) {
                throw new IllegalArgumentException("Unable to convert DateFormat to DateTimeFormatter");
            }
            return (DateTimeFormatter)v;
        }
        DateFormat dateFormat = formatStyle != null ? (formatStyle2 != null ? DateFormat.getDateTimeInstance(this.convertStyle(formatStyle), this.convertStyle(formatStyle2), locale) : DateFormat.getDateInstance(this.convertStyle(formatStyle), locale)) : DateFormat.getTimeInstance(this.convertStyle(formatStyle2), locale);
        if (dateFormat instanceof SimpleDateFormat) {
            String string2 = ((SimpleDateFormat)dateFormat).toPattern();
            DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern(string2).toFormatter(locale);
            FORMATTER_CACHE.putIfAbsent(string, dateTimeFormatter);
            return dateTimeFormatter;
        }
        FORMATTER_CACHE.putIfAbsent(string, "");
        throw new IllegalArgumentException("Unable to convert DateFormat to DateTimeFormatter");
    }

    private int convertStyle(FormatStyle formatStyle) {
        return formatStyle.ordinal();
    }
}

