/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.format;

import java.text.DateFormatSymbols;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oz.threeten.bp.format.DateTimeTextProvider;
import oz.threeten.bp.format.SimpleDateTimeTextProvider$1;
import oz.threeten.bp.format.SimpleDateTimeTextProvider$LocaleStore;
import oz.threeten.bp.format.TextStyle;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.IsoFields;
import oz.threeten.bp.temporal.TemporalField;

final class SimpleDateTimeTextProvider
extends DateTimeTextProvider {
    private static final Comparator COMPARATOR = new SimpleDateTimeTextProvider$1();
    private final ConcurrentMap cache = new ConcurrentHashMap(16, 0.75f, 2);

    SimpleDateTimeTextProvider() {
    }

    public String getText(TemporalField temporalField, long l, TextStyle textStyle, Locale locale) {
        Object object = this.findStore(temporalField, locale);
        if (object instanceof SimpleDateTimeTextProvider$LocaleStore) {
            return ((SimpleDateTimeTextProvider$LocaleStore)object).getText(l, textStyle);
        }
        return null;
    }

    public Iterator getTextIterator(TemporalField temporalField, TextStyle textStyle, Locale locale) {
        Object object = this.findStore(temporalField, locale);
        if (object instanceof SimpleDateTimeTextProvider$LocaleStore) {
            return ((SimpleDateTimeTextProvider$LocaleStore)object).getTextIterator(textStyle);
        }
        return null;
    }

    private Object findStore(TemporalField temporalField, Locale locale) {
        Map.Entry entry = SimpleDateTimeTextProvider.createEntry(temporalField, locale);
        Object object = this.cache.get(entry);
        if (object == null) {
            object = this.createStore(temporalField, locale);
            this.cache.putIfAbsent(entry, object);
            object = this.cache.get(entry);
        }
        return object;
    }

    private Object createStore(TemporalField temporalField, Locale locale) {
        if (temporalField == ChronoField.MONTH_OF_YEAR) {
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
            HashMap hashMap = new HashMap();
            Long l = 1L;
            Long l2 = 2L;
            Long l3 = 3L;
            Long l4 = 4L;
            Long l5 = 5L;
            Long l6 = 6L;
            Long l7 = 7L;
            Long l8 = 8L;
            Long l9 = 9L;
            Long l10 = 10L;
            Long l11 = 11L;
            Long l12 = 12L;
            String[] stringArray = dateFormatSymbols.getMonths();
            HashMap<Long, String> hashMap2 = new HashMap<Long, String>();
            hashMap2.put(l, stringArray[0]);
            hashMap2.put(l2, stringArray[1]);
            hashMap2.put(l3, stringArray[2]);
            hashMap2.put(l4, stringArray[3]);
            hashMap2.put(l5, stringArray[4]);
            hashMap2.put(l6, stringArray[5]);
            hashMap2.put(l7, stringArray[6]);
            hashMap2.put(l8, stringArray[7]);
            hashMap2.put(l9, stringArray[8]);
            hashMap2.put(l10, stringArray[9]);
            hashMap2.put(l11, stringArray[10]);
            hashMap2.put(l12, stringArray[11]);
            hashMap.put(TextStyle.FULL, hashMap2);
            hashMap2 = new HashMap();
            hashMap2.put(l, this.narrowMonth(1, stringArray[0], locale));
            hashMap2.put(l2, this.narrowMonth(2, stringArray[1], locale));
            hashMap2.put(l3, this.narrowMonth(3, stringArray[2], locale));
            hashMap2.put(l4, this.narrowMonth(4, stringArray[3], locale));
            hashMap2.put(l5, this.narrowMonth(5, stringArray[4], locale));
            hashMap2.put(l6, this.narrowMonth(6, stringArray[5], locale));
            hashMap2.put(l7, this.narrowMonth(7, stringArray[6], locale));
            hashMap2.put(l8, this.narrowMonth(8, stringArray[7], locale));
            hashMap2.put(l9, this.narrowMonth(9, stringArray[8], locale));
            hashMap2.put(l10, this.narrowMonth(10, stringArray[9], locale));
            hashMap2.put(l11, this.narrowMonth(11, stringArray[10], locale));
            hashMap2.put(l12, this.narrowMonth(12, stringArray[11], locale));
            hashMap.put(TextStyle.NARROW, hashMap2);
            stringArray = dateFormatSymbols.getShortMonths();
            hashMap2 = new HashMap();
            hashMap2.put(l, stringArray[0]);
            hashMap2.put(l2, stringArray[1]);
            hashMap2.put(l3, stringArray[2]);
            hashMap2.put(l4, stringArray[3]);
            hashMap2.put(l5, stringArray[4]);
            hashMap2.put(l6, stringArray[5]);
            hashMap2.put(l7, stringArray[6]);
            hashMap2.put(l8, stringArray[7]);
            hashMap2.put(l9, stringArray[8]);
            hashMap2.put(l10, stringArray[9]);
            hashMap2.put(l11, stringArray[10]);
            hashMap2.put(l12, stringArray[11]);
            hashMap.put(TextStyle.SHORT, hashMap2);
            return SimpleDateTimeTextProvider.createLocaleStore(hashMap);
        }
        if (temporalField == ChronoField.DAY_OF_WEEK) {
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
            HashMap hashMap = new HashMap();
            Long l = 1L;
            Long l13 = 2L;
            Long l14 = 3L;
            Long l15 = 4L;
            Long l16 = 5L;
            Long l17 = 6L;
            Long l18 = 7L;
            String[] stringArray = dateFormatSymbols.getWeekdays();
            HashMap<Long, String> hashMap3 = new HashMap<Long, String>();
            hashMap3.put(l, stringArray[2]);
            hashMap3.put(l13, stringArray[3]);
            hashMap3.put(l14, stringArray[4]);
            hashMap3.put(l15, stringArray[5]);
            hashMap3.put(l16, stringArray[6]);
            hashMap3.put(l17, stringArray[7]);
            hashMap3.put(l18, stringArray[1]);
            hashMap.put(TextStyle.FULL, hashMap3);
            hashMap3 = new HashMap();
            hashMap3.put(l, this.narrowDayOfWeek(1, stringArray[2], locale));
            hashMap3.put(l13, this.narrowDayOfWeek(2, stringArray[3], locale));
            hashMap3.put(l14, this.narrowDayOfWeek(3, stringArray[4], locale));
            hashMap3.put(l15, this.narrowDayOfWeek(4, stringArray[5], locale));
            hashMap3.put(l16, this.narrowDayOfWeek(5, stringArray[6], locale));
            hashMap3.put(l17, this.narrowDayOfWeek(6, stringArray[7], locale));
            hashMap3.put(l18, this.narrowDayOfWeek(7, stringArray[1], locale));
            hashMap.put(TextStyle.NARROW, hashMap3);
            stringArray = dateFormatSymbols.getShortWeekdays();
            hashMap3 = new HashMap();
            hashMap3.put(l, stringArray[2]);
            hashMap3.put(l13, stringArray[3]);
            hashMap3.put(l14, stringArray[4]);
            hashMap3.put(l15, stringArray[5]);
            hashMap3.put(l16, stringArray[6]);
            hashMap3.put(l17, stringArray[7]);
            hashMap3.put(l18, stringArray[1]);
            hashMap.put(TextStyle.SHORT, hashMap3);
            return SimpleDateTimeTextProvider.createLocaleStore(hashMap);
        }
        if (temporalField == ChronoField.AMPM_OF_DAY) {
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
            HashMap hashMap = new HashMap();
            String[] stringArray = dateFormatSymbols.getAmPmStrings();
            HashMap<Long, String> hashMap4 = new HashMap<Long, String>();
            hashMap4.put(0L, stringArray[0]);
            hashMap4.put(1L, stringArray[1]);
            hashMap.put(TextStyle.FULL, hashMap4);
            hashMap.put(TextStyle.SHORT, hashMap4);
            return SimpleDateTimeTextProvider.createLocaleStore(hashMap);
        }
        if (temporalField == ChronoField.ERA) {
            DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
            HashMap hashMap = new HashMap();
            String[] stringArray = dateFormatSymbols.getEras();
            HashMap<Long, String> hashMap5 = new HashMap<Long, String>();
            hashMap5.put(0L, stringArray[0]);
            hashMap5.put(1L, stringArray[1]);
            hashMap.put(TextStyle.SHORT, hashMap5);
            if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
                hashMap5 = new HashMap();
                hashMap5.put(0L, "Before Christ");
                hashMap5.put(1L, "Anno Domini");
                hashMap.put(TextStyle.FULL, hashMap5);
            } else {
                hashMap.put(TextStyle.FULL, hashMap5);
            }
            hashMap5 = new HashMap();
            hashMap5.put(0L, stringArray[0].substring(0, 1));
            hashMap5.put(1L, stringArray[1].substring(0, 1));
            hashMap.put(TextStyle.NARROW, hashMap5);
            return SimpleDateTimeTextProvider.createLocaleStore(hashMap);
        }
        if (temporalField == IsoFields.QUARTER_OF_YEAR) {
            HashMap hashMap = new HashMap();
            HashMap<Long, String> hashMap6 = new HashMap<Long, String>();
            hashMap6.put(1L, "Q1");
            hashMap6.put(2L, "Q2");
            hashMap6.put(3L, "Q3");
            hashMap6.put(4L, "Q4");
            hashMap.put(TextStyle.SHORT, hashMap6);
            hashMap6 = new HashMap();
            hashMap6.put(1L, "1st quarter");
            hashMap6.put(2L, "2nd quarter");
            hashMap6.put(3L, "3rd quarter");
            hashMap6.put(4L, "4th quarter");
            hashMap.put(TextStyle.FULL, hashMap6);
            return SimpleDateTimeTextProvider.createLocaleStore(hashMap);
        }
        return "";
    }

    private String narrowMonth(int n, String string, Locale locale) {
        if (locale.getLanguage().equals("zh") && locale.getCountry().equals("CN")) {
            switch (n) {
                case 1: {
                    return "\u4e00";
                }
                case 2: {
                    return "\u4e8c";
                }
                case 3: {
                    return "\u4e09";
                }
                case 4: {
                    return "\u56db";
                }
                case 5: {
                    return "\u4e94";
                }
                case 6: {
                    return "\u516d";
                }
                case 7: {
                    return "\u4e03";
                }
                case 8: {
                    return "\u516b";
                }
                case 9: {
                    return "\u4e5d";
                }
                case 10: {
                    return "\u5341";
                }
                case 11: {
                    return "\u5341\u4e00";
                }
                case 12: {
                    return "\u5341\u4e8c";
                }
            }
        }
        if (locale.getLanguage().equals("ar")) {
            switch (n) {
                case 1: {
                    return "\u064a";
                }
                case 2: {
                    return "\u0641";
                }
                case 3: {
                    return "\u0645";
                }
                case 4: {
                    return "\u0623";
                }
                case 5: {
                    return "\u0648";
                }
                case 6: {
                    return "\u0646";
                }
                case 7: {
                    return "\u0644";
                }
                case 8: {
                    return "\u063a";
                }
                case 9: {
                    return "\u0633";
                }
                case 10: {
                    return "\u0643";
                }
                case 11: {
                    return "\u0628";
                }
                case 12: {
                    return "\u062f";
                }
            }
        }
        if (locale.getLanguage().equals("ja") && locale.getCountry().equals("JP")) {
            return Integer.toString(n);
        }
        return string.substring(0, 1);
    }

    private String narrowDayOfWeek(int n, String string, Locale locale) {
        if (locale.getLanguage().equals("zh") && locale.getCountry().equals("CN")) {
            switch (n) {
                case 1: {
                    return "\u4e00";
                }
                case 2: {
                    return "\u4e8c";
                }
                case 3: {
                    return "\u4e09";
                }
                case 4: {
                    return "\u56db";
                }
                case 5: {
                    return "\u4e94";
                }
                case 6: {
                    return "\u516d";
                }
                case 7: {
                    return "\u65e5";
                }
            }
        }
        if (locale.getLanguage().equals("ar")) {
            switch (n) {
                case 1: {
                    return "\u0646";
                }
                case 2: {
                    return "\u062b";
                }
                case 3: {
                    return "\u0631";
                }
                case 4: {
                    return "\u062e";
                }
                case 5: {
                    return "\u062c";
                }
                case 6: {
                    return "\u0633";
                }
                case 7: {
                    return "\u062d";
                }
            }
        }
        return string.substring(0, 1);
    }

    private static Map.Entry createEntry(Object object, Object object2) {
        return new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
    }

    private static SimpleDateTimeTextProvider$LocaleStore createLocaleStore(Map map) {
        map.put(TextStyle.FULL_STANDALONE, map.get((Object)TextStyle.FULL));
        map.put(TextStyle.SHORT_STANDALONE, map.get((Object)TextStyle.SHORT));
        if (map.containsKey((Object)TextStyle.NARROW) && !map.containsKey((Object)TextStyle.NARROW_STANDALONE)) {
            map.put(TextStyle.NARROW_STANDALONE, map.get((Object)TextStyle.NARROW));
        }
        return new SimpleDateTimeTextProvider$LocaleStore(map);
    }

    static /* synthetic */ Map.Entry access$000(Object object, Object object2) {
        return SimpleDateTimeTextProvider.createEntry(object, object2);
    }

    static /* synthetic */ Comparator access$100() {
        return COMPARATOR;
    }
}

