/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.jdk8;

public final class Jdk8Methods {
    private Jdk8Methods() {
    }

    public static Object requireNonNull(Object object) {
        if (object == null) {
            throw new NullPointerException("Value must not be null");
        }
        return object;
    }

    public static Object requireNonNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string + " must not be null");
        }
        return object;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static int compareInts(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public static int compareLongs(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return 0;
    }

    public static int safeAdd(int n, int n2) {
        int n3 = n + n2;
        if ((n ^ n3) < 0 && (n ^ n2) >= 0) {
            throw new ArithmeticException("Addition overflows an int: " + n + " + " + n2);
        }
        return n3;
    }

    public static long safeAdd(long l, long l2) {
        long l3 = l + l2;
        if ((l ^ l3) < 0L && (l ^ l2) >= 0L) {
            throw new ArithmeticException("Addition overflows a long: " + l + " + " + l2);
        }
        return l3;
    }

    public static int safeSubtract(int n, int n2) {
        int n3 = n - n2;
        if ((n ^ n3) < 0 && (n ^ n2) < 0) {
            throw new ArithmeticException("Subtraction overflows an int: " + n + " - " + n2);
        }
        return n3;
    }

    public static long safeSubtract(long l, long l2) {
        long l3 = l - l2;
        if ((l ^ l3) < 0L && (l ^ l2) < 0L) {
            throw new ArithmeticException("Subtraction overflows a long: " + l + " - " + l2);
        }
        return l3;
    }

    public static int safeMultiply(int n, int n2) {
        long l = (long)n * (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("Multiplication overflows an int: " + n + " * " + n2);
        }
        return (int)l;
    }

    public static long safeMultiply(long l, int n) {
        switch (n) {
            case -1: {
                if (l == Long.MIN_VALUE) {
                    throw new ArithmeticException("Multiplication overflows a long: " + l + " * " + n);
                }
                return -l;
            }
            case 0: {
                return 0L;
            }
            case 1: {
                return l;
            }
        }
        long l2 = l * (long)n;
        if (l2 / (long)n != l) {
            throw new ArithmeticException("Multiplication overflows a long: " + l + " * " + n);
        }
        return l2;
    }

    public static long safeMultiply(long l, long l2) {
        if (l2 == 1L) {
            return l;
        }
        if (l == 1L) {
            return l2;
        }
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        long l3 = l * l2;
        if (l3 / l2 != l || l == Long.MIN_VALUE && l2 == -1L || l2 == Long.MIN_VALUE && l == -1L) {
            throw new ArithmeticException("Multiplication overflows a long: " + l + " * " + l2);
        }
        return l3;
    }

    public static int safeToInt(long l) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new ArithmeticException("Calculation overflows an int: " + l);
        }
        return (int)l;
    }

    public static long floorDiv(long l, long l2) {
        return l >= 0L ? l / l2 : (l + 1L) / l2 - 1L;
    }

    public static long floorMod(long l, long l2) {
        return (l % l2 + l2) % l2;
    }

    public static int floorMod(long l, int n) {
        return (int)((l % (long)n + (long)n) % (long)n);
    }

    public static int floorDiv(int n, int n2) {
        return n >= 0 ? n / n2 : (n + 1) / n2 - 1;
    }

    public static int floorMod(int n, int n2) {
        return (n % n2 + n2) % n2;
    }
}

