/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.temporal;

import java.util.Locale;
import java.util.Map;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.ValueRange;

public enum ChronoField implements TemporalField
{
    NANO_OF_SECOND("NanoOfSecond", (TemporalUnit)ChronoUnit.NANOS, (TemporalUnit)ChronoUnit.SECONDS, ValueRange.of(0L, 999999999L)),
    NANO_OF_DAY("NanoOfDay", (TemporalUnit)ChronoUnit.NANOS, (TemporalUnit)ChronoUnit.DAYS, ValueRange.of(0L, 86399999999999L)),
    MICRO_OF_SECOND("MicroOfSecond", (TemporalUnit)ChronoUnit.MICROS, (TemporalUnit)ChronoUnit.SECONDS, ValueRange.of(0L, 999999L)),
    MICRO_OF_DAY("MicroOfDay", (TemporalUnit)ChronoUnit.MICROS, (TemporalUnit)ChronoUnit.DAYS, ValueRange.of(0L, 86399999999L)),
    MILLI_OF_SECOND("MilliOfSecond", (TemporalUnit)ChronoUnit.MILLIS, (TemporalUnit)ChronoUnit.SECONDS, ValueRange.of(0L, 999L)),
    MILLI_OF_DAY("MilliOfDay", (TemporalUnit)ChronoUnit.MILLIS, (TemporalUnit)ChronoUnit.DAYS, ValueRange.of(0L, 86399999L)),
    SECOND_OF_MINUTE("SecondOfMinute", (TemporalUnit)ChronoUnit.SECONDS, (TemporalUnit)ChronoUnit.MINUTES, ValueRange.of(0L, 59L)),
    SECOND_OF_DAY("SecondOfDay", (TemporalUnit)ChronoUnit.SECONDS, (TemporalUnit)ChronoUnit.DAYS, ValueRange.of(0L, 86399L)),
    MINUTE_OF_HOUR("MinuteOfHour", (TemporalUnit)ChronoUnit.MINUTES, (TemporalUnit)ChronoUnit.HOURS, ValueRange.of(0L, 59L)),
    MINUTE_OF_DAY("MinuteOfDay", (TemporalUnit)ChronoUnit.MINUTES, (TemporalUnit)ChronoUnit.DAYS, ValueRange.of(0L, 1439L)),
    HOUR_OF_AMPM("HourOfAmPm", (TemporalUnit)ChronoUnit.HOURS, (TemporalUnit)ChronoUnit.HALF_DAYS, ValueRange.of(0L, 11L)),
    CLOCK_HOUR_OF_AMPM("ClockHourOfAmPm", (TemporalUnit)ChronoUnit.HOURS, (TemporalUnit)ChronoUnit.HALF_DAYS, ValueRange.of(1L, 12L)),
    HOUR_OF_DAY("HourOfDay", (TemporalUnit)ChronoUnit.HOURS, (TemporalUnit)ChronoUnit.DAYS, ValueRange.of(0L, 23L)),
    CLOCK_HOUR_OF_DAY("ClockHourOfDay", (TemporalUnit)ChronoUnit.HOURS, (TemporalUnit)ChronoUnit.DAYS, ValueRange.of(1L, 24L)),
    AMPM_OF_DAY("AmPmOfDay", (TemporalUnit)ChronoUnit.HALF_DAYS, (TemporalUnit)ChronoUnit.DAYS, ValueRange.of(0L, 1L)),
    DAY_OF_WEEK("DayOfWeek", (TemporalUnit)ChronoUnit.DAYS, (TemporalUnit)ChronoUnit.WEEKS, ValueRange.of(1L, 7L)),
    ALIGNED_DAY_OF_WEEK_IN_MONTH("AlignedDayOfWeekInMonth", (TemporalUnit)ChronoUnit.DAYS, (TemporalUnit)ChronoUnit.WEEKS, ValueRange.of(1L, 7L)),
    ALIGNED_DAY_OF_WEEK_IN_YEAR("AlignedDayOfWeekInYear", (TemporalUnit)ChronoUnit.DAYS, (TemporalUnit)ChronoUnit.WEEKS, ValueRange.of(1L, 7L)),
    DAY_OF_MONTH("DayOfMonth", (TemporalUnit)ChronoUnit.DAYS, (TemporalUnit)ChronoUnit.MONTHS, ValueRange.of(1L, 28L, 31L)),
    DAY_OF_YEAR("DayOfYear", (TemporalUnit)ChronoUnit.DAYS, (TemporalUnit)ChronoUnit.YEARS, ValueRange.of(1L, 365L, 366L)),
    EPOCH_DAY("EpochDay", (TemporalUnit)ChronoUnit.DAYS, (TemporalUnit)ChronoUnit.FOREVER, ValueRange.of(-365243219162L, 365241780471L)),
    ALIGNED_WEEK_OF_MONTH("AlignedWeekOfMonth", (TemporalUnit)ChronoUnit.WEEKS, (TemporalUnit)ChronoUnit.MONTHS, ValueRange.of(1L, 4L, 5L)),
    ALIGNED_WEEK_OF_YEAR("AlignedWeekOfYear", (TemporalUnit)ChronoUnit.WEEKS, (TemporalUnit)ChronoUnit.YEARS, ValueRange.of(1L, 53L)),
    MONTH_OF_YEAR("MonthOfYear", (TemporalUnit)ChronoUnit.MONTHS, (TemporalUnit)ChronoUnit.YEARS, ValueRange.of(1L, 12L)),
    PROLEPTIC_MONTH("ProlepticMonth", (TemporalUnit)ChronoUnit.MONTHS, (TemporalUnit)ChronoUnit.FOREVER, ValueRange.of(-11999999988L, 11999999999L)),
    YEAR_OF_ERA("YearOfEra", (TemporalUnit)ChronoUnit.YEARS, (TemporalUnit)ChronoUnit.FOREVER, ValueRange.of(1L, 999999999L, 1000000000L)),
    YEAR("Year", (TemporalUnit)ChronoUnit.YEARS, (TemporalUnit)ChronoUnit.FOREVER, ValueRange.of(-999999999L, 999999999L)),
    ERA("Era", (TemporalUnit)ChronoUnit.ERAS, (TemporalUnit)ChronoUnit.FOREVER, ValueRange.of(0L, 1L)),
    INSTANT_SECONDS("InstantSeconds", (TemporalUnit)ChronoUnit.SECONDS, (TemporalUnit)ChronoUnit.FOREVER, ValueRange.of(Long.MIN_VALUE, Long.MAX_VALUE)),
    OFFSET_SECONDS("OffsetSeconds", (TemporalUnit)ChronoUnit.SECONDS, (TemporalUnit)ChronoUnit.FOREVER, ValueRange.of(-64800L, 64800L));

    private final String name;
    private final TemporalUnit baseUnit;
    private final TemporalUnit rangeUnit;
    private final ValueRange range;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private ChronoField(TemporalUnit temporalUnit, ValueRange valueRange) {
        void var6_4;
        void var5_3;
        this.name = temporalUnit;
        this.baseUnit = valueRange;
        this.rangeUnit = var5_3;
        this.range = var6_4;
    }

    public TemporalUnit getBaseUnit() {
        return this.baseUnit;
    }

    public TemporalUnit getRangeUnit() {
        return this.rangeUnit;
    }

    public ValueRange range() {
        return this.range;
    }

    public boolean isDateBased() {
        return this.ordinal() >= DAY_OF_WEEK.ordinal() && this.ordinal() <= ERA.ordinal();
    }

    public boolean isTimeBased() {
        return this.ordinal() < DAY_OF_WEEK.ordinal();
    }

    public long checkValidValue(long l) {
        return this.range().checkValidValue(l, this);
    }

    public int checkValidIntValue(long l) {
        return this.range().checkValidIntValue(l, this);
    }

    public boolean isSupportedBy(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(this);
    }

    public ValueRange rangeRefinedBy(TemporalAccessor temporalAccessor) {
        return temporalAccessor.range(this);
    }

    public long getFrom(TemporalAccessor temporalAccessor) {
        return temporalAccessor.getLong(this);
    }

    public Temporal adjustInto(Temporal temporal, long l) {
        return temporal.with(this, l);
    }

    public String getDisplayName(Locale locale) {
        Jdk8Methods.requireNonNull(locale, "locale");
        return this.toString();
    }

    public TemporalAccessor resolve(Map map, TemporalAccessor temporalAccessor, ResolverStyle resolverStyle) {
        return null;
    }

    public String toString() {
        return this.name;
    }
}

