/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.temporal;

import oz.threeten.bp.Duration;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.chrono.ChronoLocalDateTime;
import oz.threeten.bp.chrono.ChronoZonedDateTime;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalUnit;

public enum ChronoUnit implements TemporalUnit
{
    NANOS("Nanos", Duration.ofNanos(1L)),
    MICROS("Micros", Duration.ofNanos(1000L)),
    MILLIS("Millis", Duration.ofNanos(1000000L)),
    SECONDS("Seconds", Duration.ofSeconds(1L)),
    MINUTES("Minutes", Duration.ofSeconds(60L)),
    HOURS("Hours", Duration.ofSeconds(3600L)),
    HALF_DAYS("HalfDays", Duration.ofSeconds(43200L)),
    DAYS("Days", Duration.ofSeconds(86400L)),
    WEEKS("Weeks", Duration.ofSeconds(604800L)),
    MONTHS("Months", Duration.ofSeconds(2629746L)),
    YEARS("Years", Duration.ofSeconds(31556952L)),
    DECADES("Decades", Duration.ofSeconds(315569520L)),
    CENTURIES("Centuries", Duration.ofSeconds(3155695200L)),
    MILLENNIA("Millennia", Duration.ofSeconds(31556952000L)),
    ERAS("Eras", Duration.ofSeconds(31556952000000000L)),
    FOREVER("Forever", Duration.ofSeconds(Long.MAX_VALUE, 999999999L));

    private final String name;
    private final Duration duration;

    /*
     * WARNING - void declaration
     */
    private ChronoUnit() {
        void var4_1;
        void var3_2;
        this.name = var3_2;
        this.duration = var4_1;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public boolean isDurationEstimated() {
        return this.isDateBased() || this == FOREVER;
    }

    public boolean isDateBased() {
        return this.compareTo(DAYS) >= 0 && this != FOREVER;
    }

    public boolean isTimeBased() {
        return this.compareTo(DAYS) < 0;
    }

    public boolean isSupportedBy(Temporal temporal) {
        if (this == FOREVER) {
            return false;
        }
        if (temporal instanceof ChronoLocalDate) {
            return this.isDateBased();
        }
        if (temporal instanceof ChronoLocalDateTime || temporal instanceof ChronoZonedDateTime) {
            return true;
        }
        try {
            temporal.plus(1L, this);
            return true;
        }
        catch (RuntimeException runtimeException) {
            try {
                temporal.plus(-1L, this);
                return true;
            }
            catch (RuntimeException runtimeException2) {
                return false;
            }
        }
    }

    public Temporal addTo(Temporal temporal, long l) {
        return temporal.plus(l, this);
    }

    public long between(Temporal temporal, Temporal temporal2) {
        return temporal.until(temporal2, this);
    }

    public String toString() {
        return this.name;
    }
}

