/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.temporal;

import java.util.Map;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.IsoFields;
import oz.threeten.bp.temporal.IsoFields$Field;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;

final class IsoFields$Field$1
extends IsoFields$Field {
    public String toString() {
        return "DayOfQuarter";
    }

    public TemporalUnit getBaseUnit() {
        return ChronoUnit.DAYS;
    }

    public TemporalUnit getRangeUnit() {
        return IsoFields.QUARTER_YEARS;
    }

    public ValueRange range() {
        return ValueRange.of(1L, 90L, 92L);
    }

    public boolean isSupportedBy(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(ChronoField.DAY_OF_YEAR) && temporalAccessor.isSupported(ChronoField.MONTH_OF_YEAR) && temporalAccessor.isSupported(ChronoField.YEAR) && IsoFields$Field.access$100(temporalAccessor);
    }

    public ValueRange rangeRefinedBy(TemporalAccessor temporalAccessor) {
        if (!temporalAccessor.isSupported(this)) {
            throw new UnsupportedTemporalTypeException("Unsupported field: DayOfQuarter");
        }
        long l = temporalAccessor.getLong(QUARTER_OF_YEAR);
        if (l == 1L) {
            long l2 = temporalAccessor.getLong(ChronoField.YEAR);
            return IsoChronology.INSTANCE.isLeapYear(l2) ? ValueRange.of(1L, 91L) : ValueRange.of(1L, 90L);
        }
        if (l == 2L) {
            return ValueRange.of(1L, 91L);
        }
        if (l == 3L || l == 4L) {
            return ValueRange.of(1L, 92L);
        }
        return this.range();
    }

    public long getFrom(TemporalAccessor temporalAccessor) {
        if (!temporalAccessor.isSupported(this)) {
            throw new UnsupportedTemporalTypeException("Unsupported field: DayOfQuarter");
        }
        int n = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
        int n2 = temporalAccessor.get(ChronoField.MONTH_OF_YEAR);
        long l = temporalAccessor.getLong(ChronoField.YEAR);
        return n - IsoFields$Field.access$200()[(n2 - 1) / 3 + (IsoChronology.INSTANCE.isLeapYear(l) ? 4 : 0)];
    }

    public Temporal adjustInto(Temporal temporal, long l) {
        long l2 = this.getFrom(temporal);
        this.range().checkValidValue(l, this);
        return temporal.with(ChronoField.DAY_OF_YEAR, temporal.getLong(ChronoField.DAY_OF_YEAR) + (l - l2));
    }

    public TemporalAccessor resolve(Map map, TemporalAccessor temporalAccessor, ResolverStyle resolverStyle) {
        LocalDate localDate;
        Long l = (Long)map.get(ChronoField.YEAR);
        Long l2 = (Long)map.get(QUARTER_OF_YEAR);
        if (l == null || l2 == null) {
            return null;
        }
        int n = ChronoField.YEAR.checkValidIntValue(l);
        long l3 = (Long)map.get(DAY_OF_QUARTER);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long l4 = l2;
            localDate = LocalDate.of(n, 1, 1);
            localDate = localDate.plusMonths(Jdk8Methods.safeMultiply(Jdk8Methods.safeSubtract(l4, 1L), 3));
            localDate = localDate.plusDays(Jdk8Methods.safeSubtract(l3, 1L));
        } else {
            int n2 = QUARTER_OF_YEAR.range().checkValidIntValue(l2, QUARTER_OF_YEAR);
            if (resolverStyle == ResolverStyle.STRICT) {
                int n3 = 92;
                if (n2 == 1) {
                    n3 = IsoChronology.INSTANCE.isLeapYear(n) ? 91 : 90;
                } else if (n2 == 2) {
                    n3 = 91;
                }
                ValueRange.of(1L, n3).checkValidValue(l3, this);
            } else {
                this.range().checkValidValue(l3, this);
            }
            localDate = LocalDate.of(n, (n2 - 1) * 3 + 1, 1).plusDays(l3 - 1L);
        }
        map.remove(this);
        map.remove(ChronoField.YEAR);
        map.remove(QUARTER_OF_YEAR);
        return localDate;
    }
}

