/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.temporal;

import java.util.Locale;
import java.util.Map;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.IsoFields;
import oz.threeten.bp.temporal.IsoFields$Field;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;

final class IsoFields$Field$3
extends IsoFields$Field {
    public String toString() {
        return "WeekOfWeekBasedYear";
    }

    public TemporalUnit getBaseUnit() {
        return ChronoUnit.WEEKS;
    }

    public TemporalUnit getRangeUnit() {
        return IsoFields.WEEK_BASED_YEARS;
    }

    public String getDisplayName(Locale locale) {
        Jdk8Methods.requireNonNull(locale, "locale");
        return "Week";
    }

    public ValueRange range() {
        return ValueRange.of(1L, 52L, 53L);
    }

    public boolean isSupportedBy(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(ChronoField.EPOCH_DAY) && IsoFields$Field.access$100(temporalAccessor);
    }

    public ValueRange rangeRefinedBy(TemporalAccessor temporalAccessor) {
        if (!temporalAccessor.isSupported(this)) {
            throw new UnsupportedTemporalTypeException("Unsupported field: WeekOfWeekBasedYear");
        }
        return IsoFields$Field.access$300(LocalDate.from(temporalAccessor));
    }

    public long getFrom(TemporalAccessor temporalAccessor) {
        if (!temporalAccessor.isSupported(this)) {
            throw new UnsupportedTemporalTypeException("Unsupported field: WeekOfWeekBasedYear");
        }
        return IsoFields$Field.access$400(LocalDate.from(temporalAccessor));
    }

    public Temporal adjustInto(Temporal temporal, long l) {
        this.range().checkValidValue(l, this);
        return temporal.plus(Jdk8Methods.safeSubtract(l, this.getFrom(temporal)), ChronoUnit.WEEKS);
    }

    public TemporalAccessor resolve(Map map, TemporalAccessor temporalAccessor, ResolverStyle resolverStyle) {
        LocalDate localDate;
        Long l = (Long)map.get(WEEK_BASED_YEAR);
        Long l2 = (Long)map.get(ChronoField.DAY_OF_WEEK);
        if (l == null || l2 == null) {
            return null;
        }
        int n = WEEK_BASED_YEAR.range().checkValidIntValue(l, WEEK_BASED_YEAR);
        long l3 = (Long)map.get(WEEK_OF_WEEK_BASED_YEAR);
        if (resolverStyle == ResolverStyle.LENIENT) {
            long l4 = l2;
            long l5 = 0L;
            if (l4 > 7L) {
                l5 = (l4 - 1L) / 7L;
                l4 = (l4 - 1L) % 7L + 1L;
            } else if (l4 < 1L) {
                l5 = l4 / 7L - 1L;
                l4 = l4 % 7L + 7L;
            }
            localDate = LocalDate.of(n, 1, 4).plusWeeks(l3 - 1L).plusWeeks(l5).with(ChronoField.DAY_OF_WEEK, l4);
        } else {
            int n2 = ChronoField.DAY_OF_WEEK.checkValidIntValue(l2);
            if (resolverStyle == ResolverStyle.STRICT) {
                LocalDate localDate2 = LocalDate.of(n, 1, 4);
                ValueRange valueRange = IsoFields$Field.access$300(localDate2);
                valueRange.checkValidValue(l3, this);
            } else {
                this.range().checkValidValue(l3, this);
            }
            localDate = LocalDate.of(n, 1, 4).plusWeeks(l3 - 1L).with(ChronoField.DAY_OF_WEEK, n2);
        }
        map.remove(this);
        map.remove(WEEK_BASED_YEAR);
        map.remove(ChronoField.DAY_OF_WEEK);
        return localDate;
    }
}

