/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.temporal;

import java.util.Locale;
import java.util.Map;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.IsoFields$1;
import oz.threeten.bp.temporal.IsoFields$Field$1;
import oz.threeten.bp.temporal.IsoFields$Field$2;
import oz.threeten.bp.temporal.IsoFields$Field$3;
import oz.threeten.bp.temporal.IsoFields$Field$4;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.ValueRange;

abstract class IsoFields$Field
extends Enum
implements TemporalField {
    public static final /* enum */ IsoFields$Field DAY_OF_QUARTER = new IsoFields$Field$1();
    public static final /* enum */ IsoFields$Field QUARTER_OF_YEAR = new IsoFields$Field$2();
    public static final /* enum */ IsoFields$Field WEEK_OF_WEEK_BASED_YEAR = new IsoFields$Field$3();
    public static final /* enum */ IsoFields$Field WEEK_BASED_YEAR = new IsoFields$Field$4();
    private static final int[] QUARTER_DAYS;
    private static final /* synthetic */ IsoFields$Field[] $VALUES;

    public static IsoFields$Field[] values() {
        return (IsoFields$Field[])$VALUES.clone();
    }

    public static IsoFields$Field valueOf(String string) {
        return Enum.valueOf(IsoFields$Field.class, string);
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private IsoFields$Field() {
        void var2_-1;
        void var1_-1;
    }

    public String getDisplayName(Locale locale) {
        Jdk8Methods.requireNonNull(locale, "locale");
        return this.toString();
    }

    public TemporalAccessor resolve(Map map, TemporalAccessor temporalAccessor, ResolverStyle resolverStyle) {
        return null;
    }

    public boolean isDateBased() {
        return true;
    }

    public boolean isTimeBased() {
        return false;
    }

    private static boolean isIso(TemporalAccessor temporalAccessor) {
        return Chronology.from(temporalAccessor).equals(IsoChronology.INSTANCE);
    }

    private static ValueRange getWeekRange(LocalDate localDate) {
        int n = IsoFields$Field.getWeekBasedYear(localDate);
        return ValueRange.of(1L, IsoFields$Field.getWeekRange(n));
    }

    private static int getWeekRange(int n) {
        LocalDate localDate = LocalDate.of(n, 1, 1);
        if (localDate.getDayOfWeek() == DayOfWeek.THURSDAY || localDate.getDayOfWeek() == DayOfWeek.WEDNESDAY && localDate.isLeapYear()) {
            return 53;
        }
        return 52;
    }

    private static int getWeek(LocalDate localDate) {
        int n;
        int n2 = localDate.getDayOfWeek().ordinal();
        int n3 = localDate.getDayOfYear() - 1;
        int n4 = n3 + (3 - n2);
        int n5 = n4 - (n = n4 / 7) * 7;
        int n6 = n5 - 3;
        if (n6 < -3) {
            n6 += 7;
        }
        if (n3 < n6) {
            return (int)IsoFields$Field.getWeekRange(localDate.withDayOfYear(180).minusYears(1L)).getMaximum();
        }
        int n7 = (n3 - n6) / 7 + 1;
        if (n7 == 53 && !(n6 == -3 || n6 == -2 && localDate.isLeapYear())) {
            n7 = 1;
        }
        return n7;
    }

    private static int getWeekBasedYear(LocalDate localDate) {
        int n = localDate.getYear();
        int n2 = localDate.getDayOfYear();
        if (n2 <= 3) {
            int n3 = localDate.getDayOfWeek().ordinal();
            if (n2 - n3 < -2) {
                --n;
            }
        } else if (n2 >= 363) {
            int n4 = localDate.getDayOfWeek().ordinal();
            if ((n2 = n2 - 363 - (localDate.isLeapYear() ? 1 : 0)) - n4 >= 0) {
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    /* synthetic */ IsoFields$Field(IsoFields$1 isoFields$1) {
        this((String)var1_-1, (int)var2_1);
        void var2_1;
        void var1_-1;
    }

    static /* synthetic */ boolean access$100(TemporalAccessor temporalAccessor) {
        return IsoFields$Field.isIso(temporalAccessor);
    }

    static /* synthetic */ int[] access$200() {
        return QUARTER_DAYS;
    }

    static /* synthetic */ ValueRange access$300(LocalDate localDate) {
        return IsoFields$Field.getWeekRange(localDate);
    }

    static /* synthetic */ int access$400(LocalDate localDate) {
        return IsoFields$Field.getWeek(localDate);
    }

    static /* synthetic */ int access$500(LocalDate localDate) {
        return IsoFields$Field.getWeekBasedYear(localDate);
    }

    static /* synthetic */ int access$600(int n) {
        return IsoFields$Field.getWeekRange(n);
    }

    static {
        $VALUES = new IsoFields$Field[]{DAY_OF_QUARTER, QUARTER_OF_YEAR, WEEK_OF_WEEK_BASED_YEAR, WEEK_BASED_YEAR};
        QUARTER_DAYS = new int[]{0, 90, 181, 273, 0, 91, 182, 274};
    }
}

