/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.temporal;

import java.util.Locale;
import java.util.Map;
import oz.threeten.bp.DateTimeException;
import oz.threeten.bp.chrono.Chronology;
import oz.threeten.bp.format.ResolverStyle;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.ChronoUnit;
import oz.threeten.bp.temporal.Temporal;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.temporal.TemporalField;
import oz.threeten.bp.temporal.TemporalUnit;
import oz.threeten.bp.temporal.UnsupportedTemporalTypeException;
import oz.threeten.bp.temporal.ValueRange;

enum JulianFields$Field implements TemporalField
{
    JULIAN_DAY("JulianDay", (TemporalUnit)ChronoUnit.DAYS, (TemporalUnit)ChronoUnit.FOREVER, 2440588L),
    MODIFIED_JULIAN_DAY("ModifiedJulianDay", (TemporalUnit)ChronoUnit.DAYS, (TemporalUnit)ChronoUnit.FOREVER, 40587L),
    RATA_DIE("RataDie", (TemporalUnit)ChronoUnit.DAYS, (TemporalUnit)ChronoUnit.FOREVER, 719163L);

    private final String name;
    private final TemporalUnit baseUnit;
    private final TemporalUnit rangeUnit;
    private final ValueRange range;
    private final long offset;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private JulianFields$Field(TemporalUnit temporalUnit, long l) {
        void var6_4;
        void var5_3;
        this.name = temporalUnit;
        this.baseUnit = (TemporalUnit)l;
        this.rangeUnit = var5_3;
        this.range = ValueRange.of(-365243219162L + var6_4, 365241780471L + var6_4);
        this.offset = var6_4;
    }

    public TemporalUnit getBaseUnit() {
        return this.baseUnit;
    }

    public TemporalUnit getRangeUnit() {
        return this.rangeUnit;
    }

    public ValueRange range() {
        return this.range;
    }

    public boolean isDateBased() {
        return true;
    }

    public boolean isTimeBased() {
        return false;
    }

    public boolean isSupportedBy(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(ChronoField.EPOCH_DAY);
    }

    public ValueRange rangeRefinedBy(TemporalAccessor temporalAccessor) {
        if (!this.isSupportedBy(temporalAccessor)) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + this);
        }
        return this.range();
    }

    public long getFrom(TemporalAccessor temporalAccessor) {
        return temporalAccessor.getLong(ChronoField.EPOCH_DAY) + this.offset;
    }

    public Temporal adjustInto(Temporal temporal, long l) {
        if (!this.range().isValidValue(l)) {
            throw new DateTimeException("Invalid value: " + this.name + " " + l);
        }
        return temporal.with(ChronoField.EPOCH_DAY, Jdk8Methods.safeSubtract(l, this.offset));
    }

    public String getDisplayName(Locale locale) {
        Jdk8Methods.requireNonNull(locale, "locale");
        return this.toString();
    }

    public TemporalAccessor resolve(Map map, TemporalAccessor temporalAccessor, ResolverStyle resolverStyle) {
        long l = (Long)map.remove(this);
        Chronology chronology = Chronology.from(temporalAccessor);
        return chronology.dateEpochDay(Jdk8Methods.safeSubtract(l, this.offset));
    }

    public String toString() {
        return this.name;
    }
}

