/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.zone;

import java.util.List;
import java.util.Map;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.Year;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.temporal.TemporalAdjusters;
import oz.threeten.bp.zone.TzdbZoneRulesCompiler;
import oz.threeten.bp.zone.TzdbZoneRulesCompiler$TZDBMonthDayTime;
import oz.threeten.bp.zone.TzdbZoneRulesCompiler$TZDBRule;
import oz.threeten.bp.zone.ZoneRulesBuilder;

final class TzdbZoneRulesCompiler$TZDBZone
extends TzdbZoneRulesCompiler$TZDBMonthDayTime {
    ZoneOffset standardOffset;
    Integer fixedSavingsSecs;
    String savingsRule;
    String text;
    Year year;
    final /* synthetic */ TzdbZoneRulesCompiler this$0;

    TzdbZoneRulesCompiler$TZDBZone(TzdbZoneRulesCompiler tzdbZoneRulesCompiler) {
        this.this$0 = tzdbZoneRulesCompiler;
        super(tzdbZoneRulesCompiler);
    }

    ZoneRulesBuilder addToBuilder(ZoneRulesBuilder zoneRulesBuilder, Map map) {
        if (this.year != null) {
            zoneRulesBuilder.addWindow(this.standardOffset, this.toDateTime(this.year.getValue()), this.timeDefinition);
        } else {
            zoneRulesBuilder.addWindowForever(this.standardOffset);
        }
        if (this.fixedSavingsSecs != null) {
            zoneRulesBuilder.setFixedSavingsToWindow(this.fixedSavingsSecs);
        } else {
            List list = (List)map.get(this.savingsRule);
            if (list == null) {
                throw new IllegalArgumentException("Rule not found: " + this.savingsRule);
            }
            for (TzdbZoneRulesCompiler$TZDBRule tzdbZoneRulesCompiler$TZDBRule : list) {
                tzdbZoneRulesCompiler$TZDBRule.addToBuilder(zoneRulesBuilder);
            }
        }
        return zoneRulesBuilder;
    }

    private LocalDateTime toDateTime(int n) {
        LocalDate localDate;
        this.adjustToFowards(n);
        if (this.dayOfMonth == -1) {
            this.dayOfMonth = this.month.length(Year.isLeap(n));
            localDate = LocalDate.of(n, this.month, this.dayOfMonth);
            if (this.dayOfWeek != null) {
                localDate = localDate.with(TemporalAdjusters.previousOrSame(this.dayOfWeek));
            }
        } else {
            localDate = LocalDate.of(n, this.month, this.dayOfMonth);
            if (this.dayOfWeek != null) {
                localDate = localDate.with(TemporalAdjusters.nextOrSame(this.dayOfWeek));
            }
        }
        localDate = (LocalDate)this.this$0.deduplicate(localDate.plusDays(this.adjustDays));
        return LocalDateTime.of(localDate, this.time);
    }
}

