/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.zone;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Month;
import oz.threeten.bp.Year;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.chrono.ChronoLocalDate;
import oz.threeten.bp.format.DateTimeFormatter;
import oz.threeten.bp.format.DateTimeFormatterBuilder;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.temporal.TemporalAccessor;
import oz.threeten.bp.zone.Ser;
import oz.threeten.bp.zone.TzdbZoneRulesCompiler$LeapSecondRule;
import oz.threeten.bp.zone.TzdbZoneRulesCompiler$TZDBMonthDayTime;
import oz.threeten.bp.zone.TzdbZoneRulesCompiler$TZDBRule;
import oz.threeten.bp.zone.TzdbZoneRulesCompiler$TZDBZone;
import oz.threeten.bp.zone.ZoneOffsetTransitionRule$TimeDefinition;
import oz.threeten.bp.zone.ZoneRules;
import oz.threeten.bp.zone.ZoneRulesBuilder;

final class TzdbZoneRulesCompiler {
    private static final DateTimeFormatter TIME_PARSER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private final Map rules = new HashMap();
    private final Map zones = new HashMap();
    private final Map links = new HashMap();
    private final SortedMap builtZones = new TreeMap();
    private Map deduplicateMap = new HashMap();
    private final SortedMap leapSeconds = new TreeMap();
    private final String version;
    private final List sourceFiles;
    private final File leapSecondsFile;
    private final boolean verbose;

    public static void main(String[] stringArray) {
        List<String> list;
        int n;
        if (stringArray.length < 2) {
            TzdbZoneRulesCompiler.outputHelp();
            return;
        }
        String string = null;
        File file = null;
        File file2 = null;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < stringArray.length && ((String)((Object)(list = stringArray[n]))).startsWith("-"); ++n) {
            if ("-srcdir".equals(list)) {
                if (file == null && ++n < stringArray.length) {
                    file = new File(stringArray[n]);
                    continue;
                }
            } else if ("-dstdir".equals(list)) {
                if (file2 == null && ++n < stringArray.length) {
                    file2 = new File(stringArray[n]);
                    continue;
                }
            } else if ("-version".equals(list)) {
                if (string == null && ++n < stringArray.length) {
                    string = stringArray[n];
                    continue;
                }
            } else if ("-unpacked".equals(list)) {
                if (!bl) {
                    bl = true;
                    continue;
                }
            } else if ("-verbose".equals(list)) {
                if (!bl2) {
                    bl2 = true;
                    continue;
                }
            } else if (!"-help".equals(list)) {
                System.out.println("Unrecognised option: " + (String)((Object)list));
            }
            TzdbZoneRulesCompiler.outputHelp();
            return;
        }
        if (file == null) {
            System.out.println("Source directory must be specified using -srcdir: " + file);
            return;
        }
        if (!file.isDirectory()) {
            System.out.println("Source does not exist or is not a directory: " + file);
            return;
        }
        file2 = file2 != null ? file2 : file;
        list = Arrays.asList(Arrays.copyOfRange(stringArray, n, stringArray.length));
        if (list.isEmpty()) {
            System.out.println("Source filenames not specified, using default set");
            System.out.println("(africa antarctica asia australasia backward etcetera europe northamerica southamerica)");
            list = Arrays.asList("africa", "antarctica", "asia", "australasia", "backward", "etcetera", "europe", "northamerica", "southamerica");
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        if (string != null) {
            File file3 = new File(file, string);
            if (!file3.isDirectory()) {
                System.out.println("Version does not represent a valid source directory : " + file3);
                return;
            }
            arrayList.add(file3);
        } else {
            File[] fileArray;
            for (File file4 : fileArray = file.listFiles()) {
                if (!file4.isDirectory() || !file4.getName().matches("[12][0-9][0-9][0-9][A-Za-z0-9._-]+")) continue;
                arrayList.add(file4);
            }
        }
        if (arrayList.isEmpty()) {
            System.out.println("Source directory contains no valid source folders: " + file);
            return;
        }
        if (!file2.exists() && !file2.mkdirs()) {
            System.out.println("Destination directory could not be created: " + file2);
            return;
        }
        if (!file2.isDirectory()) {
            System.out.println("Destination is not a directory: " + file2);
            return;
        }
        TzdbZoneRulesCompiler.process(arrayList, list, file2, bl, bl2);
    }

    private static void outputHelp() {
        System.out.println("Usage: TzdbZoneRulesCompiler <options> <tzdb source filenames>");
        System.out.println("where options include:");
        System.out.println("   -srcdir <directory>   Where to find source directories (required)");
        System.out.println("   -dstdir <directory>   Where to output generated files (default srcdir)");
        System.out.println("   -version <version>    Specify the version, such as 2009a (optional)");
        System.out.println("   -unpacked             Generate dat files without jar files");
        System.out.println("   -help                 Print this usage message");
        System.out.println("   -verbose              Output verbose information during compilation");
        System.out.println(" There must be one directory for each version in srcdir");
        System.out.println(" Each directory must have the name of the version, such as 2009a");
        System.out.println(" Each directory must contain the unpacked tzdb files, such as asia or europe");
        System.out.println(" Directories must match the regex [12][0-9][0-9][0-9][A-Za-z0-9._-]+");
        System.out.println(" There will be one jar file for each version and one combined jar in dstdir");
        System.out.println(" If the version is specified, only that version is processed");
    }

    private static void process(List list, List list2, File file, boolean bl, boolean bl2) {
        HashMap hashMap = new HashMap();
        TreeMap<String, SortedMap> treeMap = new TreeMap<String, SortedMap>();
        TreeSet treeSet = new TreeSet();
        HashSet hashSet = new HashSet();
        SortedMap sortedMap = null;
        for (File file2 : list) {
            Object object;
            String string2;
            ArrayList<File> arrayList = new ArrayList<File>();
            for (String string2 : list2) {
                object = new File(file2, string2);
                if (!((File)object).exists()) continue;
                arrayList.add((File)object);
            }
            if (arrayList.isEmpty()) continue;
            Object object2 = new File(file2, "leapseconds");
            if (!((File)object2).exists()) {
                System.out.println("Version " + file2.getName() + " does not include leap seconds information.");
                object2 = null;
            }
            string2 = file2.getName();
            object = new TzdbZoneRulesCompiler(string2, arrayList, (File)object2, bl2);
            ((TzdbZoneRulesCompiler)object).setDeduplicateMap(hashMap);
            try {
                ((TzdbZoneRulesCompiler)object).compile();
                SortedMap sortedMap2 = ((TzdbZoneRulesCompiler)object).getZones();
                SortedMap sortedMap3 = ((TzdbZoneRulesCompiler)object).getLeapSeconds();
                if (!bl) {
                    File file3 = new File(file, "threeten-TZDB-" + string2 + ".jar");
                    if (bl2) {
                        System.out.println("Outputting file: " + file3);
                    }
                    TzdbZoneRulesCompiler.outputFile(file3, string2, sortedMap2, sortedMap3);
                }
                treeMap.put(string2, sortedMap2);
                treeSet.addAll(sortedMap2.keySet());
                hashSet.addAll(sortedMap2.values());
                if (super.getMostRecentLeapSecond() == null || sortedMap != null && super.getMostRecentLeapSecond().compareTo((ChronoLocalDate)sortedMap.lastKey()) <= 0) continue;
                sortedMap = sortedMap3;
            }
            catch (Exception exception) {
                System.out.println("Failed: " + exception.toString());
                exception.printStackTrace();
                System.exit(1);
            }
        }
        if (bl) {
            if (bl2) {
                System.out.println("Outputting combined files: " + file);
            }
            TzdbZoneRulesCompiler.outputFilesDat(file, treeMap, treeSet, hashSet, sortedMap);
        } else {
            File file4 = new File(file, "threeten-TZDB-all.jar");
            if (bl2) {
                System.out.println("Outputting combined file: " + file4);
            }
            TzdbZoneRulesCompiler.outputFile(file4, treeMap, treeSet, hashSet, sortedMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outputFilesDat(File file, Map map, Set set, Set set2, SortedMap sortedMap) {
        File file2 = new File(file, "TZDB.dat");
        file2.delete();
        try {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file2);
                TzdbZoneRulesCompiler.outputTzdbDat(fileOutputStream, map, set, set2);
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Failed: " + exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static void outputFile(File file, String string, SortedMap sortedMap, SortedMap sortedMap2) {
        TreeMap<String, SortedMap> treeMap = new TreeMap<String, SortedMap>();
        treeMap.put(string, sortedMap);
        TreeSet treeSet = new TreeSet(sortedMap.keySet());
        HashSet hashSet = new HashSet(sortedMap.values());
        TzdbZoneRulesCompiler.outputFile(file, treeMap, treeSet, hashSet, sortedMap2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outputFile(File file, Map map, Set set, Set set2, SortedMap sortedMap) {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new JarOutputStream(new FileOutputStream(file));
            TzdbZoneRulesCompiler.outputTzdbEntry((JarOutputStream)zipOutputStream, map, set, set2);
        }
        catch (Exception exception) {
            System.out.println("Failed: " + exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void outputTzdbEntry(JarOutputStream jarOutputStream, Map map, Set set, Set set2) {
        try {
            jarOutputStream.putNextEntry(new ZipEntry("org/threeten/bp/TZDB.dat"));
            TzdbZoneRulesCompiler.outputTzdbDat(jarOutputStream, map, set, set2);
            jarOutputStream.closeEntry();
        }
        catch (Exception exception) {
            System.out.println("Failed: " + exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void outputTzdbDat(OutputStream outputStream, Map map, Set set, Set set2) {
        Object object;
        Object object2;
        Object object32;
        void iterator;
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeUTF("TZDB");
        Object[] objectArray = map.keySet().toArray(new String[map.size()]);
        dataOutputStream.writeShort(objectArray.length);
        for (String string : objectArray) {
            dataOutputStream.writeUTF(string);
        }
        Object[] objectArray2 = set.toArray(new String[set.size()]);
        dataOutputStream.writeShort(objectArray2.length);
        Object arrayList = objectArray2;
        int n = ((String[])arrayList).length;
        boolean bl = false;
        while (iterator < n) {
            object32 = arrayList[iterator];
            dataOutputStream.writeUTF((String)object32);
            ++iterator;
        }
        arrayList = new ArrayList(set2);
        dataOutputStream.writeShort(arrayList.size());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            object32 = (ZoneRules)iterator2.next();
            byteArrayOutputStream.reset();
            object2 = new DataOutputStream(byteArrayOutputStream);
            Ser.write(object32, (DataOutput)object2);
            ((FilterOutputStream)object2).close();
            object = byteArrayOutputStream.toByteArray();
            dataOutputStream.writeShort(((byte[])object).length);
            dataOutputStream.write((byte[])object);
        }
        for (Object object32 : map.keySet()) {
            dataOutputStream.writeShort(((SortedMap)map.get(object32)).size());
            object2 = ((SortedMap)map.get(object32)).entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                int n2 = Arrays.binarySearch(objectArray2, object.getKey());
                int n3 = arrayList.indexOf(object.getValue());
                dataOutputStream.writeShort(n2);
                dataOutputStream.writeShort(n3);
            }
        }
        dataOutputStream.flush();
    }

    public TzdbZoneRulesCompiler(String string, List list, File file, boolean bl) {
        this.version = string;
        this.sourceFiles = list;
        this.leapSecondsFile = file;
        this.verbose = bl;
    }

    public void compile() {
        this.printVerbose("Compiling TZDB version " + this.version);
        this.parseFiles();
        this.parseLeapSecondsFile();
        this.buildZoneRules();
        this.printVerbose("Compiled TZDB version " + this.version);
    }

    public SortedMap getZones() {
        return this.builtZones;
    }

    public SortedMap getLeapSeconds() {
        return this.leapSeconds;
    }

    private LocalDate getMostRecentLeapSecond() {
        return this.leapSeconds.isEmpty() ? null : (LocalDate)this.leapSeconds.lastKey();
    }

    void setDeduplicateMap(Map map) {
        this.deduplicateMap = map;
    }

    private void parseFiles() {
        for (File file : this.sourceFiles) {
            this.printVerbose("Parsing file: " + file);
            this.parseFile(file);
        }
    }

    private void parseLeapSecondsFile() {
        this.printVerbose("Parsing leap second file: " + this.leapSecondsFile);
        int n = 1;
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.leapSecondsFile));
            while ((string = bufferedReader.readLine()) != null) {
                int n2 = string.indexOf(35);
                if (n2 >= 0) {
                    string = string.substring(0, n2);
                }
                if (string.trim().length() != 0) {
                    TzdbZoneRulesCompiler$LeapSecondRule tzdbZoneRulesCompiler$LeapSecondRule = this.parseLeapSecondRule(string);
                    this.leapSeconds.put(tzdbZoneRulesCompiler$LeapSecondRule.leapDate, tzdbZoneRulesCompiler$LeapSecondRule.secondAdjustment);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new Exception("Failed while processing file '" + this.leapSecondsFile + "' on line " + n + " '" + string + "'", exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private TzdbZoneRulesCompiler$LeapSecondRule parseLeapSecondRule(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("Leap")) {
            if (stringTokenizer.countTokens() < 6) {
                this.printVerbose("Invalid leap second line in file: " + this.leapSecondsFile + ", line: " + string);
                throw new IllegalArgumentException("Invalid leap second line");
            }
        } else {
            throw new IllegalArgumentException("Unknown line");
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        Month month = this.parseMonth(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        LocalDate localDate = LocalDate.of(n, month, n2);
        String string3 = stringTokenizer.nextToken();
        byte by = 0;
        String string4 = stringTokenizer.nextToken();
        if (string4.equals("+")) {
            if (!"23:59:60".equals(string3)) {
                throw new IllegalArgumentException("Leap seconds can only be inserted at 23:59:60 - Date:" + localDate);
            }
            by = 1;
        } else if (string4.equals("-")) {
            if (!"23:59:59".equals(string3)) {
                throw new IllegalArgumentException("Leap seconds can only be removed at 23:59:59 - Date:" + localDate);
            }
            by = -1;
        } else {
            throw new IllegalArgumentException("Invalid adjustment '" + string4 + "' in leap second rule for " + localDate);
        }
        String string5 = stringTokenizer.nextToken();
        if (!"S".equalsIgnoreCase(string5)) {
            throw new IllegalArgumentException("Only stationary ('S') leap seconds are supported, not '" + string5 + "'");
        }
        return new TzdbZoneRulesCompiler$LeapSecondRule(localDate, by);
    }

    private void parseFile(File file) {
        int n = 1;
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            ArrayList arrayList = null;
            while ((string = bufferedReader.readLine()) != null) {
                int n2 = string.indexOf(35);
                if (n2 >= 0) {
                    string = string.substring(0, n2);
                }
                if (string.trim().length() != 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
                    if (arrayList != null && Character.isWhitespace(string.charAt(0)) && stringTokenizer.hasMoreTokens()) {
                        if (this.parseZoneLine(stringTokenizer, arrayList)) {
                            arrayList = null;
                        }
                    } else if (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (string2.equals("Zone")) {
                            if (stringTokenizer.countTokens() < 3) {
                                this.printVerbose("Invalid Zone line in file: " + file + ", line: " + string);
                                throw new IllegalArgumentException("Invalid Zone line");
                            }
                            arrayList = new ArrayList();
                            this.zones.put(stringTokenizer.nextToken(), arrayList);
                            if (this.parseZoneLine(stringTokenizer, arrayList)) {
                                arrayList = null;
                            }
                        } else {
                            arrayList = null;
                            if (string2.equals("Rule")) {
                                if (stringTokenizer.countTokens() < 9) {
                                    this.printVerbose("Invalid Rule line in file: " + file + ", line: " + string);
                                    throw new IllegalArgumentException("Invalid Rule line");
                                }
                                this.parseRuleLine(stringTokenizer);
                            } else if (string2.equals("Link")) {
                                if (stringTokenizer.countTokens() < 2) {
                                    this.printVerbose("Invalid Link line in file: " + file + ", line: " + string);
                                    throw new IllegalArgumentException("Invalid Link line");
                                }
                                String string3 = stringTokenizer.nextToken();
                                String string4 = stringTokenizer.nextToken();
                                this.links.put(string4, string3);
                            } else {
                                throw new IllegalArgumentException("Unknown line");
                            }
                        }
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new Exception("Failed while processing file '" + file + "' on line " + n + " '" + string + "'", exception);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    private void parseRuleLine(StringTokenizer stringTokenizer) {
        TzdbZoneRulesCompiler$TZDBRule tzdbZoneRulesCompiler$TZDBRule = new TzdbZoneRulesCompiler$TZDBRule(this);
        String string = stringTokenizer.nextToken();
        if (!this.rules.containsKey(string)) {
            this.rules.put(string, new ArrayList());
        }
        ((List)this.rules.get(string)).add(tzdbZoneRulesCompiler$TZDBRule);
        tzdbZoneRulesCompiler$TZDBRule.startYear = this.parseYear(stringTokenizer.nextToken(), 0);
        tzdbZoneRulesCompiler$TZDBRule.endYear = this.parseYear(stringTokenizer.nextToken(), tzdbZoneRulesCompiler$TZDBRule.startYear);
        if (tzdbZoneRulesCompiler$TZDBRule.startYear > tzdbZoneRulesCompiler$TZDBRule.endYear) {
            throw new IllegalArgumentException("Year order invalid: " + tzdbZoneRulesCompiler$TZDBRule.startYear + " > " + tzdbZoneRulesCompiler$TZDBRule.endYear);
        }
        this.parseOptional(stringTokenizer.nextToken());
        this.parseMonthDayTime(stringTokenizer, tzdbZoneRulesCompiler$TZDBRule);
        tzdbZoneRulesCompiler$TZDBRule.savingsAmount = this.parsePeriod(stringTokenizer.nextToken());
        tzdbZoneRulesCompiler$TZDBRule.text = this.parseOptional(stringTokenizer.nextToken());
    }

    private boolean parseZoneLine(StringTokenizer stringTokenizer, List list) {
        TzdbZoneRulesCompiler$TZDBZone tzdbZoneRulesCompiler$TZDBZone = new TzdbZoneRulesCompiler$TZDBZone(this);
        list.add(tzdbZoneRulesCompiler$TZDBZone);
        tzdbZoneRulesCompiler$TZDBZone.standardOffset = this.parseOffset(stringTokenizer.nextToken());
        String string = this.parseOptional(stringTokenizer.nextToken());
        if (string == null) {
            tzdbZoneRulesCompiler$TZDBZone.fixedSavingsSecs = 0;
            tzdbZoneRulesCompiler$TZDBZone.savingsRule = null;
        } else {
            try {
                tzdbZoneRulesCompiler$TZDBZone.fixedSavingsSecs = this.parsePeriod(string);
                tzdbZoneRulesCompiler$TZDBZone.savingsRule = null;
            }
            catch (Exception exception) {
                tzdbZoneRulesCompiler$TZDBZone.fixedSavingsSecs = null;
                tzdbZoneRulesCompiler$TZDBZone.savingsRule = string;
            }
        }
        tzdbZoneRulesCompiler$TZDBZone.text = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            tzdbZoneRulesCompiler$TZDBZone.year = Year.of(Integer.parseInt(stringTokenizer.nextToken()));
            if (stringTokenizer.hasMoreTokens()) {
                this.parseMonthDayTime(stringTokenizer, tzdbZoneRulesCompiler$TZDBZone);
            }
            return false;
        }
        return true;
    }

    private void parseMonthDayTime(StringTokenizer stringTokenizer, TzdbZoneRulesCompiler$TZDBMonthDayTime tzdbZoneRulesCompiler$TZDBMonthDayTime) {
        tzdbZoneRulesCompiler$TZDBMonthDayTime.month = this.parseMonth(stringTokenizer.nextToken());
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.startsWith("last")) {
                tzdbZoneRulesCompiler$TZDBMonthDayTime.dayOfMonth = -1;
                tzdbZoneRulesCompiler$TZDBMonthDayTime.dayOfWeek = this.parseDayOfWeek(string.substring(4));
                tzdbZoneRulesCompiler$TZDBMonthDayTime.adjustForwards = false;
            } else {
                int n = string.indexOf(">=");
                if (n > 0) {
                    tzdbZoneRulesCompiler$TZDBMonthDayTime.dayOfWeek = this.parseDayOfWeek(string.substring(0, n));
                    string = string.substring(n + 2);
                } else {
                    n = string.indexOf("<=");
                    if (n > 0) {
                        tzdbZoneRulesCompiler$TZDBMonthDayTime.dayOfWeek = this.parseDayOfWeek(string.substring(0, n));
                        tzdbZoneRulesCompiler$TZDBMonthDayTime.adjustForwards = false;
                        string = string.substring(n + 2);
                    }
                }
                tzdbZoneRulesCompiler$TZDBMonthDayTime.dayOfMonth = Integer.parseInt(string);
            }
            if (stringTokenizer.hasMoreTokens()) {
                LocalTime localTime;
                String string2 = stringTokenizer.nextToken();
                int n = this.parseSecs(string2);
                tzdbZoneRulesCompiler$TZDBMonthDayTime.time = localTime = (LocalTime)this.deduplicate(LocalTime.ofSecondOfDay(Jdk8Methods.floorMod(n, 86400)));
                tzdbZoneRulesCompiler$TZDBMonthDayTime.adjustDays = Jdk8Methods.floorDiv(n, 86400);
                tzdbZoneRulesCompiler$TZDBMonthDayTime.timeDefinition = this.parseTimeDefinition(string2.charAt(string2.length() - 1));
            }
        }
    }

    private int parseYear(String string, int n) {
        if (this.matches(string = string.toLowerCase(), "minimum")) {
            return -999999999;
        }
        if (this.matches(string, "maximum")) {
            return 999999999;
        }
        if (string.equals("only")) {
            return n;
        }
        return Integer.parseInt(string);
    }

    private Month parseMonth(String string) {
        string = string.toLowerCase();
        for (Month month : Month.values()) {
            if (!this.matches(string, month.name().toLowerCase())) continue;
            return month;
        }
        throw new IllegalArgumentException("Unknown month: " + string);
    }

    private DayOfWeek parseDayOfWeek(String string) {
        string = string.toLowerCase();
        for (DayOfWeek dayOfWeek : DayOfWeek.values()) {
            if (!this.matches(string, dayOfWeek.name().toLowerCase())) continue;
            return dayOfWeek;
        }
        throw new IllegalArgumentException("Unknown day-of-week: " + string);
    }

    private boolean matches(String string, String string2) {
        return string.startsWith(string2.substring(0, 3)) && string2.startsWith(string) && string.length() <= string2.length();
    }

    private String parseOptional(String string) {
        return string.equals("-") ? null : string;
    }

    private int parseSecs(String string) {
        ParsePosition parsePosition;
        TemporalAccessor temporalAccessor;
        if (string.equals("-")) {
            return 0;
        }
        int n = 0;
        if (string.startsWith("-")) {
            n = 1;
        }
        if ((temporalAccessor = TIME_PARSER.parseUnresolved(string, parsePosition = new ParsePosition(n))) == null || parsePosition.getErrorIndex() >= 0) {
            throw new IllegalArgumentException(string);
        }
        long l = temporalAccessor.getLong(ChronoField.HOUR_OF_DAY);
        Long l2 = temporalAccessor.isSupported(ChronoField.MINUTE_OF_HOUR) ? Long.valueOf(temporalAccessor.getLong(ChronoField.MINUTE_OF_HOUR)) : null;
        Long l3 = temporalAccessor.isSupported(ChronoField.SECOND_OF_MINUTE) ? Long.valueOf(temporalAccessor.getLong(ChronoField.SECOND_OF_MINUTE)) : null;
        int n2 = (int)(l * 60L * 60L + (l2 != null ? l2 : 0L) * 60L + (l3 != null ? l3 : 0L));
        if (n == 1) {
            n2 = -n2;
        }
        return n2;
    }

    private ZoneOffset parseOffset(String string) {
        int n = this.parseSecs(string);
        return ZoneOffset.ofTotalSeconds(n);
    }

    private int parsePeriod(String string) {
        return this.parseSecs(string);
    }

    private ZoneOffsetTransitionRule$TimeDefinition parseTimeDefinition(char c2) {
        switch (c2) {
            case 'S': 
            case 's': {
                return ZoneOffsetTransitionRule$TimeDefinition.STANDARD;
            }
            case 'G': 
            case 'U': 
            case 'Z': 
            case 'g': 
            case 'u': 
            case 'z': {
                return ZoneOffsetTransitionRule$TimeDefinition.UTC;
            }
        }
        return ZoneOffsetTransitionRule$TimeDefinition.WALL;
    }

    private void buildZoneRules() {
        Object object;
        Object object2;
        for (String string : this.zones.keySet()) {
            this.printVerbose("Building zone " + string);
            string = (String)this.deduplicate(string);
            object2 = (List)this.zones.get(string);
            object = new ZoneRulesBuilder();
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                TzdbZoneRulesCompiler$TZDBZone tzdbZoneRulesCompiler$TZDBZone = (TzdbZoneRulesCompiler$TZDBZone)object3.next();
                object = tzdbZoneRulesCompiler$TZDBZone.addToBuilder((ZoneRulesBuilder)object, this.rules);
            }
            object3 = ((ZoneRulesBuilder)object).toRules(string, this.deduplicateMap);
            this.builtZones.put(string, this.deduplicate(object3));
        }
        for (String string : this.links.keySet()) {
            string = (String)this.deduplicate(string);
            object2 = (String)this.links.get(string);
            this.printVerbose("Linking alias " + string + " to " + (String)object2);
            object = (ZoneRules)this.builtZones.get(object2);
            if (object == null) {
                object2 = (String)this.links.get(object2);
                this.printVerbose("Relinking alias " + string + " to " + (String)object2);
                object = (ZoneRules)this.builtZones.get(object2);
                if (object == null) {
                    throw new IllegalArgumentException("Alias '" + string + "' links to invalid zone '" + (String)object2 + "' for '" + this.version + "'");
                }
            }
            this.builtZones.put(string, object);
        }
        this.builtZones.remove("UTC");
        this.builtZones.remove("GMT");
        this.builtZones.remove("GMT0");
        this.builtZones.remove("GMT+0");
        this.builtZones.remove("GMT-0");
    }

    Object deduplicate(Object object) {
        if (!this.deduplicateMap.containsKey(object)) {
            this.deduplicateMap.put(object, object);
        }
        return this.deduplicateMap.get(object);
    }

    private void printVerbose(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }
}

