/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.zone;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import oz.threeten.bp.zone.Ser;
import oz.threeten.bp.zone.ZoneRules;
import oz.threeten.bp.zone.ZoneRulesException;

class TzdbZoneRulesProvider$Version {
    private final String versionId;
    private final String[] regionArray;
    private final short[] ruleIndices;
    private final AtomicReferenceArray ruleData;

    TzdbZoneRulesProvider$Version(String string, String[] stringArray, short[] sArray, AtomicReferenceArray atomicReferenceArray) {
        this.ruleData = atomicReferenceArray;
        this.versionId = string;
        this.regionArray = stringArray;
        this.ruleIndices = sArray;
    }

    ZoneRules getRules(String string) {
        int n = Arrays.binarySearch(this.regionArray, string);
        if (n < 0) {
            return null;
        }
        try {
            return this.createRule(this.ruleIndices[n]);
        }
        catch (Exception exception) {
            throw new ZoneRulesException("Invalid binary time-zone data: TZDB:" + string + ", version: " + this.versionId, exception);
        }
    }

    ZoneRules createRule(short s) {
        Object object = this.ruleData.get(s);
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            object = Ser.read(dataInputStream);
            this.ruleData.set(s, object);
        }
        return (ZoneRules)object;
    }

    public String toString() {
        return this.versionId;
    }

    static /* synthetic */ String access$000(TzdbZoneRulesProvider$Version tzdbZoneRulesProvider$Version) {
        return tzdbZoneRulesProvider$Version.versionId;
    }
}

