/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.zone;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Serializable;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Month;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.TemporalAdjusters;
import oz.threeten.bp.zone.Ser;
import oz.threeten.bp.zone.ZoneOffsetTransition;
import oz.threeten.bp.zone.ZoneOffsetTransitionRule$TimeDefinition;

public final class ZoneOffsetTransitionRule
implements Serializable {
    private static final long serialVersionUID = 6889046316657758795L;
    private static final int SECS_PER_DAY = 86400;
    private final Month month;
    private final byte dom;
    private final DayOfWeek dow;
    private final LocalTime time;
    private final int adjustDays;
    private final ZoneOffsetTransitionRule$TimeDefinition timeDefinition;
    private final ZoneOffset standardOffset;
    private final ZoneOffset offsetBefore;
    private final ZoneOffset offsetAfter;

    public static ZoneOffsetTransitionRule of(Month month, int n, DayOfWeek dayOfWeek, LocalTime localTime, boolean bl, ZoneOffsetTransitionRule$TimeDefinition zoneOffsetTransitionRule$TimeDefinition, ZoneOffset zoneOffset, ZoneOffset zoneOffset2, ZoneOffset zoneOffset3) {
        Jdk8Methods.requireNonNull(month, "month");
        Jdk8Methods.requireNonNull(localTime, "time");
        Jdk8Methods.requireNonNull((Object)zoneOffsetTransitionRule$TimeDefinition, "timeDefnition");
        Jdk8Methods.requireNonNull(zoneOffset, "standardOffset");
        Jdk8Methods.requireNonNull(zoneOffset2, "offsetBefore");
        Jdk8Methods.requireNonNull(zoneOffset3, "offsetAfter");
        if (n < -28 || n > 31 || n == 0) {
            throw new IllegalArgumentException("Day of month indicator must be between -28 and 31 inclusive excluding zero");
        }
        if (bl && !localTime.equals(LocalTime.MIDNIGHT)) {
            throw new IllegalArgumentException("Time must be midnight when end of day flag is true");
        }
        return new ZoneOffsetTransitionRule(month, n, dayOfWeek, localTime, bl ? 1 : 0, zoneOffsetTransitionRule$TimeDefinition, zoneOffset, zoneOffset2, zoneOffset3);
    }

    ZoneOffsetTransitionRule(Month month, int n, DayOfWeek dayOfWeek, LocalTime localTime, int n2, ZoneOffsetTransitionRule$TimeDefinition zoneOffsetTransitionRule$TimeDefinition, ZoneOffset zoneOffset, ZoneOffset zoneOffset2, ZoneOffset zoneOffset3) {
        this.month = month;
        this.dom = (byte)n;
        this.dow = dayOfWeek;
        this.time = localTime;
        this.adjustDays = n2;
        this.timeDefinition = zoneOffsetTransitionRule$TimeDefinition;
        this.standardOffset = zoneOffset;
        this.offsetBefore = zoneOffset2;
        this.offsetAfter = zoneOffset3;
    }

    private Object writeReplace() {
        return new Ser(3, this);
    }

    void writeExternal(DataOutput dataOutput) {
        int n = this.time.toSecondOfDay() + this.adjustDays * 86400;
        int n2 = this.standardOffset.getTotalSeconds();
        int n3 = this.offsetBefore.getTotalSeconds() - n2;
        int n4 = this.offsetAfter.getTotalSeconds() - n2;
        int n5 = n % 3600 == 0 && n <= 86400 ? (n == 86400 ? 24 : this.time.getHour()) : 31;
        int n6 = n2 % 900 == 0 ? n2 / 900 + 128 : 255;
        int n7 = n3 == 0 || n3 == 1800 || n3 == 3600 ? n3 / 1800 : 3;
        int n8 = n4 == 0 || n4 == 1800 || n4 == 3600 ? n4 / 1800 : 3;
        int n9 = this.dow == null ? 0 : this.dow.getValue();
        int n10 = (this.month.getValue() << 28) + (this.dom + 32 << 22) + (n9 << 19) + (n5 << 14) + (this.timeDefinition.ordinal() << 12) + (n6 << 4) + (n7 << 2) + n8;
        dataOutput.writeInt(n10);
        if (n5 == 31) {
            dataOutput.writeInt(n);
        }
        if (n6 == 255) {
            dataOutput.writeInt(n2);
        }
        if (n7 == 3) {
            dataOutput.writeInt(this.offsetBefore.getTotalSeconds());
        }
        if (n8 == 3) {
            dataOutput.writeInt(this.offsetAfter.getTotalSeconds());
        }
    }

    static ZoneOffsetTransitionRule readExternal(DataInput dataInput) {
        ZoneOffset zoneOffset;
        int n = dataInput.readInt();
        Month month = Month.of(n >>> 28);
        int n2 = ((n & 0xFC00000) >>> 22) - 32;
        int n3 = (n & 0x380000) >>> 19;
        DayOfWeek dayOfWeek = n3 == 0 ? null : DayOfWeek.of(n3);
        int n4 = (n & 0x7C000) >>> 14;
        ZoneOffsetTransitionRule$TimeDefinition zoneOffsetTransitionRule$TimeDefinition = ZoneOffsetTransitionRule$TimeDefinition.values()[(n & 0x3000) >>> 12];
        int n5 = (n & 0xFF0) >>> 4;
        int n6 = (n & 0xC) >>> 2;
        int n7 = n & 3;
        int n8 = n4 == 31 ? dataInput.readInt() : n4 * 3600;
        ZoneOffset zoneOffset2 = n5 == 255 ? ZoneOffset.ofTotalSeconds(dataInput.readInt()) : ZoneOffset.ofTotalSeconds((n5 - 128) * 900);
        ZoneOffset zoneOffset3 = n6 == 3 ? ZoneOffset.ofTotalSeconds(dataInput.readInt()) : ZoneOffset.ofTotalSeconds(zoneOffset2.getTotalSeconds() + n6 * 1800);
        ZoneOffset zoneOffset4 = zoneOffset = n7 == 3 ? ZoneOffset.ofTotalSeconds(dataInput.readInt()) : ZoneOffset.ofTotalSeconds(zoneOffset2.getTotalSeconds() + n7 * 1800);
        if (n2 < -28 || n2 > 31 || n2 == 0) {
            throw new IllegalArgumentException("Day of month indicator must be between -28 and 31 inclusive excluding zero");
        }
        LocalTime localTime = LocalTime.ofSecondOfDay(Jdk8Methods.floorMod(n8, 86400));
        int n9 = Jdk8Methods.floorDiv(n8, 86400);
        return new ZoneOffsetTransitionRule(month, n2, dayOfWeek, localTime, n9, zoneOffsetTransitionRule$TimeDefinition, zoneOffset2, zoneOffset3, zoneOffset);
    }

    public Month getMonth() {
        return this.month;
    }

    public int getDayOfMonthIndicator() {
        return this.dom;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dow;
    }

    public LocalTime getLocalTime() {
        return this.time;
    }

    public boolean isMidnightEndOfDay() {
        return this.adjustDays == 1 && this.time.equals(LocalTime.MIDNIGHT);
    }

    public ZoneOffsetTransitionRule$TimeDefinition getTimeDefinition() {
        return this.timeDefinition;
    }

    public ZoneOffset getStandardOffset() {
        return this.standardOffset;
    }

    public ZoneOffset getOffsetBefore() {
        return this.offsetBefore;
    }

    public ZoneOffset getOffsetAfter() {
        return this.offsetAfter;
    }

    public ZoneOffsetTransition createTransition(int n) {
        LocalDate localDate;
        if (this.dom < 0) {
            localDate = LocalDate.of(n, this.month, this.month.length(IsoChronology.INSTANCE.isLeapYear(n)) + 1 + this.dom);
            if (this.dow != null) {
                localDate = localDate.with(TemporalAdjusters.previousOrSame(this.dow));
            }
        } else {
            localDate = LocalDate.of(n, this.month, (int)this.dom);
            if (this.dow != null) {
                localDate = localDate.with(TemporalAdjusters.nextOrSame(this.dow));
            }
        }
        LocalDateTime localDateTime = LocalDateTime.of(localDate.plusDays(this.adjustDays), this.time);
        LocalDateTime localDateTime2 = this.timeDefinition.createDateTime(localDateTime, this.standardOffset, this.offsetBefore);
        return new ZoneOffsetTransition(localDateTime2, this.offsetBefore, this.offsetAfter);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ZoneOffsetTransitionRule) {
            ZoneOffsetTransitionRule zoneOffsetTransitionRule = (ZoneOffsetTransitionRule)object;
            return this.month == zoneOffsetTransitionRule.month && this.dom == zoneOffsetTransitionRule.dom && this.dow == zoneOffsetTransitionRule.dow && this.timeDefinition == zoneOffsetTransitionRule.timeDefinition && this.adjustDays == zoneOffsetTransitionRule.adjustDays && this.time.equals(zoneOffsetTransitionRule.time) && this.standardOffset.equals(zoneOffsetTransitionRule.standardOffset) && this.offsetBefore.equals(zoneOffsetTransitionRule.offsetBefore) && this.offsetAfter.equals(zoneOffsetTransitionRule.offsetAfter);
        }
        return false;
    }

    public int hashCode() {
        int n = (this.time.toSecondOfDay() + this.adjustDays << 15) + (this.month.ordinal() << 11) + (this.dom + 32 << 5) + ((this.dow == null ? 7 : this.dow.ordinal()) << 2) + this.timeDefinition.ordinal();
        return n ^ this.standardOffset.hashCode() ^ this.offsetBefore.hashCode() ^ this.offsetAfter.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TransitionRule[").append(this.offsetBefore.compareTo(this.offsetAfter) > 0 ? "Gap " : "Overlap ").append(this.offsetBefore).append(" to ").append(this.offsetAfter).append(", ");
        if (this.dow != null) {
            if (this.dom == -1) {
                stringBuilder.append(this.dow.name()).append(" on or before last day of ").append(this.month.name());
            } else if (this.dom < 0) {
                stringBuilder.append(this.dow.name()).append(" on or before last day minus ").append(-this.dom - 1).append(" of ").append(this.month.name());
            } else {
                stringBuilder.append(this.dow.name()).append(" on or after ").append(this.month.name()).append(' ').append(this.dom);
            }
        } else {
            stringBuilder.append(this.month.name()).append(' ').append(this.dom);
        }
        stringBuilder.append(" at ");
        if (this.adjustDays == 0) {
            stringBuilder.append(this.time);
        } else {
            long l = this.time.toSecondOfDay() / 60 + this.adjustDays * 24 * 60;
            this.appendZeroPad(stringBuilder, Jdk8Methods.floorDiv(l, 60L));
            stringBuilder.append(':');
            this.appendZeroPad(stringBuilder, Jdk8Methods.floorMod(l, 60));
        }
        stringBuilder.append(" ").append((Object)this.timeDefinition).append(", standard offset ").append(this.standardOffset).append(']');
        return stringBuilder.toString();
    }

    private void appendZeroPad(StringBuilder stringBuilder, long l) {
        if (l < 10L) {
            stringBuilder.append(0);
        }
        stringBuilder.append(l);
    }
}

