/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.zone;

import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.LocalDate;
import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Month;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.chrono.IsoChronology;
import oz.threeten.bp.temporal.TemporalAdjusters;
import oz.threeten.bp.zone.ZoneOffsetTransition;
import oz.threeten.bp.zone.ZoneOffsetTransitionRule;
import oz.threeten.bp.zone.ZoneOffsetTransitionRule$TimeDefinition;
import oz.threeten.bp.zone.ZoneRulesBuilder;

class ZoneRulesBuilder$TZRule
implements Comparable {
    private int year;
    private Month month;
    private int dayOfMonthIndicator;
    private DayOfWeek dayOfWeek;
    private LocalTime time;
    private int adjustDays;
    private ZoneOffsetTransitionRule$TimeDefinition timeDefinition;
    private int savingAmountSecs;
    final /* synthetic */ ZoneRulesBuilder this$0;

    ZoneRulesBuilder$TZRule(ZoneRulesBuilder zoneRulesBuilder, int n, Month month, int n2, DayOfWeek dayOfWeek, LocalTime localTime, int n3, ZoneOffsetTransitionRule$TimeDefinition zoneOffsetTransitionRule$TimeDefinition, int n4) {
        this.this$0 = zoneRulesBuilder;
        this.year = n;
        this.month = month;
        this.dayOfMonthIndicator = n2;
        this.dayOfWeek = dayOfWeek;
        this.time = localTime;
        this.adjustDays = n3;
        this.timeDefinition = zoneOffsetTransitionRule$TimeDefinition;
        this.savingAmountSecs = n4;
    }

    ZoneOffsetTransition toTransition(ZoneOffset zoneOffset, int n) {
        LocalDate localDate = this.toLocalDate();
        localDate = (LocalDate)this.this$0.deduplicate(localDate);
        LocalDateTime localDateTime = (LocalDateTime)this.this$0.deduplicate(LocalDateTime.of(localDate.plusDays(this.adjustDays), this.time));
        ZoneOffset zoneOffset2 = (ZoneOffset)this.this$0.deduplicate(ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + n));
        LocalDateTime localDateTime2 = (LocalDateTime)this.this$0.deduplicate(this.timeDefinition.createDateTime(localDateTime, zoneOffset, zoneOffset2));
        ZoneOffset zoneOffset3 = (ZoneOffset)this.this$0.deduplicate(ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + this.savingAmountSecs));
        return new ZoneOffsetTransition(localDateTime2, zoneOffset2, zoneOffset3);
    }

    ZoneOffsetTransitionRule toTransitionRule(ZoneOffset zoneOffset, int n) {
        if (this.dayOfMonthIndicator < 0 && this.month != Month.FEBRUARY) {
            this.dayOfMonthIndicator = this.month.maxLength() - 6;
        }
        ZoneOffsetTransition zoneOffsetTransition = this.toTransition(zoneOffset, n);
        return new ZoneOffsetTransitionRule(this.month, this.dayOfMonthIndicator, this.dayOfWeek, this.time, this.adjustDays, this.timeDefinition, zoneOffset, zoneOffsetTransition.getOffsetBefore(), zoneOffsetTransition.getOffsetAfter());
    }

    public int compareTo(ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule) {
        long l;
        int n = this.year - zoneRulesBuilder$TZRule.year;
        int n2 = n = n == 0 ? this.month.compareTo(zoneRulesBuilder$TZRule.month) : n;
        if (n == 0) {
            LocalDate localDate = this.toLocalDate();
            LocalDate localDate2 = zoneRulesBuilder$TZRule.toLocalDate();
            n = localDate.compareTo(localDate2);
        }
        if (n != 0) {
            return n;
        }
        long l2 = this.time.toSecondOfDay() + this.adjustDays * 86400;
        return l2 < (l = (long)(zoneRulesBuilder$TZRule.time.toSecondOfDay() + zoneRulesBuilder$TZRule.adjustDays * 86400)) ? -1 : (l2 > l ? 1 : 0);
    }

    private LocalDate toLocalDate() {
        LocalDate localDate;
        if (this.dayOfMonthIndicator < 0) {
            int n = this.month.length(IsoChronology.INSTANCE.isLeapYear(this.year));
            localDate = LocalDate.of(this.year, this.month, n + 1 + this.dayOfMonthIndicator);
            if (this.dayOfWeek != null) {
                localDate = localDate.with(TemporalAdjusters.previousOrSame(this.dayOfWeek));
            }
        } else {
            localDate = LocalDate.of(this.year, this.month, this.dayOfMonthIndicator);
            if (this.dayOfWeek != null) {
                localDate = localDate.with(TemporalAdjusters.nextOrSame(this.dayOfWeek));
            }
        }
        return localDate;
    }

    static /* synthetic */ int access$300(ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule) {
        return zoneRulesBuilder$TZRule.savingAmountSecs;
    }

    static /* synthetic */ int access$500(ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule) {
        return zoneRulesBuilder$TZRule.year;
    }

    static /* synthetic */ Month access$600(ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule) {
        return zoneRulesBuilder$TZRule.month;
    }

    static /* synthetic */ int access$700(ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule) {
        return zoneRulesBuilder$TZRule.dayOfMonthIndicator;
    }

    static /* synthetic */ DayOfWeek access$800(ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule) {
        return zoneRulesBuilder$TZRule.dayOfWeek;
    }

    static /* synthetic */ LocalTime access$900(ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule) {
        return zoneRulesBuilder$TZRule.time;
    }

    static /* synthetic */ int access$1000(ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule) {
        return zoneRulesBuilder$TZRule.adjustDays;
    }

    static /* synthetic */ ZoneOffsetTransitionRule$TimeDefinition access$1100(ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule) {
        return zoneRulesBuilder$TZRule.timeDefinition;
    }

    static /* synthetic */ int access$502(ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule, int n) {
        zoneRulesBuilder$TZRule.year = n;
        return zoneRulesBuilder$TZRule.year;
    }
}

