/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.zone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Month;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.zone.ZoneOffsetTransitionRule$TimeDefinition;
import oz.threeten.bp.zone.ZoneRulesBuilder;
import oz.threeten.bp.zone.ZoneRulesBuilder$TZRule;

class ZoneRulesBuilder$TZWindow {
    private final ZoneOffset standardOffset;
    private final LocalDateTime windowEnd;
    private final ZoneOffsetTransitionRule$TimeDefinition timeDefinition;
    private Integer fixedSavingAmountSecs;
    private List ruleList = new ArrayList();
    private int maxLastRuleStartYear = -999999999;
    private List lastRuleList = new ArrayList();
    final /* synthetic */ ZoneRulesBuilder this$0;

    ZoneRulesBuilder$TZWindow(ZoneRulesBuilder zoneRulesBuilder, ZoneOffset zoneOffset, LocalDateTime localDateTime, ZoneOffsetTransitionRule$TimeDefinition zoneOffsetTransitionRule$TimeDefinition) {
        this.this$0 = zoneRulesBuilder;
        this.windowEnd = localDateTime;
        this.timeDefinition = zoneOffsetTransitionRule$TimeDefinition;
        this.standardOffset = zoneOffset;
    }

    void setFixedSavings(int n) {
        if (this.ruleList.size() > 0 || this.lastRuleList.size() > 0) {
            throw new IllegalStateException("Window has DST rules, so cannot have fixed savings");
        }
        this.fixedSavingAmountSecs = n;
    }

    void addRule(int n, int n2, Month month, int n3, DayOfWeek dayOfWeek, LocalTime localTime, int n4, ZoneOffsetTransitionRule$TimeDefinition zoneOffsetTransitionRule$TimeDefinition, int n5) {
        if (this.fixedSavingAmountSecs != null) {
            throw new IllegalStateException("Window has a fixed DST saving, so cannot have DST rules");
        }
        if (this.ruleList.size() >= 2000) {
            throw new IllegalStateException("Window has reached the maximum number of allowed rules");
        }
        boolean bl = false;
        if (n2 == 999999999) {
            bl = true;
            n2 = n;
        }
        for (int j = n; j <= n2; ++j) {
            ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule = new ZoneRulesBuilder$TZRule(this.this$0, j, month, n3, dayOfWeek, localTime, n4, zoneOffsetTransitionRule$TimeDefinition, n5);
            if (bl) {
                this.lastRuleList.add(zoneRulesBuilder$TZRule);
                this.maxLastRuleStartYear = Math.max(n, this.maxLastRuleStartYear);
                continue;
            }
            this.ruleList.add(zoneRulesBuilder$TZRule);
        }
    }

    void validateWindowOrder(ZoneRulesBuilder$TZWindow zoneRulesBuilder$TZWindow) {
        if (this.windowEnd.isBefore(zoneRulesBuilder$TZWindow.windowEnd)) {
            throw new IllegalStateException("Windows must be added in date-time order: " + this.windowEnd + " < " + zoneRulesBuilder$TZWindow.windowEnd);
        }
    }

    void tidy(int n) {
        if (this.lastRuleList.size() == 1) {
            throw new IllegalStateException("Cannot have only one rule defined as being forever");
        }
        if (this.windowEnd.equals(LocalDateTime.MAX)) {
            this.maxLastRuleStartYear = Math.max(this.maxLastRuleStartYear, n) + 1;
            for (ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule : this.lastRuleList) {
                this.addRule(ZoneRulesBuilder$TZRule.access$500(zoneRulesBuilder$TZRule), this.maxLastRuleStartYear, ZoneRulesBuilder$TZRule.access$600(zoneRulesBuilder$TZRule), ZoneRulesBuilder$TZRule.access$700(zoneRulesBuilder$TZRule), ZoneRulesBuilder$TZRule.access$800(zoneRulesBuilder$TZRule), ZoneRulesBuilder$TZRule.access$900(zoneRulesBuilder$TZRule), ZoneRulesBuilder$TZRule.access$1000(zoneRulesBuilder$TZRule), ZoneRulesBuilder$TZRule.access$1100(zoneRulesBuilder$TZRule), ZoneRulesBuilder$TZRule.access$300(zoneRulesBuilder$TZRule));
                ZoneRulesBuilder$TZRule.access$502(zoneRulesBuilder$TZRule, this.maxLastRuleStartYear + 1);
            }
            if (this.maxLastRuleStartYear == 999999999) {
                this.lastRuleList.clear();
            } else {
                ++this.maxLastRuleStartYear;
            }
        } else {
            int n2 = this.windowEnd.getYear();
            for (ZoneRulesBuilder$TZRule zoneRulesBuilder$TZRule : this.lastRuleList) {
                this.addRule(ZoneRulesBuilder$TZRule.access$500(zoneRulesBuilder$TZRule), n2 + 1, ZoneRulesBuilder$TZRule.access$600(zoneRulesBuilder$TZRule), ZoneRulesBuilder$TZRule.access$700(zoneRulesBuilder$TZRule), ZoneRulesBuilder$TZRule.access$800(zoneRulesBuilder$TZRule), ZoneRulesBuilder$TZRule.access$900(zoneRulesBuilder$TZRule), ZoneRulesBuilder$TZRule.access$1000(zoneRulesBuilder$TZRule), ZoneRulesBuilder$TZRule.access$1100(zoneRulesBuilder$TZRule), ZoneRulesBuilder$TZRule.access$300(zoneRulesBuilder$TZRule));
            }
            this.lastRuleList.clear();
            this.maxLastRuleStartYear = 999999999;
        }
        Collections.sort(this.ruleList);
        Collections.sort(this.lastRuleList);
        if (this.ruleList.size() == 0 && this.fixedSavingAmountSecs == null) {
            this.fixedSavingAmountSecs = 0;
        }
    }

    boolean isSingleWindowStandardOffset() {
        return this.windowEnd.equals(LocalDateTime.MAX) && this.timeDefinition == ZoneOffsetTransitionRule$TimeDefinition.WALL && this.fixedSavingAmountSecs == null && this.lastRuleList.isEmpty() && this.ruleList.isEmpty();
    }

    ZoneOffset createWallOffset(int n) {
        return ZoneOffset.ofTotalSeconds(this.standardOffset.getTotalSeconds() + n);
    }

    long createDateTimeEpochSecond(int n) {
        ZoneOffset zoneOffset = this.createWallOffset(n);
        LocalDateTime localDateTime = this.timeDefinition.createDateTime(this.windowEnd, this.standardOffset, zoneOffset);
        return localDateTime.toEpochSecond(zoneOffset);
    }

    static /* synthetic */ ZoneOffset access$000(ZoneRulesBuilder$TZWindow zoneRulesBuilder$TZWindow) {
        return zoneRulesBuilder$TZWindow.standardOffset;
    }

    static /* synthetic */ Integer access$100(ZoneRulesBuilder$TZWindow zoneRulesBuilder$TZWindow) {
        return zoneRulesBuilder$TZWindow.fixedSavingAmountSecs;
    }

    static /* synthetic */ List access$200(ZoneRulesBuilder$TZWindow zoneRulesBuilder$TZWindow) {
        return zoneRulesBuilder$TZWindow.ruleList;
    }

    static /* synthetic */ List access$400(ZoneRulesBuilder$TZWindow zoneRulesBuilder$TZWindow) {
        return zoneRulesBuilder$TZWindow.lastRuleList;
    }
}

