/*
 * Decompiled with CFR 0.152.
 */
package oz.threeten.bp.zone;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oz.threeten.bp.DayOfWeek;
import oz.threeten.bp.LocalDateTime;
import oz.threeten.bp.LocalTime;
import oz.threeten.bp.Month;
import oz.threeten.bp.ZoneOffset;
import oz.threeten.bp.jdk8.Jdk8Methods;
import oz.threeten.bp.temporal.ChronoField;
import oz.threeten.bp.zone.StandardZoneRules;
import oz.threeten.bp.zone.ZoneOffsetTransition;
import oz.threeten.bp.zone.ZoneOffsetTransitionRule;
import oz.threeten.bp.zone.ZoneOffsetTransitionRule$TimeDefinition;
import oz.threeten.bp.zone.ZoneRules;
import oz.threeten.bp.zone.ZoneRulesBuilder$TZRule;
import oz.threeten.bp.zone.ZoneRulesBuilder$TZWindow;

class ZoneRulesBuilder {
    private List windowList = new ArrayList();
    private Map deduplicateMap;

    public ZoneRulesBuilder addWindow(ZoneOffset zoneOffset, LocalDateTime localDateTime, ZoneOffsetTransitionRule$TimeDefinition zoneOffsetTransitionRule$TimeDefinition) {
        Jdk8Methods.requireNonNull(zoneOffset, "standardOffset");
        Jdk8Methods.requireNonNull(localDateTime, "until");
        Jdk8Methods.requireNonNull((Object)zoneOffsetTransitionRule$TimeDefinition, "untilDefinition");
        ZoneRulesBuilder$TZWindow zoneRulesBuilder$TZWindow = new ZoneRulesBuilder$TZWindow(this, zoneOffset, localDateTime, zoneOffsetTransitionRule$TimeDefinition);
        if (this.windowList.size() > 0) {
            ZoneRulesBuilder$TZWindow zoneRulesBuilder$TZWindow2 = (ZoneRulesBuilder$TZWindow)this.windowList.get(this.windowList.size() - 1);
            zoneRulesBuilder$TZWindow.validateWindowOrder(zoneRulesBuilder$TZWindow2);
        }
        this.windowList.add(zoneRulesBuilder$TZWindow);
        return this;
    }

    public ZoneRulesBuilder addWindowForever(ZoneOffset zoneOffset) {
        return this.addWindow(zoneOffset, LocalDateTime.MAX, ZoneOffsetTransitionRule$TimeDefinition.WALL);
    }

    public ZoneRulesBuilder setFixedSavingsToWindow(int n) {
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("Must add a window before setting the fixed savings");
        }
        ZoneRulesBuilder$TZWindow zoneRulesBuilder$TZWindow = (ZoneRulesBuilder$TZWindow)this.windowList.get(this.windowList.size() - 1);
        zoneRulesBuilder$TZWindow.setFixedSavings(n);
        return this;
    }

    public ZoneRulesBuilder addRuleToWindow(LocalDateTime localDateTime, ZoneOffsetTransitionRule$TimeDefinition zoneOffsetTransitionRule$TimeDefinition, int n) {
        Jdk8Methods.requireNonNull(localDateTime, "transitionDateTime");
        return this.addRuleToWindow(localDateTime.getYear(), localDateTime.getYear(), localDateTime.getMonth(), localDateTime.getDayOfMonth(), null, localDateTime.toLocalTime(), false, zoneOffsetTransitionRule$TimeDefinition, n);
    }

    public ZoneRulesBuilder addRuleToWindow(int n, Month month, int n2, LocalTime localTime, boolean bl, ZoneOffsetTransitionRule$TimeDefinition zoneOffsetTransitionRule$TimeDefinition, int n3) {
        return this.addRuleToWindow(n, n, month, n2, null, localTime, bl, zoneOffsetTransitionRule$TimeDefinition, n3);
    }

    public ZoneRulesBuilder addRuleToWindow(int n, int n2, Month month, int n3, DayOfWeek dayOfWeek, LocalTime localTime, boolean bl, ZoneOffsetTransitionRule$TimeDefinition zoneOffsetTransitionRule$TimeDefinition, int n4) {
        Jdk8Methods.requireNonNull(month, "month");
        Jdk8Methods.requireNonNull(localTime, "time");
        Jdk8Methods.requireNonNull((Object)zoneOffsetTransitionRule$TimeDefinition, "timeDefinition");
        ChronoField.YEAR.checkValidValue(n);
        ChronoField.YEAR.checkValidValue(n2);
        if (n3 < -28 || n3 > 31 || n3 == 0) {
            throw new IllegalArgumentException("Day of month indicator must be between -28 and 31 inclusive excluding zero");
        }
        if (bl && !localTime.equals(LocalTime.MIDNIGHT)) {
            throw new IllegalArgumentException("Time must be midnight when end of day flag is true");
        }
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("Must add a window before adding a rule");
        }
        ZoneRulesBuilder$TZWindow zoneRulesBuilder$TZWindow = (ZoneRulesBuilder$TZWindow)this.windowList.get(this.windowList.size() - 1);
        zoneRulesBuilder$TZWindow.addRule(n, n2, month, n3, dayOfWeek, localTime, bl ? 1 : 0, zoneOffsetTransitionRule$TimeDefinition, n4);
        return this;
    }

    ZoneRulesBuilder addRuleToWindow(int n, int n2, Month month, int n3, DayOfWeek dayOfWeek, LocalTime localTime, int n4, ZoneOffsetTransitionRule$TimeDefinition zoneOffsetTransitionRule$TimeDefinition, int n5) {
        Jdk8Methods.requireNonNull(month, "month");
        Jdk8Methods.requireNonNull((Object)zoneOffsetTransitionRule$TimeDefinition, "timeDefinition");
        ChronoField.YEAR.checkValidValue(n);
        ChronoField.YEAR.checkValidValue(n2);
        if (n3 < -28 || n3 > 31 || n3 == 0) {
            throw new IllegalArgumentException("Day of month indicator must be between -28 and 31 inclusive excluding zero");
        }
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("Must add a window before adding a rule");
        }
        ZoneRulesBuilder$TZWindow zoneRulesBuilder$TZWindow = (ZoneRulesBuilder$TZWindow)this.windowList.get(this.windowList.size() - 1);
        zoneRulesBuilder$TZWindow.addRule(n, n2, month, n3, dayOfWeek, localTime, n4, zoneOffsetTransitionRule$TimeDefinition, n5);
        return this;
    }

    public ZoneRules toRules(String string) {
        return this.toRules(string, new HashMap());
    }

    ZoneRules toRules(String string, Map map) {
        Jdk8Methods.requireNonNull(string, "zoneId");
        this.deduplicateMap = map;
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("No windows have been added to the builder");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(4);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(256);
        ArrayList<Serializable> arrayList3 = new ArrayList<Serializable>(2);
        ZoneRulesBuilder$TZWindow zoneRulesBuilder$TZWindow = (ZoneRulesBuilder$TZWindow)this.windowList.get(0);
        ZoneOffset zoneOffset = ZoneRulesBuilder$TZWindow.access$000(zoneRulesBuilder$TZWindow);
        int n = 0;
        if (ZoneRulesBuilder$TZWindow.access$100(zoneRulesBuilder$TZWindow) != null) {
            n = ZoneRulesBuilder$TZWindow.access$100(zoneRulesBuilder$TZWindow);
        }
        ZoneOffset zoneOffset2 = (ZoneOffset)this.deduplicate(ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + n));
        LocalDateTime localDateTime = (LocalDateTime)this.deduplicate(LocalDateTime.of(-999999999, 1, 1, 0, 0));
        ZoneOffset zoneOffset3 = zoneOffset2;
        for (ZoneRulesBuilder$TZWindow zoneRulesBuilder$TZWindow2 : this.windowList) {
            Serializable serializable;
            Iterator iterator;
            Comparable comparable2;
            Object object;
            zoneRulesBuilder$TZWindow2.tidy(localDateTime.getYear());
            Integer n2 = ZoneRulesBuilder$TZWindow.access$100(zoneRulesBuilder$TZWindow2);
            if (n2 == null) {
                n2 = 0;
                object = ZoneRulesBuilder$TZWindow.access$200(zoneRulesBuilder$TZWindow2).iterator();
                while (object.hasNext() && ((ZoneOffsetTransition)(comparable2 = ((ZoneRulesBuilder$TZRule)((Object)(iterator = (ZoneRulesBuilder$TZRule)object.next()))).toTransition(zoneOffset, n))).toEpochSecond() <= localDateTime.toEpochSecond(zoneOffset3)) {
                    n2 = ZoneRulesBuilder$TZRule.access$300((ZoneRulesBuilder$TZRule)((Object)iterator));
                }
            }
            if (!zoneOffset.equals(ZoneRulesBuilder$TZWindow.access$000(zoneRulesBuilder$TZWindow2))) {
                arrayList.add(this.deduplicate(new ZoneOffsetTransition(LocalDateTime.ofEpochSecond(localDateTime.toEpochSecond(zoneOffset3), 0, zoneOffset), zoneOffset, ZoneRulesBuilder$TZWindow.access$000(zoneRulesBuilder$TZWindow2))));
                zoneOffset = (ZoneOffset)this.deduplicate(ZoneRulesBuilder$TZWindow.access$000(zoneRulesBuilder$TZWindow2));
            }
            if (!zoneOffset3.equals(object = (ZoneOffset)this.deduplicate(ZoneOffset.ofTotalSeconds(zoneOffset.getTotalSeconds() + n2)))) {
                iterator = (ZoneOffsetTransition)this.deduplicate(new ZoneOffsetTransition(localDateTime, zoneOffset3, (ZoneOffset)object));
                arrayList2.add(iterator);
            }
            n = n2;
            for (Comparable comparable2 : ZoneRulesBuilder$TZWindow.access$200(zoneRulesBuilder$TZWindow2)) {
                serializable = (ZoneOffsetTransition)this.deduplicate(((ZoneRulesBuilder$TZRule)comparable2).toTransition(zoneOffset, n));
                if (((ZoneOffsetTransition)serializable).toEpochSecond() < localDateTime.toEpochSecond(zoneOffset3) || ((ZoneOffsetTransition)serializable).toEpochSecond() >= zoneRulesBuilder$TZWindow2.createDateTimeEpochSecond(n) || ((ZoneOffsetTransition)serializable).getOffsetBefore().equals(((ZoneOffsetTransition)serializable).getOffsetAfter())) continue;
                arrayList2.add(serializable);
                n = ZoneRulesBuilder$TZRule.access$300((ZoneRulesBuilder$TZRule)comparable2);
            }
            iterator = ZoneRulesBuilder$TZWindow.access$400(zoneRulesBuilder$TZWindow2).iterator();
            while (iterator.hasNext()) {
                comparable2 = (ZoneRulesBuilder$TZRule)iterator.next();
                serializable = (ZoneOffsetTransitionRule)this.deduplicate(((ZoneRulesBuilder$TZRule)comparable2).toTransitionRule(zoneOffset, n));
                arrayList3.add(serializable);
                n = ZoneRulesBuilder$TZRule.access$300((ZoneRulesBuilder$TZRule)comparable2);
            }
            zoneOffset3 = (ZoneOffset)this.deduplicate(zoneRulesBuilder$TZWindow2.createWallOffset(n));
            localDateTime = (LocalDateTime)this.deduplicate(LocalDateTime.ofEpochSecond(zoneRulesBuilder$TZWindow2.createDateTimeEpochSecond(n), 0, zoneOffset3));
        }
        return new StandardZoneRules(ZoneRulesBuilder$TZWindow.access$000(zoneRulesBuilder$TZWindow), zoneOffset2, arrayList, arrayList2, arrayList3);
    }

    Object deduplicate(Object object) {
        if (!this.deduplicateMap.containsKey(object)) {
            this.deduplicateMap.put(object, object);
        }
        return this.deduplicateMap.get(object);
    }
}

