/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode;

import android.graphics.Bitmap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.EncodeHintType;
import oz.util.barcode.WriterException;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.datamatrix.DataMatrixWriter;
import oz.util.barcode.datamatrix.encoder.SymbolShapeHint;
import oz.util.barcode.pdf417.PDF417Writer;
import oz.util.barcode.pdf417.encoder.Dimensions;
import oz.util.barcode.qrcode.QRCodeWriter;
import oz.util.barcode.qrcode.decoder.ErrorCorrectionLevel;

public class OZZXBarcodeWriter {
    public byte[] createQRCode(String string, int n, int n2, boolean bl, int n3, int n4) {
        byte[] byArray = null;
        QRCodeWriter qRCodeWriter = new QRCodeWriter();
        EnumMap<EncodeHintType, Object> enumMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        enumMap.put(EncodeHintType.MARGIN, Integer.valueOf(n4));
        if (!bl) {
            enumMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        }
        switch (n3) {
            case 0: {
                enumMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.L);
                break;
            }
            case 1: {
                enumMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.M);
                break;
            }
            case 2: {
                enumMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.Q);
                break;
            }
            case 3: {
                enumMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.H);
            }
        }
        BitMatrix bitMatrix = null;
        try {
            bitMatrix = qRCodeWriter.encode(string, BarcodeFormat.QR_CODE, n, n2, enumMap);
            Bitmap bitmap = this.convertBitMatrixToBitmap(bitMatrix);
            byArray = this.convertBitmapToByteArray(bitmap);
        }
        catch (WriterException writerException) {
            byArray = "".getBytes();
            writerException.printStackTrace();
        }
        return byArray;
    }

    public byte[] createDataMatrix(String string, int n, int n2, boolean bl, int n3, int n4, boolean bl2) {
        byte[] byArray = null;
        DataMatrixWriter dataMatrixWriter = new DataMatrixWriter();
        EnumMap<EncodeHintType, Object> enumMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        enumMap.put(EncodeHintType.MARGIN, Integer.valueOf(n3));
        if (!bl) {
            enumMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        }
        enumMap.put(EncodeHintType.GS1_FORMAT, Boolean.valueOf(bl2));
        enumMap.put(EncodeHintType.DATA_MATRIX_SHAPE, (Object)SymbolShapeHint.FORCE_SQUARE);
        try {
            BitMatrix bitMatrix = dataMatrixWriter.encode(string, BarcodeFormat.DATA_MATRIX, n, n2, enumMap);
            Bitmap bitmap = this.convertBitMatrixToBitmap(bitMatrix);
            byArray = this.convertBitmapToByteArray(bitmap);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            byArray = "".getBytes();
            illegalArgumentException.printStackTrace();
        }
        return byArray;
    }

    public byte[] createPDF417(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        byte[] byArray = null;
        PDF417Writer pDF417Writer = new PDF417Writer();
        EnumMap<EncodeHintType, Object> enumMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        enumMap.put(EncodeHintType.PDF417_DIMENSIONS, new Dimensions(2, n4, 2, n3));
        enumMap.put(EncodeHintType.MARGIN, Integer.valueOf(n8));
        enumMap.put(EncodeHintType.ERROR_CORRECTION, Integer.valueOf(n5));
        enumMap.put(EncodeHintType.PDF417_SCALEX, Integer.valueOf(n6));
        enumMap.put(EncodeHintType.PDF417_SCALEY, Integer.valueOf(n7));
        BitMatrix bitMatrix = null;
        try {
            bitMatrix = pDF417Writer.encode(string, BarcodeFormat.PDF_417, n, n2, enumMap);
            Bitmap bitmap = this.convertBitMatrixToBitmap(bitMatrix);
            byArray = this.convertBitmapToByteArray(bitmap);
        }
        catch (WriterException writerException) {
            byArray = "".getBytes();
            writerException.printStackTrace();
        }
        return byArray;
    }

    private Bitmap convertBitMatrixToBitmap(BitMatrix bitMatrix) {
        int n = bitMatrix.getWidth();
        int n2 = bitMatrix.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                bitmap.setPixel(n3, n4, bitMatrix.get(n3, n4) ? -16777216 : -1);
                ++n4;
            }
            ++n3;
        }
        return bitmap;
    }

    private byte[] convertBitmapToByteArray(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

