/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode;

import oz.util.barcode.LuminanceSource;

public final class RGBLuminanceSource
extends LuminanceSource {
    private final byte[] luminances;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;

    public RGBLuminanceSource(int n, int n2, int[] nArray) {
        super(n, n2);
        this.dataWidth = n;
        this.dataHeight = n2;
        this.left = 0;
        this.top = 0;
        int n3 = n * n2;
        this.luminances = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n4];
            int n6 = n5 >> 16 & 0xFF;
            int n7 = n5 >> 7 & 0x1FE;
            int n8 = n5 & 0xFF;
            this.luminances[n4] = (byte)((n6 + n7 + n8) / 4);
            ++n4;
        }
    }

    private RGBLuminanceSource(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n5, n6);
        if (n3 + n5 > n || n4 + n6 > n2) {
            throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
        }
        this.luminances = byArray;
        this.dataWidth = n;
        this.dataHeight = n2;
        this.left = n3;
        this.top = n4;
    }

    @Override
    public byte[] getRow(int n, byte[] byArray) {
        if (n < 0 || n >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + n);
        }
        int n2 = this.getWidth();
        if (byArray == null || byArray.length < n2) {
            byArray = new byte[n2];
        }
        int n3 = (n + this.top) * this.dataWidth + this.left;
        System.arraycopy(this.luminances, n3, byArray, 0, n2);
        return byArray;
    }

    @Override
    public byte[] getMatrix() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n == this.dataWidth && n2 == this.dataHeight) {
            return this.luminances;
        }
        int n3 = n * n2;
        byte[] byArray = new byte[n3];
        int n4 = this.top * this.dataWidth + this.left;
        if (n == this.dataWidth) {
            System.arraycopy(this.luminances, n4, byArray, 0, n3);
            return byArray;
        }
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n5 * n;
            System.arraycopy(this.luminances, n4, byArray, n6, n);
            n4 += this.dataWidth;
            ++n5;
        }
        return byArray;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int n, int n2, int n3, int n4) {
        return new RGBLuminanceSource(this.luminances, this.dataWidth, this.dataHeight, this.left + n, this.top + n2, n3, n4);
    }
}

