/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.aztec;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.FormatException;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Reader;
import oz.util.barcode.Result;
import oz.util.barcode.ResultMetadataType;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.ResultPointCallback;
import oz.util.barcode.aztec.AztecDetectorResult;
import oz.util.barcode.aztec.decoder.Decoder;
import oz.util.barcode.aztec.detector.Detector;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.common.DetectorResult;

public final class AztecReader
implements Reader {
    @Override
    public Result decode(BinaryBitmap binaryBitmap) {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map map) {
        String string;
        Object object;
        Object object2;
        NotFoundException notFoundException = null;
        FormatException formatException = null;
        Detector detector = new Detector(binaryBitmap.getBlackMatrix());
        ResultPoint[] resultPointArray = null;
        DecoderResult decoderResult = null;
        try {
            object2 = detector.detect(false);
            resultPointArray = ((DetectorResult)object2).getPoints();
            decoderResult = new Decoder().decode((AztecDetectorResult)object2);
        }
        catch (NotFoundException notFoundException2) {
            notFoundException = notFoundException2;
        }
        catch (FormatException formatException2) {
            formatException = formatException2;
        }
        if (decoderResult == null) {
            try {
                object2 = detector.detect(true);
                resultPointArray = ((DetectorResult)object2).getPoints();
                decoderResult = new Decoder().decode((AztecDetectorResult)object2);
            }
            catch (FormatException | NotFoundException readerException) {
                if (notFoundException != null) {
                    throw notFoundException;
                }
                if (formatException != null) {
                    throw formatException;
                }
                throw readerException;
            }
        }
        if (map != null && (object2 = (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK)) != null) {
            ResultPoint[] resultPointArray2 = resultPointArray;
            int n = resultPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = resultPointArray2[n2];
                object2.foundPossibleResultPoint((ResultPoint)object);
                ++n2;
            }
        }
        object2 = new Result(decoderResult.getText(), decoderResult.getRawBytes(), decoderResult.getNumBits(), resultPointArray, BarcodeFormat.AZTEC, System.currentTimeMillis());
        object = decoderResult.getByteSegments();
        if (object != null) {
            ((Result)object2).putMetadata(ResultMetadataType.BYTE_SEGMENTS, object);
        }
        if ((string = decoderResult.getECLevel()) != null) {
            ((Result)object2).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string);
        }
        return object2;
    }

    @Override
    public void reset() {
    }
}

