/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.aztec.detector;

import oz.util.barcode.NotFoundException;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.aztec.AztecDetectorResult;
import oz.util.barcode.aztec.detector.Detector$Point;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.GridSampler;
import oz.util.barcode.common.detector.MathUtils;
import oz.util.barcode.common.detector.WhiteRectangleDetector;
import oz.util.barcode.common.reedsolomon.GenericGF;
import oz.util.barcode.common.reedsolomon.ReedSolomonDecoder;
import oz.util.barcode.common.reedsolomon.ReedSolomonException;

public final class Detector {
    private static final int[] EXPECTED_CORNER_BITS = new int[]{3808, 476, 2107, 1799};
    private final BitMatrix image;
    private boolean compact;
    private int nbLayers;
    private int nbDataBlocks;
    private int nbCenterLayers;
    private int shift;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    public AztecDetectorResult detect() {
        return this.detect(false);
    }

    public AztecDetectorResult detect(boolean bl) {
        Object object;
        Detector$Point detector$Point = this.getMatrixCenter();
        ResultPoint[] resultPointArray = this.getBullsEyeCorners(detector$Point);
        if (bl) {
            object = resultPointArray[0];
            resultPointArray[0] = resultPointArray[2];
            resultPointArray[2] = object;
        }
        this.extractParameters(resultPointArray);
        object = this.sampleGrid(this.image, resultPointArray[this.shift % 4], resultPointArray[(this.shift + 1) % 4], resultPointArray[(this.shift + 2) % 4], resultPointArray[(this.shift + 3) % 4]);
        ResultPoint[] resultPointArray2 = this.getMatrixCornerPoints(resultPointArray);
        return new AztecDetectorResult((BitMatrix)object, resultPointArray2, this.compact, this.nbDataBlocks, this.nbLayers);
    }

    private void extractParameters(ResultPoint[] resultPointArray) {
        if (!(this.isValid(resultPointArray[0]) && this.isValid(resultPointArray[1]) && this.isValid(resultPointArray[2]) && this.isValid(resultPointArray[3]))) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n = 2 * this.nbCenterLayers;
        int[] nArray = new int[]{this.sampleLine(resultPointArray[0], resultPointArray[1], n), this.sampleLine(resultPointArray[1], resultPointArray[2], n), this.sampleLine(resultPointArray[2], resultPointArray[3], n), this.sampleLine(resultPointArray[3], resultPointArray[0], n)};
        this.shift = Detector.getRotation(nArray, n);
        long l = 0L;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = nArray[(this.shift + n2) % 4];
            if (this.compact) {
                l <<= 7;
                l += (long)(n3 >> 1 & 0x7F);
            } else {
                l <<= 10;
                l += (long)((n3 >> 2 & 0x3E0) + (n3 >> 1 & 0x1F));
            }
            ++n2;
        }
        n2 = Detector.getCorrectedParameterData(l, this.compact);
        if (this.compact) {
            this.nbLayers = (n2 >> 6) + 1;
            this.nbDataBlocks = (n2 & 0x3F) + 1;
        } else {
            this.nbLayers = (n2 >> 11) + 1;
            this.nbDataBlocks = (n2 & 0x7FF) + 1;
        }
    }

    private static int getRotation(int[] nArray, int n) {
        int n2;
        int n3 = 0;
        int[] nArray2 = nArray;
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            n2 = nArray2[n5];
            int n6 = (n2 >> n - 2 << 1) + (n2 & 1);
            n3 = (n3 << 3) + n6;
            ++n5;
        }
        n3 = ((n3 & 1) << 11) + (n3 >> 1);
        n2 = 0;
        while (n2 < 4) {
            if (Integer.bitCount(n3 ^ EXPECTED_CORNER_BITS[n2]) <= 2) {
                return n2;
            }
            ++n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int getCorrectedParameterData(long l, boolean bl) {
        int n;
        int n2;
        if (bl) {
            n2 = 7;
            n = 2;
        } else {
            n2 = 10;
            n = 4;
        }
        int n3 = n2 - n;
        int[] nArray = new int[n2];
        int n4 = n2 - 1;
        while (n4 >= 0) {
            nArray[n4] = (int)l & 0xF;
            l >>= 4;
            --n4;
        }
        try {
            ReedSolomonDecoder reedSolomonDecoder = new ReedSolomonDecoder(GenericGF.AZTEC_PARAM);
            reedSolomonDecoder.decode(nArray, n3);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            n5 = (n5 << 4) + nArray[n6];
            ++n6;
        }
        return n5;
    }

    private ResultPoint[] getBullsEyeCorners(Detector$Point detector$Point) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5 = detector$Point;
        Detector$Point detector$Point2 = detector$Point;
        Detector$Point detector$Point3 = detector$Point;
        Detector$Point detector$Point4 = detector$Point;
        boolean bl = true;
        this.nbCenterLayers = 1;
        while (this.nbCenterLayers < 9) {
            float f2;
            object4 = this.getFirstDifferent((Detector$Point)object5, bl, 1, -1);
            object3 = this.getFirstDifferent(detector$Point2, bl, 1, 1);
            object2 = this.getFirstDifferent(detector$Point3, bl, -1, 1);
            object = this.getFirstDifferent(detector$Point4, bl, -1, -1);
            if (this.nbCenterLayers > 2 && ((double)(f2 = Detector.distance((Detector$Point)object, (Detector$Point)object4) * (float)this.nbCenterLayers / (Detector.distance(detector$Point4, (Detector$Point)object5) * (float)(this.nbCenterLayers + 2))) < 0.75 || (double)f2 > 1.25 || !this.isWhiteOrBlackRectangle((Detector$Point)object4, (Detector$Point)object3, (Detector$Point)object2, (Detector$Point)object))) break;
            object5 = object4;
            detector$Point2 = object3;
            detector$Point3 = object2;
            detector$Point4 = object;
            bl = !bl;
            ++this.nbCenterLayers;
        }
        if (this.nbCenterLayers != 5 && this.nbCenterLayers != 7) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.compact = this.nbCenterLayers == 5;
        object4 = new ResultPoint((float)((Detector$Point)object5).getX() + 0.5f, (float)((Detector$Point)object5).getY() - 0.5f);
        object3 = new ResultPoint((float)detector$Point2.getX() + 0.5f, (float)detector$Point2.getY() + 0.5f);
        object2 = new ResultPoint((float)detector$Point3.getX() - 0.5f, (float)detector$Point3.getY() + 0.5f);
        object = new ResultPoint((float)detector$Point4.getX() - 0.5f, (float)detector$Point4.getY() - 0.5f);
        return Detector.expandSquare(new ResultPoint[]{object4, object3, object2, object}, 2 * this.nbCenterLayers - 3, 2 * this.nbCenterLayers);
    }

    private Detector$Point getMatrixCenter() {
        int n;
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3;
        ResultPoint resultPoint4;
        try {
            ResultPoint[] resultPointArray = new WhiteRectangleDetector(this.image).detect();
            resultPoint4 = resultPointArray[0];
            resultPoint3 = resultPointArray[1];
            resultPoint2 = resultPointArray[2];
            resultPoint = resultPointArray[3];
        }
        catch (NotFoundException notFoundException) {
            n = this.image.getWidth() / 2;
            int n2 = this.image.getHeight() / 2;
            resultPoint4 = this.getFirstDifferent(new Detector$Point(n + 7, n2 - 7), false, 1, -1).toResultPoint();
            resultPoint3 = this.getFirstDifferent(new Detector$Point(n + 7, n2 + 7), false, 1, 1).toResultPoint();
            resultPoint2 = this.getFirstDifferent(new Detector$Point(n - 7, n2 + 7), false, -1, 1).toResultPoint();
            resultPoint = this.getFirstDifferent(new Detector$Point(n - 7, n2 - 7), false, -1, -1).toResultPoint();
        }
        int n3 = MathUtils.round((resultPoint4.getX() + resultPoint.getX() + resultPoint3.getX() + resultPoint2.getX()) / 4.0f);
        n = MathUtils.round((resultPoint4.getY() + resultPoint.getY() + resultPoint3.getY() + resultPoint2.getY()) / 4.0f);
        try {
            ResultPoint[] resultPointArray = new WhiteRectangleDetector(this.image, 15, n3, n).detect();
            resultPoint4 = resultPointArray[0];
            resultPoint3 = resultPointArray[1];
            resultPoint2 = resultPointArray[2];
            resultPoint = resultPointArray[3];
        }
        catch (NotFoundException notFoundException) {
            resultPoint4 = this.getFirstDifferent(new Detector$Point(n3 + 7, n - 7), false, 1, -1).toResultPoint();
            resultPoint3 = this.getFirstDifferent(new Detector$Point(n3 + 7, n + 7), false, 1, 1).toResultPoint();
            resultPoint2 = this.getFirstDifferent(new Detector$Point(n3 - 7, n + 7), false, -1, 1).toResultPoint();
            resultPoint = this.getFirstDifferent(new Detector$Point(n3 - 7, n - 7), false, -1, -1).toResultPoint();
        }
        n3 = MathUtils.round((resultPoint4.getX() + resultPoint.getX() + resultPoint3.getX() + resultPoint2.getX()) / 4.0f);
        n = MathUtils.round((resultPoint4.getY() + resultPoint.getY() + resultPoint3.getY() + resultPoint2.getY()) / 4.0f);
        return new Detector$Point(n3, n);
    }

    private ResultPoint[] getMatrixCornerPoints(ResultPoint[] resultPointArray) {
        return Detector.expandSquare(resultPointArray, 2 * this.nbCenterLayers, this.getDimension());
    }

    private BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) {
        GridSampler gridSampler = GridSampler.getInstance();
        int n = this.getDimension();
        float f2 = (float)n / 2.0f - (float)this.nbCenterLayers;
        float f3 = (float)n / 2.0f + (float)this.nbCenterLayers;
        return gridSampler.sampleGrid(bitMatrix, n, n, f2, f2, f3, f2, f3, f3, f2, f3, resultPoint.getX(), resultPoint.getY(), resultPoint2.getX(), resultPoint2.getY(), resultPoint3.getX(), resultPoint3.getY(), resultPoint4.getX(), resultPoint4.getY());
    }

    private int sampleLine(ResultPoint resultPoint, ResultPoint resultPoint2, int n) {
        int n2 = 0;
        float f2 = Detector.distance(resultPoint, resultPoint2);
        float f3 = f2 / (float)n;
        float f4 = resultPoint.getX();
        float f5 = resultPoint.getY();
        float f6 = f3 * (resultPoint2.getX() - resultPoint.getX()) / f2;
        float f7 = f3 * (resultPoint2.getY() - resultPoint.getY()) / f2;
        int n3 = 0;
        while (n3 < n) {
            if (this.image.get(MathUtils.round(f4 + (float)n3 * f6), MathUtils.round(f5 + (float)n3 * f7))) {
                n2 |= 1 << n - n3 - 1;
            }
            ++n3;
        }
        return n2;
    }

    private boolean isWhiteOrBlackRectangle(Detector$Point detector$Point, Detector$Point detector$Point2, Detector$Point detector$Point3, Detector$Point detector$Point4) {
        int n = 3;
        detector$Point = new Detector$Point(detector$Point.getX() - n, detector$Point.getY() + n);
        detector$Point2 = new Detector$Point(detector$Point2.getX() - n, detector$Point2.getY() - n);
        detector$Point3 = new Detector$Point(detector$Point3.getX() + n, detector$Point3.getY() - n);
        int n2 = this.getColor(detector$Point4 = new Detector$Point(detector$Point4.getX() + n, detector$Point4.getY() + n), detector$Point);
        if (n2 == 0) {
            return false;
        }
        int n3 = this.getColor(detector$Point, detector$Point2);
        if (n3 != n2) {
            return false;
        }
        n3 = this.getColor(detector$Point2, detector$Point3);
        if (n3 != n2) {
            return false;
        }
        n3 = this.getColor(detector$Point3, detector$Point4);
        return n3 == n2;
    }

    private int getColor(Detector$Point detector$Point, Detector$Point detector$Point2) {
        float f2 = Detector.distance(detector$Point, detector$Point2);
        float f3 = (float)(detector$Point2.getX() - detector$Point.getX()) / f2;
        float f4 = (float)(detector$Point2.getY() - detector$Point.getY()) / f2;
        int n = 0;
        float f5 = detector$Point.getX();
        float f6 = detector$Point.getY();
        boolean bl = this.image.get(detector$Point.getX(), detector$Point.getY());
        int n2 = (int)Math.ceil(f2);
        int n3 = 0;
        while (n3 < n2) {
            if (this.image.get(MathUtils.round(f5 += f3), MathUtils.round(f6 += f4)) != bl) {
                ++n;
            }
            ++n3;
        }
        float f7 = (float)n / f2;
        if (f7 > 0.1f && f7 < 0.9f) {
            return 0;
        }
        return f7 <= 0.1f == bl ? 1 : -1;
    }

    private Detector$Point getFirstDifferent(Detector$Point detector$Point, boolean bl, int n, int n2) {
        int n3 = detector$Point.getX() + n;
        int n4 = detector$Point.getY() + n2;
        while (this.isValid(n3, n4) && this.image.get(n3, n4) == bl) {
            n3 += n;
            n4 += n2;
        }
        n3 -= n;
        n4 -= n2;
        while (this.isValid(n3, n4) && this.image.get(n3, n4) == bl) {
            n3 += n;
        }
        n3 -= n;
        while (this.isValid(n3, n4) && this.image.get(n3, n4) == bl) {
            n4 += n2;
        }
        return new Detector$Point(n3, n4 -= n2);
    }

    private static ResultPoint[] expandSquare(ResultPoint[] resultPointArray, int n, int n2) {
        float f2 = (float)n2 / (2.0f * (float)n);
        float f3 = resultPointArray[0].getX() - resultPointArray[2].getX();
        float f4 = resultPointArray[0].getY() - resultPointArray[2].getY();
        float f5 = (resultPointArray[0].getX() + resultPointArray[2].getX()) / 2.0f;
        float f6 = (resultPointArray[0].getY() + resultPointArray[2].getY()) / 2.0f;
        ResultPoint resultPoint = new ResultPoint(f5 + f2 * f3, f6 + f2 * f4);
        ResultPoint resultPoint2 = new ResultPoint(f5 - f2 * f3, f6 - f2 * f4);
        f3 = resultPointArray[1].getX() - resultPointArray[3].getX();
        f4 = resultPointArray[1].getY() - resultPointArray[3].getY();
        f5 = (resultPointArray[1].getX() + resultPointArray[3].getX()) / 2.0f;
        f6 = (resultPointArray[1].getY() + resultPointArray[3].getY()) / 2.0f;
        ResultPoint resultPoint3 = new ResultPoint(f5 + f2 * f3, f6 + f2 * f4);
        ResultPoint resultPoint4 = new ResultPoint(f5 - f2 * f3, f6 - f2 * f4);
        return new ResultPoint[]{resultPoint, resultPoint3, resultPoint2, resultPoint4};
    }

    private boolean isValid(int n, int n2) {
        return n >= 0 && n < this.image.getWidth() && n2 > 0 && n2 < this.image.getHeight();
    }

    private boolean isValid(ResultPoint resultPoint) {
        int n = MathUtils.round(resultPoint.getX());
        int n2 = MathUtils.round(resultPoint.getY());
        return this.isValid(n, n2);
    }

    private static float distance(Detector$Point detector$Point, Detector$Point detector$Point2) {
        return MathUtils.distance(detector$Point.getX(), detector$Point.getY(), detector$Point2.getX(), detector$Point2.getY());
    }

    private static float distance(ResultPoint resultPoint, ResultPoint resultPoint2) {
        return MathUtils.distance(resultPoint.getX(), resultPoint.getY(), resultPoint2.getX(), resultPoint2.getY());
    }

    private int getDimension() {
        if (this.compact) {
            return 4 * this.nbLayers + 11;
        }
        if (this.nbLayers <= 4) {
            return 4 * this.nbLayers + 15;
        }
        return 4 * this.nbLayers + 2 * ((this.nbLayers - 4) / 8 + 1) + 15;
    }
}

