/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.MultiFormatReader;
import oz.util.barcode.PlanarYUVLuminanceSource;
import oz.util.barcode.ReaderException;
import oz.util.barcode.Result;
import oz.util.barcode.client.android.OZCaptureView;
import oz.util.barcode.common.HybridBinarizer;

final class DecodeHandler
extends Handler {
    private static final String TAG = DecodeHandler.class.getSimpleName();
    private final OZCaptureView activity;
    private final MultiFormatReader multiFormatReader = new MultiFormatReader();
    private boolean running = true;

    DecodeHandler(OZCaptureView oZCaptureView, Map map) {
        this.multiFormatReader.setHints(map);
        this.activity = oZCaptureView;
    }

    public void handleMessage(Message message) {
        if (!this.running) {
            return;
        }
        switch (message.what) {
            case 2131230720: {
                this.decode((byte[])message.obj, message.arg1, message.arg2);
                break;
            }
            case 2131230724: {
                this.running = false;
                Looper.myLooper().quit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(byte[] byArray, int n, int n2) {
        Object object;
        long l = System.currentTimeMillis();
        Result result = null;
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this.activity.getCameraManager().buildLuminanceSource(byArray, n, n2);
        if (planarYUVLuminanceSource != null) {
            object = new BinaryBitmap(new HybridBinarizer(planarYUVLuminanceSource));
            try {
                result = this.multiFormatReader.decodeWithState((BinaryBitmap)object);
            }
            catch (ReaderException readerException) {
            }
            finally {
                this.multiFormatReader.reset();
            }
        }
        object = this.activity.getHandler();
        if (result != null) {
            long l2 = System.currentTimeMillis();
            Log.d((String)TAG, (String)("Found barcode in " + (l2 - l) + " ms"));
            if (object != null) {
                Message message = Message.obtain((Handler)object, (int)2131230722, (Object)result);
                Bundle bundle = new Bundle();
                DecodeHandler.bundleThumbnail(planarYUVLuminanceSource, bundle);
                message.setData(bundle);
                message.sendToTarget();
            }
        } else if (object != null) {
            Message message = Message.obtain((Handler)object, (int)2131230721);
            message.sendToTarget();
        }
    }

    private static void bundleThumbnail(PlanarYUVLuminanceSource planarYUVLuminanceSource, Bundle bundle) {
        int[] nArray = planarYUVLuminanceSource.renderThumbnail();
        int n = planarYUVLuminanceSource.getThumbnailWidth();
        int n2 = planarYUVLuminanceSource.getThumbnailHeight();
        Bitmap bitmap = Bitmap.createBitmap((int[])nArray, (int)0, (int)n, (int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)byteArrayOutputStream);
        bundle.putByteArray("barcode_bitmap", byteArrayOutputStream.toByteArray());
        bundle.putFloat("barcode_scaled_factor", (float)n / (float)planarYUVLuminanceSource.getWidth());
    }
}

