/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.result;

import java.util.Map;
import java.util.regex.Pattern;
import oz.util.barcode.Result;
import oz.util.barcode.client.result.EmailAddressParsedResult;
import oz.util.barcode.client.result.EmailDoCoMoResultParser;
import oz.util.barcode.client.result.ResultParser;

public final class EmailAddressResultParser
extends ResultParser {
    private static final Pattern COMMA = Pattern.compile(",");

    @Override
    public EmailAddressParsedResult parse(Result result) {
        String string = EmailAddressResultParser.getMassagedText(result);
        if (string.startsWith("mailto:") || string.startsWith("MAILTO:")) {
            String string2 = string.substring(7);
            int n = string2.indexOf(63);
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            try {
                string2 = EmailAddressResultParser.urlDecode(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            String[] stringArray = null;
            if (!string2.isEmpty()) {
                stringArray = COMMA.split(string2);
            }
            Map map = EmailAddressResultParser.parseNameValuePairs(string);
            String[] stringArray2 = null;
            String[] stringArray3 = null;
            String string3 = null;
            String string4 = null;
            if (map != null) {
                String string5;
                String string6;
                if (stringArray == null && (string6 = (String)map.get("to")) != null) {
                    stringArray = COMMA.split(string6);
                }
                if ((string6 = (String)map.get("cc")) != null) {
                    stringArray2 = COMMA.split(string6);
                }
                if ((string5 = (String)map.get("bcc")) != null) {
                    stringArray3 = COMMA.split(string5);
                }
                string3 = (String)map.get("subject");
                string4 = (String)map.get("body");
            }
            return new EmailAddressParsedResult(stringArray, stringArray2, stringArray3, string3, string4);
        }
        if (!EmailDoCoMoResultParser.isBasicallyValidEmailAddress(string)) {
            return null;
        }
        return new EmailAddressParsedResult(string);
    }
}

