/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.result;

import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.Result;
import oz.util.barcode.client.result.ProductParsedResult;
import oz.util.barcode.client.result.ResultParser;
import oz.util.barcode.oned.UPCEReader;

public final class ProductResultParser
extends ResultParser {
    @Override
    public ProductParsedResult parse(Result result) {
        BarcodeFormat barcodeFormat = result.getBarcodeFormat();
        if (barcodeFormat != BarcodeFormat.UPC_A && barcodeFormat != BarcodeFormat.UPC_E && barcodeFormat != BarcodeFormat.EAN_8 && barcodeFormat != BarcodeFormat.EAN_13) {
            return null;
        }
        String string = ProductResultParser.getMassagedText(result);
        if (!ProductResultParser.isStringOfDigits(string, string.length())) {
            return null;
        }
        String string2 = barcodeFormat == BarcodeFormat.UPC_E && string.length() == 8 ? UPCEReader.convertUPCEtoUPCA(string) : string;
        return new ProductParsedResult(string, string2);
    }
}

