/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.common;

import java.util.Arrays;

public final class BitArray
implements Cloneable {
    private int[] bits;
    private int size;

    public BitArray() {
        this.size = 0;
        this.bits = new int[1];
    }

    public BitArray(int n) {
        this.size = n;
        this.bits = BitArray.makeArray(n);
    }

    BitArray(int[] nArray, int n) {
        this.bits = nArray;
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return (this.size + 7) / 8;
    }

    private void ensureCapacity(int n) {
        if (n > this.bits.length * 32) {
            int[] nArray = BitArray.makeArray(n);
            System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
            this.bits = nArray;
        }
    }

    public boolean get(int n) {
        return (this.bits[n / 32] & 1 << (n & 0x1F)) != 0;
    }

    public void set(int n) {
        int n2 = n / 32;
        this.bits[n2] = this.bits[n2] | 1 << (n & 0x1F);
    }

    public void flip(int n) {
        int n2 = n / 32;
        this.bits[n2] = this.bits[n2] ^ 1 << (n & 0x1F);
    }

    public int getNextSet(int n) {
        if (n >= this.size) {
            return this.size;
        }
        int n2 = n / 32;
        int n3 = this.bits[n2];
        n3 &= ~((1 << (n & 0x1F)) - 1);
        while (n3 == 0) {
            if (++n2 == this.bits.length) {
                return this.size;
            }
            n3 = this.bits[n2];
        }
        int n4 = n2 * 32 + Integer.numberOfTrailingZeros(n3);
        return n4 > this.size ? this.size : n4;
    }

    public int getNextUnset(int n) {
        if (n >= this.size) {
            return this.size;
        }
        int n2 = n / 32;
        int n3 = ~this.bits[n2];
        n3 &= ~((1 << (n & 0x1F)) - 1);
        while (n3 == 0) {
            if (++n2 == this.bits.length) {
                return this.size;
            }
            n3 = ~this.bits[n2];
        }
        int n4 = n2 * 32 + Integer.numberOfTrailingZeros(n3);
        return n4 > this.size ? this.size : n4;
    }

    public void setBulk(int n, int n2) {
        this.bits[n / 32] = n2;
    }

    public void setRange(int n, int n2) {
        if (n2 < n || n < 0 || n2 > this.size) {
            throw new IllegalArgumentException();
        }
        if (n2 == n) {
            return;
        }
        int n3 = n / 32;
        int n4 = --n2 / 32;
        int n5 = n3;
        while (n5 <= n4) {
            int n6 = n5 > n3 ? 0 : n & 0x1F;
            int n7 = n5 < n4 ? 31 : n2 & 0x1F;
            int n8 = (2 << n7) - (1 << n6);
            int n9 = n5++;
            this.bits[n9] = this.bits[n9] | n8;
        }
    }

    public void clear() {
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            this.bits[n2] = 0;
            ++n2;
        }
    }

    public boolean isRange(int n, int n2, boolean bl) {
        if (n2 < n || n < 0 || n2 > this.size) {
            throw new IllegalArgumentException();
        }
        if (n2 == n) {
            return true;
        }
        int n3 = n / 32;
        int n4 = --n2 / 32;
        int n5 = n3;
        while (n5 <= n4) {
            int n6;
            int n7 = n5 < n4 ? 31 : n2 & 0x1F;
            int n8 = (2 << n7) - (1 << (n6 = n5 > n3 ? 0 : n & 0x1F));
            if ((this.bits[n5] & n8) != (bl ? n8 : 0)) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public void appendBit(boolean bl) {
        this.ensureCapacity(this.size + 1);
        if (bl) {
            int n = this.size / 32;
            this.bits[n] = this.bits[n] | 1 << (this.size & 0x1F);
        }
        ++this.size;
    }

    public void appendBits(int n, int n2) {
        if (n2 < 0 || n2 > 32) {
            throw new IllegalArgumentException("Num bits must be between 0 and 32");
        }
        this.ensureCapacity(this.size + n2);
        int n3 = n2;
        while (n3 > 0) {
            this.appendBit((n >> n3 - 1 & 1) == 1);
            --n3;
        }
    }

    public void appendBitArray(BitArray bitArray) {
        int n = bitArray.size;
        this.ensureCapacity(this.size + n);
        int n2 = 0;
        while (n2 < n) {
            this.appendBit(bitArray.get(n2));
            ++n2;
        }
    }

    public void xor(BitArray bitArray) {
        if (this.size != bitArray.size) {
            throw new IllegalArgumentException("Sizes don't match");
        }
        int n = 0;
        while (n < this.bits.length) {
            int n2 = n;
            this.bits[n2] = this.bits[n2] ^ bitArray.bits[n];
            ++n;
        }
    }

    public void toBytes(int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < 8) {
                if (this.get(n)) {
                    n5 |= 1 << 7 - n6;
                }
                ++n;
                ++n6;
            }
            byArray[n2 + n4] = (byte)n5;
            ++n4;
        }
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int[] nArray = new int[this.bits.length];
        int n = (this.size - 1) / 32;
        int n2 = n + 1;
        int n3 = 0;
        while (n3 < n2) {
            long l = this.bits[n3];
            l = l >> 1 & 0x55555555L | (l & 0x55555555L) << 1;
            l = l >> 2 & 0x33333333L | (l & 0x33333333L) << 2;
            l = l >> 4 & 0xF0F0F0FL | (l & 0xF0F0F0FL) << 4;
            l = l >> 8 & 0xFF00FFL | (l & 0xFF00FFL) << 8;
            l = l >> 16 & 0xFFFFL | (l & 0xFFFFL) << 16;
            nArray[n - n3] = (int)l;
            ++n3;
        }
        if (this.size != n2 * 32) {
            n3 = n2 * 32 - this.size;
            int n4 = nArray[0] >>> n3;
            int n5 = 1;
            while (n5 < n2) {
                int n6 = nArray[n5];
                nArray[n5 - 1] = n4 |= n6 << 32 - n3;
                n4 = n6 >>> n3;
                ++n5;
            }
            nArray[n2 - 1] = n4;
        }
        this.bits = nArray;
    }

    private static int[] makeArray(int n) {
        return new int[(n + 31) / 32];
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitArray)) {
            return false;
        }
        BitArray bitArray = (BitArray)object;
        return this.size == bitArray.size && Arrays.equals(this.bits, bitArray.bits);
    }

    public int hashCode() {
        return 31 * this.size + Arrays.hashCode(this.bits);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.size + this.size / 8 + 1);
        int n = 0;
        while (n < this.size) {
            if ((n & 7) == 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.get(n) ? (char)'X' : '.');
            ++n;
        }
        return stringBuilder.toString();
    }

    public BitArray clone() {
        return new BitArray((int[])this.bits.clone(), this.size);
    }
}

