/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.common;

import java.util.Arrays;
import oz.util.barcode.common.BitArray;

public final class BitMatrix
implements Cloneable {
    private final int width;
    private final int height;
    private final int rowSize;
    private final int[] bits;

    public BitMatrix(int n) {
        this(n, n);
    }

    public BitMatrix(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("Both dimensions must be greater than 0");
        }
        this.width = n;
        this.height = n2;
        this.rowSize = (n + 31) / 32;
        this.bits = new int[this.rowSize * n2];
    }

    private BitMatrix(int n, int n2, int n3, int[] nArray) {
        this.width = n;
        this.height = n2;
        this.rowSize = n3;
        this.bits = nArray;
    }

    public static BitMatrix parse(boolean[][] blArray) {
        int n = blArray.length;
        int n2 = blArray[0].length;
        BitMatrix bitMatrix = new BitMatrix(n2, n);
        int n3 = 0;
        while (n3 < n) {
            boolean[] blArray2 = blArray[n3];
            int n4 = 0;
            while (n4 < n2) {
                if (blArray2[n4]) {
                    bitMatrix.set(n4, n3);
                }
                ++n4;
            }
            ++n3;
        }
        return bitMatrix;
    }

    public static BitMatrix parse(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        boolean[] blArray = new boolean[string.length()];
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n5 < string.length()) {
            if (string.charAt(n5) == '\n' || string.charAt(n5) == '\r') {
                if (n > n2) {
                    if (n3 == -1) {
                        n3 = n - n2;
                    } else if (n - n2 != n3) {
                        throw new IllegalArgumentException("row lengths do not match");
                    }
                    n2 = n;
                    ++n4;
                }
                ++n5;
                continue;
            }
            if (string.substring(n5, n5 + string2.length()).equals(string2)) {
                n5 += string2.length();
                blArray[n] = true;
                ++n;
                continue;
            }
            if (string.substring(n5, n5 + string3.length()).equals(string3)) {
                n5 += string3.length();
                blArray[n] = false;
                ++n;
                continue;
            }
            throw new IllegalArgumentException("illegal character encountered: " + string.substring(n5));
        }
        if (n > n2) {
            if (n3 == -1) {
                n3 = n - n2;
            } else if (n - n2 != n3) {
                throw new IllegalArgumentException("row lengths do not match");
            }
            ++n4;
        }
        BitMatrix bitMatrix = new BitMatrix(n3, n4);
        int n6 = 0;
        while (n6 < n) {
            if (blArray[n6]) {
                bitMatrix.set(n6 % n3, n6 / n3);
            }
            ++n6;
        }
        return bitMatrix;
    }

    public boolean get(int n, int n2) {
        int n3 = n2 * this.rowSize + n / 32;
        return (this.bits[n3] >>> (n & 0x1F) & 1) != 0;
    }

    public void set(int n, int n2) {
        int n3;
        int n4 = n3 = n2 * this.rowSize + n / 32;
        this.bits[n4] = this.bits[n4] | 1 << (n & 0x1F);
    }

    public void unset(int n, int n2) {
        int n3;
        int n4 = n3 = n2 * this.rowSize + n / 32;
        this.bits[n4] = this.bits[n4] & ~(1 << (n & 0x1F));
    }

    public void flip(int n, int n2) {
        int n3;
        int n4 = n3 = n2 * this.rowSize + n / 32;
        this.bits[n4] = this.bits[n4] ^ 1 << (n & 0x1F);
    }

    public void xor(BitMatrix bitMatrix) {
        if (this.width != bitMatrix.getWidth() || this.height != bitMatrix.getHeight() || this.rowSize != bitMatrix.getRowSize()) {
            throw new IllegalArgumentException("input matrix dimensions do not match");
        }
        BitArray bitArray = new BitArray(this.width);
        int n = 0;
        while (n < this.height) {
            int n2 = n * this.rowSize;
            int[] nArray = bitMatrix.getRow(n, bitArray).getBitArray();
            int n3 = 0;
            while (n3 < this.rowSize) {
                int n4 = n2 + n3;
                this.bits[n4] = this.bits[n4] ^ nArray[n3];
                ++n3;
            }
            ++n;
        }
    }

    public void clear() {
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            this.bits[n2] = 0;
            ++n2;
        }
    }

    public void setRegion(int n, int n2, int n3, int n4) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException("Left and top must be nonnegative");
        }
        if (n4 < 1 || n3 < 1) {
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (n6 > this.height || n5 > this.width) {
            throw new IllegalArgumentException("The region must fit inside the matrix");
        }
        int n7 = n2;
        while (n7 < n6) {
            int n8 = n7 * this.rowSize;
            int n9 = n;
            while (n9 < n5) {
                int n10 = n8 + n9 / 32;
                this.bits[n10] = this.bits[n10] | 1 << (n9 & 0x1F);
                ++n9;
            }
            ++n7;
        }
    }

    public BitArray getRow(int n, BitArray bitArray) {
        if (bitArray == null || bitArray.getSize() < this.width) {
            bitArray = new BitArray(this.width);
        } else {
            bitArray.clear();
        }
        int n2 = n * this.rowSize;
        int n3 = 0;
        while (n3 < this.rowSize) {
            bitArray.setBulk(n3 * 32, this.bits[n2 + n3]);
            ++n3;
        }
        return bitArray;
    }

    public void setRow(int n, BitArray bitArray) {
        System.arraycopy(bitArray.getBitArray(), 0, this.bits, n * this.rowSize, this.rowSize);
    }

    public void rotate180() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        BitArray bitArray = new BitArray(n);
        BitArray bitArray2 = new BitArray(n);
        int n3 = 0;
        while (n3 < (n2 + 1) / 2) {
            bitArray = this.getRow(n3, bitArray);
            bitArray2 = this.getRow(n2 - 1 - n3, bitArray2);
            bitArray.reverse();
            bitArray2.reverse();
            this.setRow(n3, bitArray2);
            this.setRow(n2 - 1 - n3, bitArray);
            ++n3;
        }
    }

    public int[] getEnclosingRectangle() {
        int n = this.width;
        int n2 = this.height;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.height) {
            int n6 = 0;
            while (n6 < this.rowSize) {
                int n7 = this.bits[n5 * this.rowSize + n6];
                if (n7 != 0) {
                    int n8;
                    if (n5 < n2) {
                        n2 = n5;
                    }
                    if (n5 > n4) {
                        n4 = n5;
                    }
                    if (n6 * 32 < n) {
                        n8 = 0;
                        while (n7 << 31 - n8 == 0) {
                            ++n8;
                        }
                        if (n6 * 32 + n8 < n) {
                            n = n6 * 32 + n8;
                        }
                    }
                    if (n6 * 32 + 31 > n3) {
                        n8 = 31;
                        while (n7 >>> n8 == 0) {
                            --n8;
                        }
                        if (n6 * 32 + n8 > n3) {
                            n3 = n6 * 32 + n8;
                        }
                    }
                }
                ++n6;
            }
            ++n5;
        }
        if (n3 < n || n4 < n2) {
            return null;
        }
        return new int[]{n, n2, n3 - n + 1, n4 - n2 + 1};
    }

    public int[] getTopLeftOnBit() {
        int n = 0;
        while (n < this.bits.length && this.bits[n] == 0) {
            ++n;
        }
        if (n == this.bits.length) {
            return null;
        }
        int n2 = n / this.rowSize;
        int n3 = n % this.rowSize * 32;
        int n4 = this.bits[n];
        int n5 = 0;
        while (n4 << 31 - n5 == 0) {
            ++n5;
        }
        return new int[]{n3 += n5, n2};
    }

    public int[] getBottomRightOnBit() {
        int n = this.bits.length - 1;
        while (n >= 0 && this.bits[n] == 0) {
            --n;
        }
        if (n < 0) {
            return null;
        }
        int n2 = n / this.rowSize;
        int n3 = n % this.rowSize * 32;
        int n4 = this.bits[n];
        int n5 = 31;
        while (n4 >>> n5 == 0) {
            --n5;
        }
        return new int[]{n3 += n5, n2};
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitMatrix)) {
            return false;
        }
        BitMatrix bitMatrix = (BitMatrix)object;
        return this.width == bitMatrix.width && this.height == bitMatrix.height && this.rowSize == bitMatrix.rowSize && Arrays.equals(this.bits, bitMatrix.bits);
    }

    public int hashCode() {
        int n = this.width;
        n = 31 * n + this.width;
        n = 31 * n + this.height;
        n = 31 * n + this.rowSize;
        n = 31 * n + Arrays.hashCode(this.bits);
        return n;
    }

    public String toString() {
        return this.toString("X ", "  ");
    }

    public String toString(String string, String string2) {
        return this.buildToString(string, string2, "\n");
    }

    public String toString(String string, String string2, String string3) {
        return this.buildToString(string, string2, string3);
    }

    private String buildToString(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(this.height * (this.width + 1));
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                stringBuilder.append(this.get(n2, n) ? string : string2);
                ++n2;
            }
            stringBuilder.append(string3);
            ++n;
        }
        return stringBuilder.toString();
    }

    public BitMatrix clone() {
        return new BitMatrix(this.width, this.height, this.rowSize, (int[])this.bits.clone());
    }
}

