/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.common;

import oz.util.barcode.NotFoundException;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.GridSampler;
import oz.util.barcode.common.PerspectiveTransform;

public final class DefaultGridSampler
extends GridSampler {
    @Override
    public BitMatrix sampleGrid(BitMatrix bitMatrix, int n, int n2, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17) {
        PerspectiveTransform perspectiveTransform = PerspectiveTransform.quadrilateralToQuadrilateral(f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17);
        return this.sampleGrid(bitMatrix, n, n2, perspectiveTransform);
    }

    @Override
    public BitMatrix sampleGrid(BitMatrix bitMatrix, int n, int n2, PerspectiveTransform perspectiveTransform) {
        if (n <= 0 || n2 <= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        BitMatrix bitMatrix2 = new BitMatrix(n, n2);
        float[] fArray = new float[2 * n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = fArray.length;
            float f2 = (float)n3 + 0.5f;
            int n5 = 0;
            while (n5 < n4) {
                fArray[n5] = (float)(n5 / 2) + 0.5f;
                fArray[n5 + 1] = f2;
                n5 += 2;
            }
            perspectiveTransform.transformPoints(fArray);
            DefaultGridSampler.checkAndNudgePoints(bitMatrix, fArray);
            try {
                n5 = 0;
                while (n5 < n4) {
                    if (bitMatrix.get((int)fArray[n5], (int)fArray[n5 + 1])) {
                        bitMatrix2.set(n5 / 2, n3);
                    }
                    n5 += 2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw NotFoundException.getNotFoundInstance();
            }
            ++n3;
        }
        return bitMatrix2;
    }
}

