/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.common.detector;

import oz.util.barcode.NotFoundException;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitMatrix;

public final class MonochromeRectangleDetector {
    private static final int MAX_MODULES = 32;
    private final BitMatrix image;

    public MonochromeRectangleDetector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    public ResultPoint[] detect() {
        int n = this.image.getHeight();
        int n2 = this.image.getWidth();
        int n3 = n / 2;
        int n4 = n2 / 2;
        int n5 = Math.max(1, n / 256);
        int n6 = Math.max(1, n2 / 256);
        int n7 = 0;
        int n8 = n;
        int n9 = 0;
        int n10 = n2;
        ResultPoint resultPoint = this.findCornerFromCenter(n4, 0, n9, n10, n3, -n5, n7, n8, n4 / 2);
        n7 = (int)resultPoint.getY() - 1;
        ResultPoint resultPoint2 = this.findCornerFromCenter(n4, -n6, n9, n10, n3, 0, n7, n8, n3 / 2);
        n9 = (int)resultPoint2.getX() - 1;
        ResultPoint resultPoint3 = this.findCornerFromCenter(n4, n6, n9, n10, n3, 0, n7, n8, n3 / 2);
        n10 = (int)resultPoint3.getX() + 1;
        ResultPoint resultPoint4 = this.findCornerFromCenter(n4, 0, n9, n10, n3, n5, n7, n8, n4 / 2);
        n8 = (int)resultPoint4.getY() + 1;
        resultPoint = this.findCornerFromCenter(n4, 0, n9, n10, n3, -n5, n7, n8, n4 / 4);
        return new ResultPoint[]{resultPoint, resultPoint2, resultPoint3, resultPoint4};
    }

    private ResultPoint findCornerFromCenter(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int[] nArray = null;
        int n10 = n5;
        int n11 = n;
        while (n10 < n8 && n10 >= n7 && n11 < n4 && n11 >= n3) {
            int[] nArray2 = n2 == 0 ? this.blackWhiteRange(n10, n9, n3, n4, true) : this.blackWhiteRange(n11, n9, n7, n8, false);
            if (nArray2 == null) {
                if (nArray == null) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (n2 == 0) {
                    int n12 = n10 - n6;
                    if (nArray[0] < n) {
                        if (nArray[1] > n) {
                            return new ResultPoint(nArray[n6 > 0 ? 0 : 1], n12);
                        }
                        return new ResultPoint(nArray[0], n12);
                    }
                    return new ResultPoint(nArray[1], n12);
                }
                int n13 = n11 - n2;
                if (nArray[0] < n5) {
                    if (nArray[1] > n5) {
                        return new ResultPoint(n13, nArray[n2 < 0 ? 0 : 1]);
                    }
                    return new ResultPoint(n13, nArray[0]);
                }
                return new ResultPoint(n13, nArray[1]);
            }
            nArray = nArray2;
            n10 += n6;
            n11 += n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private int[] blackWhiteRange(int n, int n2, int n3, int n4, boolean bl) {
        int[] nArray;
        int n5;
        int n6;
        int n7;
        int n8 = n7 = (n3 + n4) / 2;
        while (n8 >= n3) {
            if (bl ? this.image.get(n8, n) : this.image.get(n, n8)) {
                --n8;
                continue;
            }
            n6 = n8;
            while (--n8 >= n3 && !(bl ? this.image.get(n8, n) : this.image.get(n, n8))) {
            }
            n5 = n6 - n8;
            if (n8 >= n3 && n5 <= n2) continue;
            n8 = n6;
            break;
        }
        ++n8;
        n6 = n7;
        while (n6 < n4) {
            if (bl ? this.image.get(n6, n) : this.image.get(n, n6)) {
                ++n6;
                continue;
            }
            n5 = n6;
            while (++n6 < n4 && !(bl ? this.image.get(n6, n) : this.image.get(n, n6))) {
            }
            int n9 = n6 - n5;
            if (n6 < n4 && n9 <= n2) continue;
            n6 = n5;
            break;
        }
        if (--n6 > n8) {
            int[] nArray2 = new int[2];
            nArray2[0] = n8;
            nArray = nArray2;
            nArray2[1] = n6;
        } else {
            nArray = null;
        }
        return nArray;
    }
}

