/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.Dimension;
import oz.util.barcode.EncodeHintType;
import oz.util.barcode.Writer;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.datamatrix.encoder.DefaultPlacement;
import oz.util.barcode.datamatrix.encoder.ErrorCorrection;
import oz.util.barcode.datamatrix.encoder.HighLevelEncoder;
import oz.util.barcode.datamatrix.encoder.SymbolInfo;
import oz.util.barcode.datamatrix.encoder.SymbolShapeHint;
import oz.util.barcode.qrcode.QRCodeWriter;
import oz.util.barcode.qrcode.encoder.ByteMatrix;

public final class DataMatrixWriter
implements Writer {
    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        Object object;
        Object object2;
        Object object3;
        int n3 = 0;
        String string2 = "";
        boolean bl = false;
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (barcodeFormat != BarcodeFormat.DATA_MATRIX) {
            throw new IllegalArgumentException("Can only encode DATA_MATRIX, but got " + (Object)((Object)barcodeFormat));
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Requested dimensions can't be negative: " + n + 'x' + n2);
        }
        SymbolShapeHint symbolShapeHint = SymbolShapeHint.FORCE_NONE;
        Dimension dimension = null;
        Object object4 = null;
        if (map != null) {
            object3 = (SymbolShapeHint)((Object)map.get((Object)EncodeHintType.DATA_MATRIX_SHAPE));
            if (object3 != null) {
                symbolShapeHint = object3;
            }
            if ((object2 = (Dimension)map.get((Object)EncodeHintType.MIN_SIZE)) != null) {
                dimension = object2;
            }
            if ((object = (Dimension)map.get((Object)EncodeHintType.MAX_SIZE)) != null) {
                object4 = object;
            }
            if (map.containsKey((Object)EncodeHintType.MARGIN)) {
                n3 = Integer.parseInt(map.get((Object)EncodeHintType.MARGIN).toString());
            }
            if (map.containsKey((Object)EncodeHintType.CHARACTER_SET)) {
                string2 = map.get((Object)EncodeHintType.CHARACTER_SET).toString();
            }
            if (map.containsKey((Object)EncodeHintType.GS1_FORMAT)) {
                bl = (Boolean)map.get((Object)EncodeHintType.GS1_FORMAT);
            }
        }
        object3 = HighLevelEncoder.encodeHighLevel(string, symbolShapeHint, dimension, object4, string2, bl);
        object2 = SymbolInfo.lookup(((String)object3).length(), symbolShapeHint, dimension, object4, true);
        object = ErrorCorrection.encodeECC200((String)object3, (SymbolInfo)object2);
        DefaultPlacement defaultPlacement = new DefaultPlacement((CharSequence)object, ((SymbolInfo)object2).getSymbolDataWidth(), ((SymbolInfo)object2).getSymbolDataHeight());
        defaultPlacement.place();
        return DataMatrixWriter.encodeLowLevel(defaultPlacement, (SymbolInfo)object2, n, n2, n3);
    }

    private static BitMatrix encodeLowLevel(DefaultPlacement defaultPlacement, SymbolInfo symbolInfo, int n, int n2, int n3) {
        int n4 = symbolInfo.getSymbolDataWidth();
        int n5 = symbolInfo.getSymbolDataHeight();
        ByteMatrix byteMatrix = new ByteMatrix(symbolInfo.getSymbolWidth(), symbolInfo.getSymbolHeight());
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            int n8;
            int n9;
            if (n7 % symbolInfo.matrixHeight == 0) {
                n9 = 0;
                n8 = 0;
                while (n8 < symbolInfo.getSymbolWidth()) {
                    byteMatrix.set(n9, n6, n8 % 2 == 0);
                    ++n9;
                    ++n8;
                }
                ++n6;
            }
            n9 = 0;
            n8 = 0;
            while (n8 < n4) {
                if (n8 % symbolInfo.matrixWidth == 0) {
                    byteMatrix.set(n9, n6, true);
                    ++n9;
                }
                byteMatrix.set(n9, n6, defaultPlacement.getBit(n8, n7));
                ++n9;
                if (n8 % symbolInfo.matrixWidth == symbolInfo.matrixWidth - 1) {
                    byteMatrix.set(n9, n6, n7 % 2 == 0);
                    ++n9;
                }
                ++n8;
            }
            ++n6;
            if (n7 % symbolInfo.matrixHeight == symbolInfo.matrixHeight - 1) {
                n9 = 0;
                n8 = 0;
                while (n8 < symbolInfo.getSymbolWidth()) {
                    byteMatrix.set(n9, n6, true);
                    ++n9;
                    ++n8;
                }
                ++n6;
            }
            ++n7;
        }
        return QRCodeWriter.renderResult(byteMatrix, n, n2, n3);
    }

    private static BitMatrix convertByteMatrixToBitMatrix(ByteMatrix byteMatrix, int n, int n2) {
        BitMatrix bitMatrix;
        int n3 = byteMatrix.getWidth();
        int n4 = byteMatrix.getHeight();
        int n5 = Math.max(n, n3);
        int n6 = Math.max(n2, n4);
        int n7 = Math.min(n5 / n3, n6 / n4);
        int n8 = (n5 - n3 * n7) / 2;
        int n9 = (n6 - n4 * n7) / 2;
        if (n2 < n4 || n < n3) {
            n8 = 0;
            n9 = 0;
            bitMatrix = new BitMatrix(n3, n4);
        } else {
            bitMatrix = new BitMatrix(n, n2);
        }
        bitMatrix.clear();
        int n10 = 0;
        int n11 = n9;
        while (n10 < n4) {
            int n12 = 0;
            int n13 = n8;
            while (n12 < n3) {
                if (byteMatrix.get(n12, n10) == 1) {
                    bitMatrix.setRegion(n13, n11, n7, n7);
                }
                ++n12;
                n13 += n7;
            }
            ++n10;
            n11 += n7;
        }
        return bitMatrix;
    }
}

