/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.maxicode;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.DecodeHintType;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Reader;
import oz.util.barcode.Result;
import oz.util.barcode.ResultMetadataType;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.common.DecoderResult;
import oz.util.barcode.maxicode.decoder.Decoder;

public final class MaxiCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private static final int MATRIX_WIDTH = 30;
    private static final int MATRIX_HEIGHT = 33;
    private final Decoder decoder = new Decoder();

    @Override
    public Result decode(BinaryBitmap binaryBitmap) {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map map) {
        if (map == null || !map.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            throw NotFoundException.getNotFoundInstance();
        }
        Object object = MaxiCodeReader.extractPureBits(binaryBitmap.getBlackMatrix());
        DecoderResult decoderResult = this.decoder.decode((BitMatrix)object, map);
        object = new Result(decoderResult.getText(), decoderResult.getRawBytes(), NO_POINTS, BarcodeFormat.MAXICODE);
        String string = decoderResult.getECLevel();
        if (string != null) {
            ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string);
        }
        return object;
    }

    @Override
    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) {
        int[] nArray = bitMatrix.getEnclosingRectangle();
        if (nArray == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        BitMatrix bitMatrix2 = new BitMatrix(30, 33);
        int n5 = 0;
        while (n5 < 33) {
            int n6 = n2 + (n5 * n4 + n4 / 2) / 33;
            int n7 = 0;
            while (n7 < 30) {
                int n8 = n + (n7 * n3 + n3 / 2 + (n5 & 1) * n3 / 2) / 30;
                if (bitMatrix.get(n8, n6)) {
                    bitMatrix2.set(n7, n5);
                }
                ++n7;
            }
            ++n5;
        }
        return bitMatrix2;
    }
}

