/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.multi;

import java.util.Map;
import oz.util.barcode.BinaryBitmap;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Reader;
import oz.util.barcode.Result;
import oz.util.barcode.ResultPoint;

public final class ByQuadrantReader
implements Reader {
    private final Reader delegate;

    public ByQuadrantReader(Reader reader) {
        this.delegate = reader;
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map map) {
        int n = binaryBitmap.getWidth();
        int n2 = binaryBitmap.getHeight();
        int n3 = n / 2;
        int n4 = n2 / 2;
        try {
            return this.delegate.decode(binaryBitmap.crop(0, 0, n3, n4), map);
        }
        catch (NotFoundException notFoundException) {
            try {
                Result result = this.delegate.decode(binaryBitmap.crop(n3, 0, n3, n4), map);
                ByQuadrantReader.makeAbsolute(result.getResultPoints(), n3, 0);
                return result;
            }
            catch (NotFoundException notFoundException2) {
                try {
                    Result result = this.delegate.decode(binaryBitmap.crop(0, n4, n3, n4), map);
                    ByQuadrantReader.makeAbsolute(result.getResultPoints(), 0, n4);
                    return result;
                }
                catch (NotFoundException notFoundException3) {
                    try {
                        Result result = this.delegate.decode(binaryBitmap.crop(n3, n4, n3, n4), map);
                        ByQuadrantReader.makeAbsolute(result.getResultPoints(), n3, n4);
                        return result;
                    }
                    catch (NotFoundException notFoundException4) {
                        int n5 = n3 / 2;
                        int n6 = n4 / 2;
                        BinaryBitmap binaryBitmap2 = binaryBitmap.crop(n5, n6, n3, n4);
                        Result result = this.delegate.decode(binaryBitmap2, map);
                        ByQuadrantReader.makeAbsolute(result.getResultPoints(), n5, n6);
                        return result;
                    }
                }
            }
        }
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    private static void makeAbsolute(ResultPoint[] resultPointArray, int n, int n2) {
        if (resultPointArray != null) {
            int n3 = 0;
            while (n3 < resultPointArray.length) {
                ResultPoint resultPoint = resultPointArray[n3];
                resultPointArray[n3] = new ResultPoint(resultPoint.getX() + (float)n, resultPoint.getY() + (float)n2);
                ++n3;
            }
        }
    }
}

