/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import oz.util.barcode.oned.CodaBarReader;
import oz.util.barcode.oned.OneDimensionalCodeWriter;

public final class CodaBarWriter
extends OneDimensionalCodeWriter {
    private static final char[] START_END_CHARS = new char[]{'A', 'B', 'C', 'D'};
    private static final char[] ALT_START_END_CHARS = new char[]{'T', 'N', '*', 'E'};
    private static final char[] CHARS_WHICH_ARE_TEN_LENGTH_EACH_AFTER_DECODED = new char[]{'/', ':', '+', '.'};
    private static final char DEFAULT_GUARD = START_END_CHARS[0];

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean[] encode(String string) {
        int n;
        char c2;
        int n2;
        int n4;
        int n5;
        if (string.length() < 2) {
            string = String.valueOf(DEFAULT_GUARD) + string + DEFAULT_GUARD;
        } else {
            n5 = Character.toUpperCase(string.charAt(0));
            n4 = Character.toUpperCase(string.charAt(string.length() - 1));
            boolean n3 = CodaBarReader.arrayContains(START_END_CHARS, (char)n5);
            n2 = CodaBarReader.arrayContains(START_END_CHARS, (char)n4);
            c2 = CodaBarReader.arrayContains(ALT_START_END_CHARS, (char)n5);
            n = CodaBarReader.arrayContains(ALT_START_END_CHARS, (char)n4);
            if (n3) {
                if (n2 == 0) {
                    throw new IllegalArgumentException("Invalid start/end guards: " + string);
                }
            } else if (c2 != '\u0000') {
                if (n == 0) {
                    throw new IllegalArgumentException("Invalid start/end guards: " + string);
                }
            } else {
                if (n2 != 0 || n != 0) {
                    throw new IllegalArgumentException("Invalid start/end guards: " + string);
                }
                string = String.valueOf(DEFAULT_GUARD) + string + DEFAULT_GUARD;
            }
        }
        n5 = 20;
        n4 = 1;
        while (n4 < string.length() - 1) {
            if (Character.isDigit(string.charAt(n4)) || string.charAt(n4) == '-' || string.charAt(n4) == '$') {
                n5 += 9;
            } else if (CodaBarReader.arrayContains(CHARS_WHICH_ARE_TEN_LENGTH_EACH_AFTER_DECODED, string.charAt(n4))) {
                n5 += 10;
            } else {
                throw new IllegalArgumentException("Cannot encode : '" + string.charAt(n4) + '\'');
            }
            ++n4;
        }
        boolean[] blArray = new boolean[n5 += string.length() - 1];
        boolean bl = false;
        n2 = 0;
        while (n2 < string.length()) {
            void var4_7;
            c2 = Character.toUpperCase(string.charAt(n2));
            if (n2 == 0 || n2 == string.length() - 1) {
                switch (c2) {
                    case 'T': {
                        c2 = 'A';
                        break;
                    }
                    case 'N': {
                        c2 = 'B';
                        break;
                    }
                    case '*': {
                        c2 = 'C';
                        break;
                    }
                    case 'E': {
                        c2 = 'D';
                    }
                }
            }
            n = 0;
            int n3 = 0;
            while (n3 < CodaBarReader.ALPHABET.length) {
                if (c2 == CodaBarReader.ALPHABET[n3]) {
                    n = CodaBarReader.CHARACTER_ENCODINGS[n3];
                    break;
                }
                ++n3;
            }
            n3 = 1;
            int n6 = 0;
            int n7 = 0;
            while (n7 < 7) {
                blArray[var4_7] = n3;
                ++var4_7;
                if ((n >> 6 - n7 & 1) == 0 || n6 == 1) {
                    n3 = n3 != 0 ? 0 : 1;
                    ++n7;
                    n6 = 0;
                    continue;
                }
                ++n6;
            }
            if (n2 < string.length() - 1) {
                blArray[var4_7] = false;
                ++var4_7;
            }
            ++n2;
        }
        return blArray;
    }
}

