/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.oned.Code39Reader;
import oz.util.barcode.oned.OneDimensionalCodeWriter;

public final class Code39Writer
extends OneDimensionalCodeWriter {
    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.CODE_39) {
            throw new IllegalArgumentException("Can only encode CODE_39, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = string.length();
        if (n5 > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n5);
        }
        int n6 = 0;
        while (n6 < n5) {
            n4 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(string.charAt(n6));
            if (n4 < 0) {
                n5 = (string = Code39Writer.tryToConvertToExtendedMode(string)).length();
                if (n5 <= 80) break;
                throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n5 + " (extended full ASCII mode)");
            }
            ++n6;
        }
        int[] nArray = new int[9];
        n4 = 25 + n5;
        int n7 = 0;
        while (n7 < n5) {
            n3 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(string.charAt(n7));
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n3], nArray);
            int[] nArray2 = nArray;
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                int n8 = nArray2[n];
                n4 += n8;
                ++n;
            }
            ++n7;
        }
        boolean[] blArray = new boolean[n4];
        Code39Writer.toIntArray(148, nArray);
        n3 = Code39Writer.appendPattern(blArray, 0, nArray, true);
        int[] nArray3 = new int[]{1};
        n3 += Code39Writer.appendPattern(blArray, n3, nArray3, false);
        n = 0;
        while (n < n5) {
            n2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(string.charAt(n));
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n2], nArray);
            n3 += Code39Writer.appendPattern(blArray, n3, nArray, true);
            n3 += Code39Writer.appendPattern(blArray, n3, nArray3, false);
            ++n;
        }
        Code39Writer.toIntArray(148, nArray);
        Code39Writer.appendPattern(blArray, n3, nArray, true);
        return blArray;
    }

    private static void toIntArray(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < 9) {
            int n3 = n & 1 << 8 - n2;
            nArray[n2] = n3 == 0 ? 1 : 2;
            ++n2;
        }
    }

    private static String tryToConvertToExtendedMode(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '\u0000': {
                    stringBuilder.append("%U");
                    break;
                }
                case ' ': 
                case '-': 
                case '.': {
                    stringBuilder.append(c2);
                    break;
                }
                case '@': {
                    stringBuilder.append("%V");
                    break;
                }
                case '`': {
                    stringBuilder.append("%W");
                    break;
                }
                default: {
                    if (c2 <= '\u001a') {
                        stringBuilder.append('$');
                        stringBuilder.append((char)(65 + (c2 - '\u0001')));
                        break;
                    }
                    if (c2 < ' ') {
                        stringBuilder.append('%');
                        stringBuilder.append((char)(65 + (c2 - 27)));
                        break;
                    }
                    if (c2 <= ',' || c2 == '/' || c2 == ':') {
                        stringBuilder.append('/');
                        stringBuilder.append((char)(65 + (c2 - 33)));
                        break;
                    }
                    if (c2 <= '9') {
                        stringBuilder.append((char)(48 + (c2 - 48)));
                        break;
                    }
                    if (c2 <= '?') {
                        stringBuilder.append('%');
                        stringBuilder.append((char)(70 + (c2 - 59)));
                        break;
                    }
                    if (c2 <= 'Z') {
                        stringBuilder.append((char)(65 + (c2 - 65)));
                        break;
                    }
                    if (c2 <= '_') {
                        stringBuilder.append('%');
                        stringBuilder.append((char)(75 + (c2 - 91)));
                        break;
                    }
                    if (c2 <= 'z') {
                        stringBuilder.append('+');
                        stringBuilder.append((char)(65 + (c2 - 97)));
                        break;
                    }
                    if (c2 <= '\u007f') {
                        stringBuilder.append('%');
                        stringBuilder.append((char)(80 + (c2 - 123)));
                        break;
                    }
                    throw new IllegalArgumentException("Requested content contains a non-encodable character: '" + string.charAt(n2) + "'");
                }
            }
            ++n2;
        }
        return stringBuilder.toString();
    }
}

