/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Arrays;
import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.ChecksumException;
import oz.util.barcode.FormatException;
import oz.util.barcode.NotFoundException;
import oz.util.barcode.Result;
import oz.util.barcode.ResultPoint;
import oz.util.barcode.common.BitArray;
import oz.util.barcode.oned.OneDReader;

public final class Code93Reader
extends OneDReader {
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*";
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{276, 328, 324, 322, 296, 292, 290, 336, 274, 266, 424, 420, 418, 404, 402, 394, 360, 356, 354, 308, 282, 344, 332, 326, 300, 278, 436, 434, 428, 422, 406, 410, 364, 358, 310, 314, 302, 468, 466, 458, 366, 374, 430, 294, 474, 470, 306, 350};
    private static final int ASTERISK_ENCODING = CHARACTER_ENCODINGS[47];
    private final StringBuilder decodeRowResult = new StringBuilder(20);
    private final int[] counters = new int[6];

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map map) {
        int n2;
        int n3;
        int n4;
        int[] nArray;
        int n5;
        int n6;
        char c2;
        int[] nArray2 = this.findAsteriskPattern(bitArray);
        int n7 = bitArray.getNextSet(nArray2[1]);
        int n8 = bitArray.getSize();
        int[] nArray3 = this.counters;
        Arrays.fill(nArray3, 0);
        StringBuilder stringBuilder = this.decodeRowResult;
        stringBuilder.setLength(0);
        do {
            Code93Reader.recordPattern(bitArray, n7, nArray3);
            n6 = Code93Reader.toPattern(nArray3);
            if (n6 < 0) {
                throw NotFoundException.getNotFoundInstance();
            }
            c2 = Code93Reader.patternToChar(n6);
            stringBuilder.append(c2);
            n5 = n7;
            nArray = nArray3;
            n4 = nArray3.length;
            n3 = 0;
            while (n3 < n4) {
                n2 = nArray[n3];
                n7 += n2;
                ++n3;
            }
            n7 = bitArray.getNextSet(n7);
        } while (c2 != '*');
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        n6 = 0;
        nArray = nArray3;
        n4 = nArray3.length;
        n3 = 0;
        while (n3 < n4) {
            n2 = nArray[n3];
            n6 += n2;
            ++n3;
        }
        if (n7 == n8 || !bitArray.get(n7)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (stringBuilder.length() < 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        Code93Reader.checkChecksums(stringBuilder);
        stringBuilder.setLength(stringBuilder.length() - 2);
        String string = Code93Reader.decodeExtended(stringBuilder);
        float f2 = (float)(nArray2[1] + nArray2[0]) / 2.0f;
        float f3 = (float)n5 + (float)n6 / 2.0f;
        return new Result(string, null, new ResultPoint[]{new ResultPoint(f2, n), new ResultPoint(f3, n)}, BarcodeFormat.CODE_93);
    }

    private int[] findAsteriskPattern(BitArray bitArray) {
        int n = bitArray.getSize();
        int n2 = bitArray.getNextSet(0);
        Arrays.fill(this.counters, 0);
        int[] nArray = this.counters;
        int n3 = n2;
        boolean bl = false;
        int n4 = nArray.length;
        int n5 = 0;
        int n6 = n2;
        while (n6 < n) {
            if (bitArray.get(n6) != bl) {
                int n7 = n5;
                nArray[n7] = nArray[n7] + 1;
            } else {
                if (n5 == n4 - 1) {
                    if (Code93Reader.toPattern(nArray) == ASTERISK_ENCODING) {
                        return new int[]{n3, n6};
                    }
                    n3 += nArray[0] + nArray[1];
                    System.arraycopy(nArray, 2, nArray, 0, n5 - 1);
                    nArray[n5 - 1] = 0;
                    nArray[n5] = 0;
                    --n5;
                } else {
                    ++n5;
                }
                nArray[n5] = 1;
                bl = !bl;
            }
            ++n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toPattern(int[] nArray) {
        int n;
        int n2 = 0;
        int[] nArray2 = nArray;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            n = nArray2[n4];
            n2 += n;
            ++n4;
        }
        n = 0;
        n4 = nArray.length;
        n3 = 0;
        while (n3 < n4) {
            int n5 = Math.round((float)nArray[n3] * 9.0f / (float)n2);
            if (n5 < 1 || n5 > 4) {
                return -1;
            }
            if ((n3 & 1) == 0) {
                int n6 = 0;
                while (n6 < n5) {
                    n = n << 1 | 1;
                    ++n6;
                }
            } else {
                n <<= n5;
            }
            ++n3;
        }
        return n;
    }

    private static char patternToChar(int n) {
        int n2 = 0;
        while (n2 < CHARACTER_ENCODINGS.length) {
            if (CHARACTER_ENCODINGS[n2] == n) {
                return ALPHABET[n2];
            }
            ++n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(CharSequence charSequence) {
        int n = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            char c2 = charSequence.charAt(n2);
            if (c2 >= 'a' && c2 <= 'd') {
                if (n2 >= n - 1) {
                    throw FormatException.getFormatInstance();
                }
                char c3 = charSequence.charAt(n2 + 1);
                int n3 = 0;
                switch (c2) {
                    case 'd': {
                        if (c3 >= 'A' && c3 <= 'Z') {
                            n3 = (char)(c3 + 32);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 'a': {
                        if (c3 >= 'A' && c3 <= 'Z') {
                            n3 = (char)(c3 - 64);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 'b': {
                        if (c3 >= 'A' && c3 <= 'E') {
                            n3 = (char)(c3 - 38);
                            break;
                        }
                        if (c3 >= 'F' && c3 <= 'J') {
                            n3 = (char)(c3 - 11);
                            break;
                        }
                        if (c3 >= 'K' && c3 <= 'O') {
                            n3 = (char)(c3 + 16);
                            break;
                        }
                        if (c3 >= 'P' && c3 <= 'S') {
                            n3 = (char)(c3 + 43);
                            break;
                        }
                        if (c3 >= 'T' && c3 <= 'Z') {
                            n3 = 127;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 'c': {
                        if (c3 >= 'A' && c3 <= 'O') {
                            n3 = (char)(c3 - 32);
                            break;
                        }
                        if (c3 == 'Z') {
                            n3 = 58;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
                stringBuilder.append((char)n3);
                ++n2;
            } else {
                stringBuilder.append(c2);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static void checkChecksums(CharSequence charSequence) {
        int n = charSequence.length();
        Code93Reader.checkOneChecksum(charSequence, n - 2, 20);
        Code93Reader.checkOneChecksum(charSequence, n - 1, 15);
    }

    private static void checkOneChecksum(CharSequence charSequence, int n, int n2) {
        int n3 = 1;
        int n4 = 0;
        int n5 = n - 1;
        while (n5 >= 0) {
            n4 += n3 * ALPHABET_STRING.indexOf(charSequence.charAt(n5));
            if (++n3 > n2) {
                n3 = 1;
            }
            --n5;
        }
        if (charSequence.charAt(n) != ALPHABET[n4 % 47]) {
            throw ChecksumException.getChecksumInstance();
        }
    }
}

